dnl java.m4: Java autoconf macros.
dnl @synopsis AC_PROG_JAVA
dnl
dnl Here is a summary of the main macros:
dnl
dnl AC_PROG_JAVAC: finds a Java compiler.
dnl
dnl AC_PROG_JAVA: finds a Java virtual machine.
dnl
dnl AC_CHECK_CLASS: finds if we have the given class (beware of CLASSPATH!).
dnl
dnl AC_CHECK_RQRD_CLASS: finds if we have the given class and stops otherwise.
dnl
dnl AC_TRY_COMPILE_JAVA: attempt to compile user given source.
dnl
dnl AC_TRY_RUN_JAVA: attempt to compile and run user given source.
dnl
dnl AC_JAVA_OPTIONS: adds Java configure options.
dnl
dnl AC_PROG_JAVA tests an existing Java virtual machine. It uses the
dnl environment variable JAVA then tests in sequence various common Java
dnl virtual machines. For political reasons, it starts with the free ones.
dnl You *must* call [AC_PROG_JAVAC] before.
dnl
dnl If you want to force a specific VM:
dnl
dnl - at the configure.in level, set JAVA=yourvm before calling AC_PROG_JAVA
dnl   (but after AC_INIT)
dnl
dnl - at the configure level, setenv JAVA
dnl
dnl You can use the JAVA variable in your Makefile.in, with @JAVA@.
dnl
dnl *Warning*: its success or failure can depend on a proper setting of the
dnl CLASSPATH env. variable.
dnl
dnl TODO: allow to exclude virtual machines (rationale: most Java programs
dnl cannot run with some VM like kaffe).
dnl
dnl Note: This is part of the set of autoconf M4 macros for Java programs.
dnl It is VERY IMPORTANT that you download the whole set, some
dnl macros depend on other. Unfortunately, the autoconf archive does not
dnl support the concept of set of macros, so I had to break it for
dnl submission.
dnl
dnl A Web page, with a link to the latest CVS snapshot is at
dnl <http://www.internatif.org/bortzmeyer/autoconf-Java/>.
dnl
dnl This is a sample configure.in
dnl Process this file with autoconf to produce a configure script.
dnl
dnl    AC_INIT(UnTag.java)
dnl
dnl    dnl Checks for programs.
dnl    AC_CHECK_CLASSPATH
dnl    AC_PROG_JAVAC
dnl    AC_PROG_JAVA
dnl
dnl    dnl Checks for classes
dnl    AC_CHECK_RQRD_CLASS(org.xml.sax.Parser)
dnl    AC_CHECK_RQRD_CLASS(com.jclark.xml.sax.Driver)
dnl
dnl    AC_OUTPUT(Makefile)
dnl
dnl @author Stephane Bortzmeyer <bortzmeyer@pasteur.fr>
dnl @version $Id: acinclude.m4,v 1.1 2003/10/15 23:32:45 rsdio Exp $
dnl
AC_DEFUN(AC_PROG_JAVA,[
AC_REQUIRE([AC_EXEEXT])dnl
AC_ARG_VAR(JAVA,      [Java bytecode interpreter.])
AC_ARG_VAR(JAVAFLAGS, [Java interpreter run-time flags.])
if test x$JAVAPREFIX = x; then
	test x$JAVA = x && AC_CHECK_PROGS(JAVA, kaffe$EXEEXT java$EXEEXT)
else
	test x$JAVA = x && AC_CHECK_PROGS(JAVA, kaffe$EXEEXT java$EXEEXT, $JAVAPREFIX)
fi
test x$JAVA = x && AC_MSG_ERROR([no acceptable Java virtual machine found in \$PATH])
AC_PROG_JAVA_WORKS
AC_PROVIDE([$0])dnl
])
dnl @synopsis AC_CHECK_CLASS
dnl
dnl AC_CHECK_CLASS tests the existence of a given Java class, either in
dnl a jar or in a '.class' file.
dnl
dnl *Warning*: its success or failure can depend on a proper setting of the
dnl CLASSPATH env. variable.
dnl
dnl Note: This is part of the set of autoconf M4 macros for Java programs.
dnl It is VERY IMPORTANT that you download the whole set, some
dnl macros depend on other. Unfortunately, the autoconf archive does not
dnl support the concept of set of macros, so I had to break it for
dnl submission.
dnl The general documentation, as well as the sample configure.in, is
dnl included in the AC_PROG_JAVA macro.
dnl
dnl @author Stephane Bortzmeyer <bortzmeyer@pasteur.fr>
dnl @version $Id: acinclude.m4,v 1.1 2003/10/15 23:32:45 rsdio Exp $
dnl
AC_DEFUN(AC_CHECK_CLASS,[
AC_REQUIRE([AC_PROG_JAVA])
ac_var_name=`echo $1 | sed 's/\./_/g'`
dnl Normaly I'd use a AC_CACHE_CHECK here but since the variable name is
dnl dynamic I need an extra level of extraction
AC_MSG_CHECKING([for $1 class])
AC_CACHE_VAL(ac_cv_class_$ac_var_name, [
if test x$ac_cv_prog_uudecode_base64 = xyes; then
dnl /**
dnl  * Test.java: used to test dynamicaly if a class exists.
dnl  */
dnl public class Test
dnl {
dnl 
dnl public static void
dnl main( String[] argv )
dnl {
dnl 	Class lib;
dnl 	if (argv.length < 1)
dnl 	 {
dnl 		System.err.println ("Missing argument");
dnl 		System.exit (77);
dnl 	 }
dnl 	try
dnl 	 {
dnl 		lib = Class.forName (argv[0]);
dnl 	 }
dnl 	catch (ClassNotFoundException e)
dnl 	 {
dnl 		System.exit (1);
dnl 	 }
dnl 	lib = null;
dnl 	System.exit (0);
dnl }
dnl 
dnl }
cat << \EOF > Test.uue
begin-base64 644 Test.class
yv66vgADAC0AKQcAAgEABFRlc3QHAAQBABBqYXZhL2xhbmcvT2JqZWN0AQAE
bWFpbgEAFihbTGphdmEvbGFuZy9TdHJpbmc7KVYBAARDb2RlAQAPTGluZU51
bWJlclRhYmxlDAAKAAsBAANlcnIBABVMamF2YS9pby9QcmludFN0cmVhbTsJ
AA0ACQcADgEAEGphdmEvbGFuZy9TeXN0ZW0IABABABBNaXNzaW5nIGFyZ3Vt
ZW50DAASABMBAAdwcmludGxuAQAVKExqYXZhL2xhbmcvU3RyaW5nOylWCgAV
ABEHABYBABNqYXZhL2lvL1ByaW50U3RyZWFtDAAYABkBAARleGl0AQAEKEkp
VgoADQAXDAAcAB0BAAdmb3JOYW1lAQAlKExqYXZhL2xhbmcvU3RyaW5nOylM
amF2YS9sYW5nL0NsYXNzOwoAHwAbBwAgAQAPamF2YS9sYW5nL0NsYXNzBwAi
AQAgamF2YS9sYW5nL0NsYXNzTm90Rm91bmRFeGNlcHRpb24BAAY8aW5pdD4B
AAMoKVYMACMAJAoAAwAlAQAKU291cmNlRmlsZQEACVRlc3QuamF2YQAhAAEA
AwAAAAAAAgAJAAUABgABAAcAAABtAAMAAwAAACkqvgSiABCyAAwSD7YAFBBN
uAAaKgMyuAAeTKcACE0EuAAaAUwDuAAasQABABMAGgAdACEAAQAIAAAAKgAK
AAAACgAAAAsABgANAA4ADgATABAAEwASAB4AFgAiABgAJAAZACgAGgABACMA
JAABAAcAAAAhAAEAAQAAAAUqtwAmsQAAAAEACAAAAAoAAgAAAAQABAAEAAEA
JwAAAAIAKA==
====
EOF
		if uudecode$EXEEXT Test.uue; then
			:
		else
			echo "configure: __oline__: uudecode had trouble decoding base 64 file 'Test.uue'" >&AC_FD_CC
			echo "configure: failed file was:" >&AC_FD_CC
			cat Test.uue >&AC_FD_CC
			ac_cv_prog_uudecode_base64=no
		fi
	rm -f Test.uue
	if AC_TRY_COMMAND($JAVA $JAVAFLAGS Test $1) >/dev/null 2>&1; then
		eval "ac_cv_class_$ac_var_name=yes"
	else
		eval "ac_cv_class_$ac_var_name=no"
	fi
	rm -f Test.class
else
	AC_TRY_COMPILE_JAVA([$1], , [eval "ac_cv_class_$ac_var_name=yes"],
		[eval "ac_cv_class_$ac_var_name=no"])
fi
eval "ac_var_val=$`eval echo ac_cv_class_$ac_var_name`"
eval "HAVE_$ac_var_name=$`echo ac_cv_class_$ac_var_val`"
HAVE_LAST_CLASS=$ac_var_val
if test x$ac_var_val = xyes; then
	ifelse([$2], , :, [$2])
else
	ifelse([$3], , :, [$3])
fi
])
dnl for some reason the above statment didn't fall though here?
dnl do scripts have variable scoping?
eval "ac_var_val=$`eval echo ac_cv_class_$ac_var_name`"
AC_MSG_RESULT($ac_var_val)
])

dnl @synopsis AC_CHECK_CLASSPATH
dnl
dnl AC_CHECK_CLASSPATH just displays the CLASSPATH, for the edification
dnl of the user.
dnl
dnl Note: This is part of the set of autoconf M4 macros for Java programs.
dnl It is VERY IMPORTANT that you download the whole set, some
dnl macros depend on other. Unfortunately, the autoconf archive does not
dnl support the concept of set of macros, so I had to break it for
dnl submission.
dnl The general documentation, as well as the sample configure.in, is
dnl included in the AC_PROG_JAVA macro.
dnl
dnl @author Stephane Bortzmeyer <bortzmeyer@pasteur.fr>
dnl @version $Id: acinclude.m4,v 1.1 2003/10/15 23:32:45 rsdio Exp $
dnl
AC_DEFUN(AC_CHECK_CLASSPATH,[
AC_ARG_VAR(CLASSPATH, [Path to extra class libraries.])
if test "x$CLASSPATH" = x; then
        echo "You have no CLASSPATH, I hope it is good"
else
        echo "You have CLASSPATH $CLASSPATH, hope it is correct"
fi
])



dnl @synopsis AC_CHECK_RQRD_CLASS
dnl
dnl AC_CHECK_RQRD_CLASS tests the existence of a given Java class, either in
dnl a jar or in a '.class' file and fails if it doesn't exist.
dnl Its success or failure can depend on a proper setting of the
dnl CLASSPATH env. variable.
dnl
dnl Note: This is part of the set of autoconf M4 macros for Java programs.
dnl It is VERY IMPORTANT that you download the whole set, some
dnl macros depend on other. Unfortunately, the autoconf archive does not
dnl support the concept of set of macros, so I had to break it for
dnl submission.
dnl The general documentation, as well as the sample configure.in, is
dnl included in the AC_PROG_JAVA macro.
dnl
dnl @author Stephane Bortzmeyer <bortzmeyer@pasteur.fr>
dnl @version $Id: acinclude.m4,v 1.1 2003/10/15 23:32:45 rsdio Exp $
dnl

AC_DEFUN(AC_CHECK_RQRD_CLASS,[
CLASS=`echo $1|sed 's/\./_/g'`
AC_CHECK_CLASS($1)
if test "$HAVE_LAST_CLASS" = "no"; then
        AC_MSG_ERROR([Required class $1 missing, exiting.])
fi
])
dnl @synopsis AC_JAVA_OPTIONS
dnl
dnl AC_JAVA_OPTIONS adds configure command line options used for Java m4
dnl macros. This Macro is optional.
dnl
dnl Note: This is part of the set of autoconf M4 macros for Java programs.
dnl It is VERY IMPORTANT that you download the whole set, some
dnl macros depend on other. Unfortunately, the autoconf archive does not
dnl support the concept of set of macros, so I had to break it for
dnl submission.
dnl The general documentation, as well as the sample configure.in, is
dnl included in the AC_PROG_JAVA macro.
dnl
dnl @author Devin Weaver <ktohg@tritarget.com>
dnl @version $Id: acinclude.m4,v 1.1 2003/10/15 23:32:45 rsdio Exp $
dnl
AC_DEFUN(AC_JAVA_OPTIONS,[
AC_ARG_WITH(java-prefix,
	AC_HELP_STRING([--with-java-prefix=PFX],[prefix where Java runtime is installed (optional)]))
AC_ARG_WITH(javac-flags,
	AC_HELP_STRING([--with-javac-flags=FLAGS],[flags to pass to the Java compiler (optional)]))
AC_ARG_WITH(java-flags,
	AC_HELP_STRING([--with-java-flags=FLAGS],[flags to pass to the Java VM (optional)]))
JAVAPREFIX=$with_java_prefix
JAVACFLAGS=$with_javac_flags
JAVAFLAGS=$with_java_flags
AC_SUBST(JAVAPREFIX)dnl
AC_SUBST(JAVACFLAGS)dnl
AC_SUBST(JAVAFLAGS)dnl
AC_SUBST(JAVA)dnl
AC_SUBST(JAVAC)dnl
])
dnl @synopsis AC_PROG_JAVA_WORKS
dnl
dnl Internal use ONLY.
dnl
dnl Note: This is part of the set of autoconf M4 macros for Java programs.
dnl It is VERY IMPORTANT that you download the whole set, some
dnl macros depend on other. Unfortunately, the autoconf archive does not
dnl support the concept of set of macros, so I had to break it for
dnl submission.
dnl The general documentation, as well as the sample configure.in, is
dnl included in the AC_PROG_JAVA macro.
dnl
dnl @author Stephane Bortzmeyer <bortzmeyer@pasteur.fr>
dnl @version $Id: acinclude.m4,v 1.1 2003/10/15 23:32:45 rsdio Exp $
dnl
AC_DEFUN(AC_PROG_JAVA_WORKS, [
AC_CHECK_PROG(uudecode, uudecode$EXEEXT, yes)
if test x$uudecode = xyes; then
AC_CACHE_CHECK([if uudecode can decode base 64 file], ac_cv_prog_uudecode_base64, [
dnl /**
dnl  * Test.java: used to test if java compiler works.
dnl  */
dnl public class Test
dnl {
dnl 
dnl public static void
dnl main( String[] argv )
dnl {
dnl 	System.exit (0);
dnl }
dnl 
dnl }
cat << \EOF > Test.uue
begin-base64 644 Test.class
yv66vgADAC0AFQcAAgEABFRlc3QHAAQBABBqYXZhL2xhbmcvT2JqZWN0AQAE
bWFpbgEAFihbTGphdmEvbGFuZy9TdHJpbmc7KVYBAARDb2RlAQAPTGluZU51
bWJlclRhYmxlDAAKAAsBAARleGl0AQAEKEkpVgoADQAJBwAOAQAQamF2YS9s
YW5nL1N5c3RlbQEABjxpbml0PgEAAygpVgwADwAQCgADABEBAApTb3VyY2VG
aWxlAQAJVGVzdC5qYXZhACEAAQADAAAAAAACAAkABQAGAAEABwAAACEAAQAB
AAAABQO4AAyxAAAAAQAIAAAACgACAAAACgAEAAsAAQAPABAAAQAHAAAAIQAB
AAEAAAAFKrcAErEAAAABAAgAAAAKAAIAAAAEAAQABAABABMAAAACABQ=
====
EOF
if uudecode$EXEEXT Test.uue; then
	ac_cv_prog_uudecode_base64=yes
else
	echo "configure: __oline__: uudecode had trouble decoding base 64 file 'Test.uue'" >&AC_FD_CC
	echo "configure: failed file was:" >&AC_FD_CC
	cat Test.uue >&AC_FD_CC
	ac_cv_prog_uudecode_base64=no
fi
rm -f Test.uue])
fi
if test x$ac_cv_prog_uudecode_base64 != xyes; then
	rm -f Test.class
	AC_MSG_WARN([I have to compile Test.class from scratch])
	if test x$ac_cv_prog_javac_works = xno; then
		AC_MSG_ERROR([Cannot compile java source. $JAVAC does not work properly])
	fi
	if test x$ac_cv_prog_javac_works = x; then
		AC_PROG_JAVAC
	fi
fi
AC_CACHE_CHECK(if $JAVA works, ac_cv_prog_java_works, [
JAVA_TEST=Test.java
CLASS_TEST=Test.class
TEST=Test
changequote(, )dnl
cat << \EOF > $JAVA_TEST
/* [#]line __oline__ "configure" */
public class Test {
public static void main (String args[]) {
	System.exit (0);
} }
EOF
changequote([, ])dnl
if test x$ac_cv_prog_uudecode_base64 != xyes; then
	if AC_TRY_COMMAND($JAVAC $JAVACFLAGS $JAVA_TEST) && test -s $CLASS_TEST; then
		:
	else
	  echo "configure: failed program was:" >&AC_FD_CC
	  cat $JAVA_TEST >&AC_FD_CC
	  AC_MSG_ERROR(The Java compiler $JAVAC failed (see config.log, check the CLASSPATH?))
	fi
fi
if AC_TRY_COMMAND($JAVA $JAVAFLAGS $TEST) >/dev/null 2>&1; then
  ac_cv_prog_java_works=yes
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat $JAVA_TEST >&AC_FD_CC
  AC_MSG_ERROR(The Java VM $JAVA failed (see config.log, check the CLASSPATH?))
fi
rm -fr $JAVA_TEST $CLASS_TEST Test.uue
])
AC_PROVIDE([$0])dnl
]
)

dnl @synopsis AC_PROG_JAVAC
dnl
dnl AC_PROG_JAVAC tests an existing Java compiler. It uses the environment
dnl variable JAVAC then tests in sequence various common Java compilers. For
dnl political reasons, it starts with the free ones.
dnl
dnl If you want to force a specific compiler:
dnl
dnl - at the configure.in level, set JAVAC=yourcompiler before calling
dnl AC_PROG_JAVAC
dnl
dnl - at the configure level, setenv JAVAC
dnl
dnl You can use the JAVAC variable in your Makefile.in, with @JAVAC@.
dnl
dnl *Warning*: its success or failure can depend on a proper setting of the
dnl CLASSPATH env. variable.
dnl
dnl TODO: allow to exclude compilers (rationale: most Java programs cannot compile
dnl with some compilers like guavac).
dnl
dnl Note: This is part of the set of autoconf M4 macros for Java programs.
dnl It is VERY IMPORTANT that you download the whole set, some
dnl macros depend on other. Unfortunately, the autoconf archive does not
dnl support the concept of set of macros, so I had to break it for
dnl submission.
dnl The general documentation, as well as the sample configure.in, is
dnl included in the AC_PROG_JAVA macro.
dnl
dnl @author Stephane Bortzmeyer <bortzmeyer@pasteur.fr>
dnl @version $Id: acinclude.m4,v 1.1 2003/10/15 23:32:45 rsdio Exp $
dnl
AC_DEFUN(AC_PROG_JAVAC,[
AC_REQUIRE([AC_EXEEXT])dnl
AC_ARG_VAR(JAVAC,      [Java bytecode compiler.])
AC_ARG_VAR(JAVACFLAGS, [Extra flags for the java compiler.])
if test "x$JAVAPREFIX" = x; then
	test "x$JAVAC" = x && AC_CHECK_PROGS(JAVAC, "gcj$EXEEXT -C" guavac$EXEEXT jikes$EXEEXT javac$EXEEXT)
else
	test "x$JAVAC" = x && AC_CHECK_PROGS(JAVAC, "gcj$EXEEXT -C" guavac$EXEEXT jikes$EXEEXT javac$EXEEXT, $JAVAPREFIX)
fi
test "x$JAVAC" = x && AC_MSG_ERROR([no acceptable Java compiler found in \$PATH])
AC_PROG_JAVAC_WORKS
AC_PROVIDE([$0])dnl
])

dnl @synopsis AC_PROG_JAVAC_WORKS
dnl
dnl Internal use ONLY.
dnl
dnl Note: This is part of the set of autoconf M4 macros for Java programs.
dnl It is VERY IMPORTANT that you download the whole set, some
dnl macros depend on other. Unfortunately, the autoconf archive does not
dnl support the concept of set of macros, so I had to break it for
dnl submission.
dnl The general documentation, as well as the sample configure.in, is
dnl included in the AC_PROG_JAVA macro.
dnl
dnl @author Stephane Bortzmeyer <bortzmeyer@pasteur.fr>
dnl @version $Id: acinclude.m4,v 1.1 2003/10/15 23:32:45 rsdio Exp $
dnl
AC_DEFUN(AC_PROG_JAVAC_WORKS,[
AC_CACHE_CHECK([if $JAVAC works], ac_cv_prog_javac_works, [
JAVA_TEST=Test.java
CLASS_TEST=Test.class
cat << \EOF > $JAVA_TEST
/* [#]line __oline__ "configure" */
public class Test {
}
EOF
if AC_TRY_COMMAND($JAVAC $JAVACFLAGS $JAVA_TEST) >/dev/null 2>&1; then
  ac_cv_prog_javac_works=yes
else
  AC_MSG_ERROR([The Java compiler $JAVAC failed (see config.log, check the CLASSPATH?)])
  echo "configure: failed program was:" >&AC_FD_CC
  cat $JAVA_TEST >&AC_FD_CC
fi
rm -f $JAVA_TEST $CLASS_TEST
])
AC_PROVIDE([$0])dnl
])
dnl @synopsis AC_TRY_COMPILE_JAVA
dnl
dnl AC_TRY_COMPILE_JAVA attempt to compile user given source.
dnl
dnl *Warning*: its success or failure can depend on a proper setting of the
dnl CLASSPATH env. variable.
dnl
dnl Note: This is part of the set of autoconf M4 macros for Java programs.
dnl It is VERY IMPORTANT that you download the whole set, some
dnl macros depend on other. Unfortunately, the autoconf archive does not
dnl support the concept of set of macros, so I had to break it for
dnl submission.
dnl The general documentation, as well as the sample configure.in, is
dnl included in the AC_PROG_JAVA macro.
dnl
dnl @author Devin Weaver <ktohg@tritarget.com>
dnl @version $Id: acinclude.m4,v 1.1 2003/10/15 23:32:45 rsdio Exp $
dnl
AC_DEFUN(AC_TRY_COMPILE_JAVA,[
AC_REQUIRE([AC_PROG_JAVAC])dnl
cat << \EOF > Test.java
/* [#]line __oline__ "configure" */
ifelse([$1], , , [import $1;])
public class Test {
[$2]
}
EOF
if AC_TRY_COMMAND($JAVAC $JAVACFLAGS Test.java) && test -s Test.class
then
dnl Don't remove the temporary files here, so they can be examined.
  ifelse([$3], , :, [$3])
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat Test.java >&AC_FD_CC
ifelse([$4], , , [  rm -fr Test*
  $4
])dnl
fi
rm -fr Test*])
dnl @synopsis AC_TRY_RUN_JAVA
dnl
dnl AC_TRY_RUN_JAVA attempt to compile and run user given source.
dnl
dnl *Warning*: its success or failure can depend on a proper setting of the
dnl CLASSPATH env. variable.
dnl
dnl Note: This is part of the set of autoconf M4 macros for Java programs.
dnl It is VERY IMPORTANT that you download the whole set, some
dnl macros depend on other. Unfortunately, the autoconf archive does not
dnl support the concept of set of macros, so I had to break it for
dnl submission.
dnl The general documentation, as well as the sample configure.in, is
dnl included in the AC_PROG_JAVA macro.
dnl
dnl @author Devin Weaver <ktohg@tritarget.com>
dnl @version $Id: acinclude.m4,v 1.1 2003/10/15 23:32:45 rsdio Exp $
dnl
AC_DEFUN(AC_TRY_RUN_JAVA,[
AC_REQUIRE([AC_PROG_JAVAC])dnl
AC_REQUIRE([AC_PROG_JAVA])dnl
cat << \EOF > Test.java
/* [#]line __oline__ "configure" */
ifelse([$1], , , [include $1;])
public class Test {
[$2]
}
EOF
if AC_TRY_COMMAND($JAVAC $JAVACFLAGS Test.java) && test -s Test.class && ($JAVA $JAVAFLAGS Test; exit) 2>/dev/null
then
dnl Don't remove the temporary files here, so they can be examined.
  ifelse([$3], , :, [$3])
else
  echo "configure: failed program was:" >&AC_FD_CC
  cat Test.java >&AC_FD_CC
ifelse([$4], , , [  rm -fr Test*
  $4
])dnl
fi
rm -fr Test*])

dnl AC_CHECK_PATH_SEPARATOR
dnl
dnl Determines the strings used to separate paths (e.g. ':') and
dnl directories (e.g. '/').
dnl
AC_DEFUN([AC_CHECK_PATH_SEPARATOR],[
AC_REQUIRE([AC_PROG_JAVA])
AC_MSG_CHECKING([for the system path separator])
AC_CACHE_VAL(ac_cv_path_separator, [
if test x$ac_cv_prog_uudecode_base64 = xyes; then
dnl class pathtest {
dnl    public static void main(String[] argv) {
dnl       System.out.println(System.getProperty("path.separator"));
dnl    }
dnl }
cat << \EOF > pathtest.uue
begin-base64 640 pathtest.class
yv66vgADAC0AIQcAAgEACHBhdGh0ZXN0BwAEAQAQamF2YS9sYW5nL09iamVj
dAEABG1haW4BABYoW0xqYXZhL2xhbmcvU3RyaW5nOylWAQAEQ29kZQEAD0xp
bmVOdW1iZXJUYWJsZQwACgALAQADb3V0AQAVTGphdmEvaW8vUHJpbnRTdHJl
YW07CQANAAkHAA4BABBqYXZhL2xhbmcvU3lzdGVtCAAQAQAOcGF0aC5zZXBh
cmF0b3IMABIAEwEAC2dldFByb3BlcnR5AQAmKExqYXZhL2xhbmcvU3RyaW5n
OylMamF2YS9sYW5nL1N0cmluZzsKAA0AEQwAFgAXAQAHcHJpbnRsbgEAFShM
amF2YS9sYW5nL1N0cmluZzspVgoAGQAVBwAaAQATamF2YS9pby9QcmludFN0
cmVhbQEABjxpbml0PgEAAygpVgwAGwAcCgADAB0BAApTb3VyY2VGaWxlAQAN
cGF0aHRlc3QuamF2YQAgAAEAAwAAAAAAAgAJAAUABgABAAcAAAAoAAIAAQAA
AAyyAAwSD7gAFLYAGLEAAAABAAgAAAAKAAIAAAADAAsABAAAABsAHAABAAcA
AAAhAAEAAQAAAAUqtwAesQAAAAEACAAAAAoAAgAAAAEABAABAAEAHwAAAAIA
IA==
====
EOF
		if uudecode$EXEEXT pathtest.uue; then
			:
		else
			echo "configure: __oline__: uudecode had trouble decoding base 64 file 'pathtest.uue'" >&AC_FD_CC
			echo "configure: failed file was:" >&AC_FD_CC
			cat pathtest.uue >&AC_FD_CC
			ac_cv_prog_uudecode_base64=no
		fi
	rm -f pathtest.uue
	ac_cv_path_separator=$($JAVA $JAVAFLAGS pathtest)
	rm -f pathtest.class
	])
AC_MSG_RESULT([$ac_cv_path_separator])
PATH_SEPARATOR=$ac_cv_path_separator
fi
])

dnl AC_CHECK_FILE_SEPARATOR
dnl
dnl Determines the strings used to separate files (e.g. '/').
dnl
AC_DEFUN([AC_CHECK_FILE_SEPARATOR],[
AC_REQUIRE([AC_PROG_JAVA])
AC_MSG_CHECKING([for the system file separator])
AC_CACHE_VAL(ac_cv_file_separator, [
if test x$ac_cv_prog_uudecode_base64 = xyes; then
dnl class filetest {
dnl    public static void main(String[] argv) {
dnl       System.out.println(System.getProperty("file.separator"));
dnl    }
dnl }
cat << \EOF > filetest.uue
begin-base64 644 filetest.class
yv66vgADAC0AIQcAAgEACGZpbGV0ZXN0BwAEAQAQamF2YS9sYW5nL09iamVj
dAEABG1haW4BABYoW0xqYXZhL2xhbmcvU3RyaW5nOylWAQAEQ29kZQEAD0xp
bmVOdW1iZXJUYWJsZQwACgALAQADb3V0AQAVTGphdmEvaW8vUHJpbnRTdHJl
YW07CQANAAkHAA4BABBqYXZhL2xhbmcvU3lzdGVtCAAQAQAOZmlsZS5zZXBh
cmF0b3IMABIAEwEAC2dldFByb3BlcnR5AQAmKExqYXZhL2xhbmcvU3RyaW5n
OylMamF2YS9sYW5nL1N0cmluZzsKAA0AEQwAFgAXAQAHcHJpbnRsbgEAFShM
amF2YS9sYW5nL1N0cmluZzspVgoAGQAVBwAaAQATamF2YS9pby9QcmludFN0
cmVhbQEABjxpbml0PgEAAygpVgwAGwAcCgADAB0BAApTb3VyY2VGaWxlAQAN
ZmlsZXRlc3QuamF2YQAgAAEAAwAAAAAAAgAJAAUABgABAAcAAAAoAAIAAQAA
AAyyAAwSD7gAFLYAGLEAAAABAAgAAAAKAAIAAAADAAsABAAAABsAHAABAAcA
AAAhAAEAAQAAAAUqtwAesQAAAAEACAAAAAoAAgAAAAEABAABAAEAHwAAAAIA
IA==
====
EOF
		if uudecode$EXEEXT filetest.uue; then
			:
		else
			echo "configure: __oline__: uudecode had trouble decoding base 64 file 'filetest.uue'" >&AC_FD_CC
			echo "configure: failed file was:" >&AC_FD_CC
			cat filetest.uue >&AC_FD_CC
			ac_cv_prog_uudecode_base64=no
		fi
	rm -f filetest.uue
	ac_cv_file_separator=$($JAVA $JAVAFLAGS filetest)
	rm -f filetest.class
	])
AC_MSG_RESULT([$ac_cv_file_separator])
if test $ac_cv_file_separator = '\\'; then
	ac_cv_file_separator=\\\\
fi
FILE_SEPARATOR=$ac_cv_file_separator
fi
])

dnl @synopsis AC_PROG_JAR
dnl
AC_DEFUN(AC_PROG_JAR,[
AC_REQUIRE([AC_EXEEXT])dnl
AC_ARG_VAR(JAR,      [Java archiver.])
test "x$JAR" = x && AC_CHECK_PROGS(JAR, "jar$EXEEXT")
test "x$JAR" = x && AC_MSG_ERROR([no acceptable Java archiver found in \$PATH])
AC_PROVIDE([$0])dnl
])

AC_DEFUN([JESSIE_CHECK_14_SOCKETS],[
AC_REQUIRE([AC_PROG_JAVA])
AC_MSG_CHECKING([for Java 1.4 socket API methods])
if test x$ac_cv_prog_uudecode_base64 = xyes; then
dnl public class checksocket
dnl {
dnl   public static void main(String[] argv)
dnl   {
dnl     try
dnl       {
dnl         Class clazz = java.net.Socket.class;
dnl         clazz.getMethod("getRemoteSocketAddress", null);
dnl         clazz.getMethod("setOOBInline", new Class[] { Boolean.TYPE } );
dnl         clazz.getMethod("getOOBInline", null);
dnl         clazz.getMethod("setKeepAlive", new Class[] { Boolean.TYPE } );
dnl         clazz.getMethod("getKeepAlive", null);
dnl         clazz.getMethod("setTrafficClass", new Class[] { Integer.TYPE } );
dnl         clazz.getMethod("getTrafficClass", null);
dnl         clazz.getMethod("setReuseAddress", new Class[] { Boolean.TYPE } );
dnl         clazz.getMethod("getReuseAddress", null);
dnl         clazz.getMethod("shutdownInput", null);
dnl         clazz.getMethod("shutdownOutput", null);
dnl         clazz.getMethod("isConnected", null);
dnl         clazz.getMethod("isInputShutdown", null);
dnl         clazz.getMethod("isOutputShutdown", null);
dnl         System.exit(0);
dnl       }
dnl     catch (Exception x)
dnl       {
dnl         System.exit(1);
dnl       }
dnl   }
dnl }
cat << \EOF > checksocket.uue
begin-base64 644 checksocket.class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====
EOF

  if uudecode$EXEEXT checksocket.uue; then
    :
  else
    echo "configure: __oline__: uudecode had trouble decoding base 64 file 'checksocket.uue'" >&AC_FD_CC
    echo "configure: failed file was:" >&AC_FD_CC
    cat checksocket.uue >&AC_FD_CC
    ac_cv_prog_uudecode_base64=no
  fi
  rm -f checksocket.uue
  if $JAVA $JAVAFLAGS checksocket; then
    have_14_sockets=yes
  else
    have_14_sockets=no
  fi
  AC_MSG_RESULT([$have_14_sockets])
  rm -f checksocket.class
fi
AM_CONDITIONAL([HAVE_14_SOCKETS], test x$have_14_sockets = xyes)
])
