/* SRPManagerParameters.java -- Wrapper for SRP PasswordFile.
   Copyright (C) 2003  Casey Marshall <rsdio@metastatic.org>

This file is a part of Jessie.

Jessie is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Jessie is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with Jessie; if not, write to the

   Free Software Foundation, Inc.,
   59 Temple Place, Suite 330,
   Boston, MA  02111-1307
   USA  */


package org.metastatic.jessie;

import javax.net.ssl.ManagerFactoryParameters;
import gnu.crypto.sasl.srp.PasswordFile;

/**
 * Instances of this class are used to initialize {@link
 * javax.net.ssl.TrustManagerFactory} instances for the ``SRP'' algorithm.
 */
public class SRPManagerParameters implements ManagerFactoryParameters
{

  // Field.
  // -------------------------------------------------------------------------

  private final PasswordFile file;

  // Constructor.
  // -------------------------------------------------------------------------

  /**
   * Initializes these parameters with the specified SRP password file.
   *
   * @param file The SRP password file object.
   * @throws NullPointerException if <i>file</i> is <code>null</code>.
   */
  public SRPManagerParameters(PasswordFile file)
  {
    if (file == null)
      {
        throw new NullPointerException();
      }
    this.file = file;
  }

  // Instance method.
  // -------------------------------------------------------------------------

  public PasswordFile getPasswordFile()
  {
    return file;
  }
}
