/* JessieDHPublicKey.java -- simple DH public key.
   Copyright (C) 2003  Casey Marshall <rsdio@metastatic.org>

This file is a part of Jessie.

Jessie is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Jessie is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with Jessie; if not, write to the

   Free Software Foundation, Inc.,
   59 Temple Place, Suite 330,
   Boston, MA  02111-1307
   USA  */


package org.metastatic.jessie.provider;

import java.math.BigInteger;

import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;

class JessieDHPublicKey implements DHPublicKey
{

  // Fields.
  // -------------------------------------------------------------------------

  private final DHParameterSpec params;
  private final BigInteger y;

  // Constructor.
  // -------------------------------------------------------------------------

  JessieDHPublicKey(DHParameterSpec params, BigInteger y)
  {
    this.params = params;
    this.y = y;
  }

  // Instance methods.
  // -------------------------------------------------------------------------

  public String getAlgorithm()
  {
    return "Diffie-Hellman";
  }

  public String getFormat()
  {
    return "NONE";
  }

  public byte[] getEncoded()
  {
    return null;
  }

  public DHParameterSpec getParams()
  {
    return params;
  }

  public BigInteger getY()
  {
    return y;
  }

  public String toString()
  {
    String nl = System.getProperty("line.separator");
    return "P: " + params.getP() + nl +
      "G: " + params.getG() + nl +
      "Y: " + y;
  }
}
