/* Random.java -- SSL Random structure.
   Copyright (C) 2003  Casey Marshall <rsdio@metastatic.org>

This file is a part of Jessie.

Jessie is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

Jessie is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License along
with Jessie; if not, write to the

   Free Software Foundation, Inc.,
   59 Temple Place, Suite 330,
   Boston, MA  02111-1307
   USA  */


package org.metastatic.jessie.provider;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

class Random implements Constructed
{

  // Fields.
  // -------------------------------------------------------------------------

  private final int gmtUnixTime;
  private final byte[] randomBytes;

  // Constructors.
  // -------------------------------------------------------------------------

  Random(int gmtUnixTime, byte[] randomBytes)
  {
    this.gmtUnixTime = gmtUnixTime;
    this.randomBytes = (byte[]) randomBytes.clone();
  }

  // Class methods.
  // -------------------------------------------------------------------------

  static Random read(InputStream in) throws IOException
  {
    int time = (in.read() & 0xFF) << 24 | (in.read() & 0xFF) << 16
             | (in.read() & 0xFF) <<  8 | (in.read() & 0xFF);
    byte[] buf = new byte[28];
    in.read(buf);
    return new Random(time, buf);
  }

  // Instance methods.
  // -------------------------------------------------------------------------

  public void write(OutputStream out) throws IOException
  {
    out.write((gmtUnixTime >>> 24) & 0xFF);
    out.write((gmtUnixTime >>> 16) & 0xFF);
    out.write((gmtUnixTime >>>  8) & 0xFF);
    out.write(gmtUnixTime & 0xFF);
    out.write(randomBytes);
  }

  byte[] getEncoded()
  {
    ByteArrayOutputStream bout = new ByteArrayOutputStream(32);
    try
      {
        write(bout);
      }
    catch (IOException cantHappen)
      {
        throw new Error(cantHappen);
      }
    return bout.toByteArray();
  }

  int getTime()
  {
    return gmtUnixTime;
  }

  byte[] getRandomBytes()
  {
    return randomBytes;
  }

  public String toString()
  {
    StringWriter str = new StringWriter();
    PrintWriter out = new PrintWriter(str);
    out.println("struct {");
    out.println("  gmt_unix_time = " + gmtUnixTime + ";");
    out.println("  random_bytes = " + Util.toHexString(randomBytes, ':') + ";");
    out.println("} Random;");
    return str.toString();
  }
}
