/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final String CF_UNICODETEXT = "CF_UNICODETEXT";
    private static final String CF_TEXT = "CF_TEXT";
    private static final int CF_UNICODETEXTID = 13;
    private static final int CF_TEXTID = 1;

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        transferData.result = -2147467259;
        String string = (String)object;
        switch (transferData.type) {
            case 13: {
                int charCount = string.length();
                char[] chars = new char[charCount + 1];
                string.getChars(0, charCount, chars, 0);
                int byteCount = chars.length * 2;
                int newPtr = OS.GlobalAlloc(64, byteCount);
                OS.MoveMemory(newPtr, chars, byteCount);
                transferData.stgmedium = new STGMEDIUM();
                transferData.stgmedium.tymed = 1;
                transferData.stgmedium.unionField = newPtr;
                transferData.stgmedium.pUnkForRelease = 0;
                transferData.result = 0;
                break;
            }
            case 1: {
                int count = string.length();
                char[] chars = new char[count + 1];
                string.getChars(0, count, chars, 0);
                int codePage = OS.GetACP();
                int cchMultiByte = OS.WideCharToMultiByte(codePage, 0, chars, -1, null, 0, null, null);
                if (cchMultiByte == 0) {
                    transferData.stgmedium = new STGMEDIUM();
                    transferData.result = -2147221402;
                    return;
                }
                int lpMultiByteStr = OS.GlobalAlloc(64, cchMultiByte);
                OS.WideCharToMultiByte(codePage, 0, chars, -1, lpMultiByteStr, cchMultiByte, null, null);
                transferData.stgmedium = new STGMEDIUM();
                transferData.stgmedium.tymed = 1;
                transferData.stgmedium.unionField = lpMultiByteStr;
                transferData.stgmedium.pUnkForRelease = 0;
                transferData.result = 0;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nativeToJava(TransferData transferData) {
        block26: {
            block22: {
                block25: {
                    if (this.isSupportedType(transferData) == false) return null;
                    if (transferData.pIDataObject == 0) {
                        return null;
                    }
                    data = new IDataObject(transferData.pIDataObject);
                    data.AddRef();
                    formatetc = transferData.formatetc;
                    stgmedium = new STGMEDIUM();
                    stgmedium.tymed = 1;
                    transferData.result = this.getData(data, formatetc, stgmedium);
                    data.Release();
                    if (transferData.result != 0) {
                        return null;
                    }
                    hMem = stgmedium.unionField;
                    try {
                        block24: {
                            switch (transferData.type) {
                                case 13: {
                                    size = OS.GlobalSize(hMem) / 2 * 2;
                                    if (size != 0) ** GOTO lbl23
                                    ** GOTO lbl73
lbl23:
                                    // 1 sources

                                    chars = new char[size / 2];
                                    ptr = OS.GlobalLock(hMem);
                                    if (ptr != 0) {
                                        try {
                                            OS.MoveMemory(chars, ptr, size);
                                            length = chars.length;
                                            i = 0;
                                            while (i < chars.length) {
                                                if (chars[i] == '\u0000') {
                                                    length = i;
                                                    break;
                                                }
                                                ++i;
                                            }
                                            var13_23 = new String(chars, 0, length);
                                            var11_24 = null;
                                        }
                                        catch (Throwable var12_27) {
                                            var11_25 = null;
                                            OS.GlobalUnlock(hMem);
                                            throw var12_27;
                                        }
                                        OS.GlobalUnlock(hMem);
                                        break block22;
                                    }
                                    ** GOTO lbl73
                                }
                                case 1: {
                                    lpMultiByteStr = OS.GlobalLock(hMem);
                                    if (lpMultiByteStr != 0) {
                                        try {
                                            codePage = OS.GetACP();
                                            cchWideChar = OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, null, 0);
                                            if (cchWideChar == 0) {
                                                var10_20 = null;
                                                break;
                                            }
                                            lpWideCharStr = new char[cchWideChar - 1];
                                            OS.MultiByteToWideChar(codePage, 1, lpMultiByteStr, -1, lpWideCharStr, lpWideCharStr.length);
                                            var12_28 = new String(lpWideCharStr);
                                            break block24;
                                        }
                                        catch (Throwable var11_26) {
                                            var10_22 = null;
                                            OS.GlobalUnlock(hMem);
                                            throw var11_26;
                                        }
                                    }
lbl73:
                                    // 5 sources

                                    while (true) {
                                        var14_8 = null;
                                        break block25;
                                        break;
                                    }
                                }
                            }
                            OS.GlobalUnlock(hMem);
                            ** continue;
                        }
                        var10_21 = null;
                        OS.GlobalUnlock(hMem);
                        break block26;
                        ** GOTO lbl-1000
                    }
                    catch (Throwable var15_29) {
                        var14_11 = null;
                        OS.GlobalFree(hMem);
                        throw var15_29;
                    }
                }
                OS.GlobalFree(hMem);
                return null;
            }
            var14_9 = null;
            OS.GlobalFree(hMem);
            return var13_23;
        }
        var14_10 = null;
        OS.GlobalFree(hMem);
        return var12_28;
lbl-1000:
        // 1 sources

        {
            var14_12 = null;
        }
        OS.GlobalFree(hMem);
        return null;
    }

    protected int[] getTypeIds() {
        return new int[]{13, 1};
    }

    protected String[] getTypeNames() {
        return new String[]{CF_UNICODETEXT, CF_TEXT};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

