/**************************************************************************

    begin                : June 30 2004
	version		 : 1.2 
    copyright            : (C) 2004 by Gleb Beliakov
    email                : gleb@deakin.edu.au


  These functions are wrappers for STCInterpolant class
  for those who like using procedural interface, and for calls from
  other languages, like Fortran and Matlab

  These functions simply call the relevant members of the
  STCInterpolant class, whose instance lives in intwrapper.cpp

  Added in version 1.2 SLipInt class

 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at your  *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License       *
 * along with this program; if not, write to the Free Software Foundation, *
 * Inc., 59 Temple Place Suite 330, Boston, MA 02111-1307 USA.             *
 ***************************************************************************/

//#include "interpol.h"

#ifdef __cplusplus
extern "C" {
#endif

// supplies the data to STCInterpolant and constructs the interpolant
// assuming a given Lipschitz constant, supplied by SetLipschitz
// if LipConstant was not supplied, tries to find it from the data
// assumes that all data are different. 

 int	BuildLipInterpolant(int Dim, int Ndata, double* x, double* y);

// as above, but for explicit evaluation, needs no preprocessing, but may be slower
  int	BuildLipInterpolantExplicit(int Dim, int Ndata, double* x, double* y);

// in the methods above, the coordinates of the data points in x are stored in rows

// the following methods store data in columns (like in fortran or Matlab)
// they use the transposed of the matrix x 
 int	BuildLipInterpolantColumn(int Dim, int Ndata, double* x, double* y);

// as above, but for explicit evaluation, needs no preprocessing, but may be slower
  int	BuildLipInterpolantExplicitColumn(int Dim, int Ndata, double* x, double* y);



// specify the Lipschitz constant for your function
  void	SetLipschitz(double x);

// computes the value of the interpolant at any given point x
  double	InterpolantValue( double* x );

// same but using explicit evaluation with no preprocessing
  double	InterpolantValueExplicit( double* x );


// interface to the members of SLipInt class
  double	SLipIntValue2(int Dim, int Ndata, double* x, double* Xd, double* y,  double Lipconst);
  double	SLipIntValue2Auto(int Dim, int Ndata, double* x, double* Xd,double* y);
  double	SLipIntValueInf(int Dim, int Ndata, double* x, double* Xd,double* y, double Lipconst);
  double	SLipIntValueInfArr(int Dim, int Ndata, double* x, double* Xd,double* y, double* Lipconst);
  double	SLipIntValueInfAuto(int Dim, int Ndata, double* x, double* Xd,double* y);

  void		SLipIntComputeLipschitzInf(int Dim, int Ndata, double* x, double* y);
  void		SLipIntComputeLipschitz2(int Dim, int Ndata, double* x, double* y);


// same as above but data arranged in columns (Fortran format)
  double	SLipIntValue2Col(int Dim, int Ndata, double* x, double* Xd, double* y,  double Lipconst);
  double	SLipIntValue2AutoCol(int Dim, int Ndata, double* x, double* Xd,double* y);
  double	SLipIntValueInfCol(int Dim, int Ndata, double* x, double* Xd,double* y, double Lipconst);
  double	SLipIntValueInfArrCol(int Dim, int Ndata, double* x, double* Xd,double* y, double* Lipconst);
  double	SLipIntValueInfAutoCol(int Dim, int Ndata, double* x, double* Xd,double* y);
  void		SLipIntComputeLipschitzInfCol(int Dim, int Ndata, double* x, double* y);
  void		SLipIntComputeLipschitz2Col(int Dim, int Ndata, double* x, double* y);

#ifdef __cplusplus
}
#endif
