package Locales::DB::Language::ln;

# Auto generated from CLDR

$Locales::DB::Language::ln::VERSION = '0.06';

$Locales::DB::Language::ln::cldr_version = '1.7.2';

%Locales::DB::Language::ln::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => "\.",
        '_decimal_format_group'   => undef,
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'language'                => "Language\:\ \{0\}",
        'locale'                  => "\{0\}\ \(\{1\}\)",
        'percent'                 => "\#\,\#\#0\%",
        'territory'               => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::ln::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'afrikánsi',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'afríhili',
    'ain'   => 'Ainu',
    'ak'    => 'akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'liamariki',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'liarabu',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => 'liasame',
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'liazerbayani',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "nkótá\ ya\ Bamileke",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'belarusi',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'kibulgaria',
    'bh'    => 'libiyari',
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'bambara',
    'bn'    => 'bengali',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'breton',
    'bra'   => 'Braj',
    'bs'    => 'libosinia',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'katalani',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'litshɛki',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'liwelesi',
    'da'    => 'lidanemark',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'lialemani',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'ligreki',
    'elx'   => 'Elamite',
    'en'    => 'lingɛlɛ́sa',
    'en_au' => "Australian\ English",
    'en_ca' => "lingɛlɛ́sa\ \(CA\)",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'lisipelanto',
    'es'    => 'lispanyola',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'liestonia',
    'eu'    => 'libaske',
    'ewo'   => 'Ewondo',
    'fa'    => 'lipɛrsi',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'lifilandi',
    'fil'   => 'litagalog',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => 'lifarose',
    'fon'   => 'Fon',
    'fr'    => 'lifalansé',
    'fr_ca' => "lifalansé\ \(CA\)",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => 'lifrisi',
    'ga'    => 'lirlande',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => 'ligaeliki',
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'ligalicia',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'ligwarani',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => 'liguzarati',
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'liyuda',
    'hi'    => 'lihindi',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'likroasia',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'liungaria',
    'hup'   => 'Hupa',
    'hy'    => 'liarmenya',
    'hz'    => 'Herero',
    'ia'    => 'interlingua',
    'iba'   => 'Iban',
    'id'    => 'lindonesi',
    'ie'    => 'interlingue',
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'lislanda',
    'it'    => 'litaliano',
    'iu'    => 'Inuktitut',
    'ja'    => 'liyapani',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'lizava',
    'ka'    => 'lizorzi',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'kikɔ́ngɔ',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'likambodia',
    'kmb'   => 'Kimbundu',
    'kn'    => 'kanada',
    'ko'    => 'likorea',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'likurdi',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'kirgizi',
    'la'    => 'kilatini',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'lingála',
    'lo'    => 'lilao',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'lituani',
    'lu'    => "Luba\-Katanga",
    'lua'   => 'ciluba',
    'lui'   => 'Luiseno',
    'lun'   => 'lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'lilativa',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'limasedonia',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'limalayalami',
    'mn'    => 'limongoli',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => 'limarati',
    'ms'    => 'limalasi',
    'mt'    => 'limalta',
    'mul'   => "nkótá\ míngi",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'linepali',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'lifalamá',
    'nl_be' => 'Flemish',
    'nn'    => "linovezi\-nynorsk",
    'no'    => 'linovezi',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => 'liosita',
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'oriya',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'lipunzabi',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'lipoloni',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'pashto',
    'pt'    => 'lipulutugɛ́si',
    'pt_br' => "lipulutugɛ́si\ \(Brazil\)",
    'pt_pt' => "Iberian\ Portuguese",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => 'lirumani',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'lirusi',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => "indu\-ya\-kala",
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'lisindi',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => 'liserbokroata',
    'shn'   => 'Shan',
    'si'    => 'lisinalɛ́si',
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'lisolovaki',
    'sl'    => 'lisoloveni',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'lisomali',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'lialbania',
    'sr'    => 'liserbia',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => "Sotho\ ya\ Sidi",
    'su'    => 'lisundanɛ́si',
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'liswédwa',
    'sw'    => 'kiswahili',
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'tamili',
    'tai'   => "Tai\ Language",
    'te'    => 'litelegu',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'thai',
    'ti'    => 'tigirinya',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'turkmen',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => 'kilingoni',
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'turk',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'twi',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'uighur',
    'uga'   => 'Ugaritic',
    'uk'    => 'liukrenia',
    'umb'   => 'Umbundu',
    'und'   => "lokótá\ eyébámí\ tɛ́",
    'ur'    => 'liurdu',
    'uz'    => 'liusibeki',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'livietnami',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'xhosa',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'yiddish',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'Chinese',
    'znd'   => 'Zande',
    'zu'    => 'zulu',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::ln::name_to_code = (
    'abkhazian'                     => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrikánsi'                    => 'af',
    'afroasiaticlanguage'           => 'afa',
    'afríhili'                     => 'afh',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'altaiclanguage'                => 'tut',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'apachelanguage'                => 'apa',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'asturian'                      => 'ast',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianenglish'             => 'en_au',
    'australianlanguage'            => 'aus',
    'austriangerman'                => 'de_at',
    'austronesianlanguage'          => 'map',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'aymara'                        => 'ay',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basa'                          => 'bas',
    'bashkir'                       => 'ba',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'belarusi'                      => 'be',
    'bemba'                         => 'bem',
    'bengali'                       => 'bn',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'braj'                          => 'bra',
    'breton'                        => 'br',
    'britishenglish'                => 'en_gb',
    'buginese'                      => 'bug',
    'buriat'                        => 'bua',
    'burmese'                       => 'my',
    'caddo'                         => 'cad',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chinese'                       => 'zh',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'ciluba'                        => 'lua',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'fijian'                        => 'fj',
    'finnougrianlanguage'           => 'fiu',
    'flemish'                       => 'nl_be',
    'fon'                           => 'fon',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'haitian'                       => 'ht',
    'hausa'                         => 'ha',
    'hawaiian'                      => 'haw',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'iberianportuguese'             => 'pt_pt',
    'iberianspanish'                => 'es_es',
    'ido'                           => 'io',
    'igbo'                          => 'ig',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'induyakala'                    => 'sa',
    'ingush'                        => 'inh',
    'interlingua'                   => 'ia',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'iranianlanguage'               => 'ira',
    'iroquoianlanguage'             => 'iro',
    'jju'                           => 'kaj',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kanada'                        => 'kn',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashmiri'                      => 'ks',
    'kashubian'                     => 'csb',
    'katalani'                      => 'ca',
    'kawi'                          => 'kaw',
    'kazakh'                        => 'kk',
    'khasi'                         => 'kha',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kibulgaria'                    => 'bg',
    'kikuyu'                        => 'ki',
    'kikɔ́ngɔ'                   => 'kg',
    'kilatini'                      => 'la',
    'kilingoni'                     => 'tlh',
    'kimbundu'                      => 'kmb',
    'kinyarwanda'                   => 'rw',
    'kirgizi'                       => 'ky',
    'kiswahili'                     => 'sw',
    'komi'                          => 'kv',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'kpelle'                        => 'kpe',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'lezghian'                      => 'lez',
    'lialbania'                     => 'sq',
    'lialemani'                     => 'de',
    'liamariki'                     => 'am',
    'liarabu'                       => 'ar',
    'liarmenya'                     => 'hy',
    'liasame'                       => 'as',
    'liazerbayani'                  => 'az',
    'libaske'                       => 'eu',
    'libiyari'                      => 'bh',
    'libosinia'                     => 'bs',
    'lidanemark'                    => 'da',
    'liestonia'                     => 'et',
    'lifalamá'                     => 'nl',
    'lifalansé'                    => 'fr',
    'lifalanséca'                  => 'fr_ca',
    'lifarose'                      => 'fo',
    'lifilandi'                     => 'fi',
    'lifrisi'                       => 'fy',
    'ligaeliki'                     => 'gd',
    'ligalicia'                     => 'gl',
    'ligreki'                       => 'el',
    'liguzarati'                    => 'gu',
    'ligwarani'                     => 'gn',
    'lihindi'                       => 'hi',
    'likambodia'                    => 'km',
    'likorea'                       => 'ko',
    'likroasia'                     => 'hr',
    'likurdi'                       => 'ku',
    'lilao'                         => 'lo',
    'lilativa'                      => 'lv',
    'limalasi'                      => 'ms',
    'limalayalami'                  => 'ml',
    'limalta'                       => 'mt',
    'limarati'                      => 'mr',
    'limasedonia'                   => 'mk',
    'limburgish'                    => 'li',
    'limongoli'                     => 'mn',
    'lindonesi'                     => 'id',
    'linepali'                      => 'ne',
    'lingála'                      => 'ln',
    'lingɛlɛ́sa'                 => 'en',
    'lingɛlɛ́saca'               => 'en_ca',
    'linovezi'                      => 'no',
    'linovezinynorsk'               => 'nn',
    'liosita'                       => 'oc',
    'lipoloni'                      => 'pl',
    'lipulutugɛ́si'               => 'pt',
    'lipulutugɛ́sibrazil'         => 'pt_br',
    'lipunzabi'                     => 'pa',
    'lipɛrsi'                      => 'fa',
    'lirlande'                      => 'ga',
    'lirumani'                      => 'ro',
    'lirusi'                        => 'ru',
    'liserbia'                      => 'sr',
    'liserbokroata'                 => 'sh',
    'lisinalɛ́si'                 => 'si',
    'lisindi'                       => 'sd',
    'lisipelanto'                   => 'eo',
    'lislanda'                      => 'is',
    'lisolovaki'                    => 'sk',
    'lisoloveni'                    => 'sl',
    'lisomali'                      => 'so',
    'lispanyola'                    => 'es',
    'lisundanɛ́si'                => 'su',
    'liswédwa'                     => 'sv',
    'litagalog'                     => 'fil',
    'litaliano'                     => 'it',
    'litelegu'                      => 'te',
    'litshɛki'                     => 'cs',
    'lituani'                       => 'lt',
    'liukrenia'                     => 'uk',
    'liungaria'                     => 'hu',
    'liurdu'                        => 'ur',
    'liusibeki'                     => 'uz',
    'livietnami'                    => 'vi',
    'liwelesi'                      => 'cy',
    'liyapani'                      => 'ja',
    'liyuda'                        => 'he',
    'lizava'                        => 'jv',
    'lizorzi'                       => 'ka',
    'lojban'                        => 'jbo',
    'lokótáeyébámítɛ́'       => 'und',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxembourgish'                 => 'lb',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'malagasy'                      => 'mg',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maori'                         => 'mi',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'mundalanguage'                 => 'mun',
    'nahuatl'                       => 'nah',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nkótámíngi'                 => 'mul',
    'nkótáyabamileke'             => 'bai',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsami'                  => 'se',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    "norwegianbokm\Ã\¥l"          => 'nb',
    'nubianlanguage'                => 'nub',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'ojibwa'                        => 'oj',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'ossetic'                       => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'pashto'                        => 'ps',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'rhaetoromance'                 => 'rm',
    'romancelanguage'               => 'roa',
    'romany'                        => 'rom',
    'rundi'                         => 'rn',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samilanguage'                  => 'smi',
    'samoan'                        => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'serer'                         => 'srr',
    'shan'                          => 'shn',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'sogdien'                       => 'sog',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'sothoyasidi'                   => 'st',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southndebele'                  => 'nr',
    'sranantongo'                   => 'srn',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'susu'                          => 'sus',
    'swati'                         => 'ss',
    'swissfrench'                   => 'fr_ch',
    'swissgerman'                   => 'gsw',
    'swisshighgerman'               => 'de_ch',
    'syriac'                        => 'syr',
    'tagalog'                       => 'tl',
    'tahitian'                      => 'ty',
    'tailanguage'                   => 'tai',
    'tajik'                         => 'tg',
    'tamashek'                      => 'tmh',
    'tamili'                        => 'ta',
    'taroko'                        => 'trv',
    'tatar'                         => 'tt',
    'tereno'                        => 'ter',
    'tetum'                         => 'tet',
    'thai'                          => 'th',
    'tibetan'                       => 'bo',
    'tigirinya'                     => 'ti',
    'tigre'                         => 'tig',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'turk'                          => 'tr',
    'turkmen'                       => 'tk',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'tyap'                          => 'kcg',
    "u\.s\.english"                 => 'en_us',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'uighur'                        => 'ug',
    'umbundu'                       => 'umb',
    'uppersorbian'                  => 'hsb',
    'vai'                           => 'vai',
    'venda'                         => 've',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'wolof'                         => 'wo',
    'xhosa'                         => 'xh',
    'yakut'                         => 'sah',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yiddish'                       => 'yi',
    'yoruba'                        => 'yo',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zulu'                          => 'zu',
    'zuni'                          => 'zun',
);

1;
