package Locales::DB::Language::mn;

# Auto generated from CLDR

$Locales::DB::Language::mn::VERSION = '0.06';

$Locales::DB::Language::mn::cldr_version = '1.7.2';

%Locales::DB::Language::mn::misc_info = (
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => undef,
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'language'                => "Language\:\ \{0\}",
        'locale'                  => "\{0\}\ \(\{1\}\)",
        'percent'                 => "\#\,\#\#0\%",
        'territory'               => "Region\:\ \{0\}"
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'posix' => {
        'nostr'  => "no\:n",
        'yesstr' => "yes\:y"
    },
);

%Locales::DB::Language::mn::code_to_name = (
    'aa'    => 'Afar',
    'ab'    => 'Abkhazian',
    'ace'   => 'Achinese',
    'ach'   => 'Acoli',
    'ada'   => 'Adangme',
    'ady'   => 'Adyghe',
    'ae'    => 'Avestan',
    'af'    => 'африк',
    'afa'   => "Afro\-Asiatic\ Language",
    'afh'   => 'Afrihili',
    'ain'   => 'Ainu',
    'ak'    => 'Akan',
    'akk'   => 'Akkadian',
    'ale'   => 'Aleut',
    'alg'   => "Algonquian\ Language",
    'alt'   => "Southern\ Altai",
    'am'    => 'амхарик',
    'an'    => 'Aragonese',
    'ang'   => "Old\ English",
    'anp'   => 'Angika',
    'apa'   => "Apache\ Language",
    'ar'    => 'араб',
    'arc'   => 'Aramaic',
    'arn'   => 'Araucanian',
    'arp'   => 'Arapaho',
    'art'   => "Artificial\ Language",
    'arw'   => 'Arawak',
    'as'    => "ассам\ үндэстэн",
    'ast'   => 'Asturian',
    'ath'   => "Athapascan\ Language",
    'aus'   => "Australian\ Language",
    'av'    => 'Avaric',
    'awa'   => 'Awadhi',
    'ay'    => 'Aymara',
    'az'    => 'азарбежан',
    'ba'    => 'Bashkir',
    'bad'   => 'Banda',
    'bai'   => "Bamileke\ Language",
    'bal'   => 'Baluchi',
    'ban'   => 'Balinese',
    'bas'   => 'Basa',
    'bat'   => "Baltic\ Language",
    'be'    => 'беларусь',
    'bej'   => 'Beja',
    'bem'   => 'Bemba',
    'ber'   => 'Berber',
    'bg'    => 'болгар',
    'bh'    => "бихари\ хэл",
    'bho'   => 'Bhojpuri',
    'bi'    => 'Bislama',
    'bik'   => 'Bikol',
    'bin'   => 'Bini',
    'bla'   => 'Siksika',
    'bm'    => 'Bambara',
    'bn'    => 'бенгаль',
    'bnt'   => 'Bantu',
    'bo'    => 'Tibetan',
    'br'    => 'бретон',
    'bra'   => 'Braj',
    'bs'    => 'босниа',
    'btk'   => 'Batak',
    'bua'   => 'Buriat',
    'bug'   => 'Buginese',
    'byn'   => 'Blin',
    'ca'    => 'каталан',
    'cad'   => 'Caddo',
    'cai'   => "Central\ American\ Indian\ Language",
    'car'   => 'Carib',
    'cau'   => "Caucasian\ Language",
    'cch'   => 'Atsam',
    'ce'    => 'Chechen',
    'ceb'   => 'Cebuano',
    'cel'   => "Celtic\ Language",
    'ch'    => 'Chamorro',
    'chb'   => 'Chibcha',
    'chg'   => 'Chagatai',
    'chk'   => 'Chuukese',
    'chm'   => 'Mari',
    'chn'   => "Chinook\ Jargon",
    'cho'   => 'Choctaw',
    'chp'   => 'Chipewyan',
    'chr'   => 'Cherokee',
    'chy'   => 'Cheyenne',
    'cmc'   => "Chamic\ Language",
    'co'    => 'Corsican',
    'cop'   => 'Coptic',
    'cpe'   => "English\-based\ Creole\ or\ Pidgin",
    'cpf'   => "French\-based\ Creole\ or\ Pidgin",
    'cpp'   => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'    => 'Cree',
    'crh'   => "Crimean\ Turkish",
    'crp'   => "Creole\ or\ Pidgin",
    'cs'    => 'чех',
    'csb'   => 'Kashubian',
    'cu'    => "Church\ Slavic",
    'cus'   => "Cushitic\ Language",
    'cv'    => 'Chuvash',
    'cy'    => 'уэлс',
    'da'    => 'дани',
    'dak'   => 'Dakota',
    'dar'   => 'Dargwa',
    'day'   => 'Dayak',
    'de'    => 'герман',
    'de_at' => "Austrian\ German",
    'de_ch' => "Swiss\ High\ German",
    'del'   => 'Delaware',
    'den'   => 'Slave',
    'dgr'   => 'Dogrib',
    'din'   => 'Dinka',
    'doi'   => 'Dogri',
    'dra'   => "Dravidian\ Language",
    'dsb'   => "Lower\ Sorbian",
    'dua'   => 'Duala',
    'dum'   => "Middle\ Dutch",
    'dv'    => 'Divehi',
    'dyu'   => 'Dyula',
    'dz'    => 'Dzongkha',
    'ee'    => 'Ewe',
    'efi'   => 'Efik',
    'egy'   => "Ancient\ Egyptian",
    'eka'   => 'Ekajuk',
    'el'    => 'грек',
    'elx'   => 'Elamite',
    'en'    => 'англи',
    'en_au' => "Australian\ English",
    'en_ca' => "Canadian\ English",
    'en_gb' => "British\ English",
    'en_us' => "U\.S\.\ English",
    'enm'   => "Middle\ English",
    'eo'    => 'эсперанто',
    'es'    => 'испани',
    'es_es' => "Iberian\ Spanish",
    'et'    => 'эстони',
    'eu'    => 'баск',
    'ewo'   => 'Ewondo',
    'fa'    => 'перс',
    'fan'   => 'Fang',
    'fat'   => 'Fanti',
    'ff'    => 'Fulah',
    'fi'    => 'финлянд',
    'fil'   => 'тагало',
    'fiu'   => "Finno\-Ugrian\ Language",
    'fj'    => 'Fijian',
    'fo'    => "фөриэс\ хэл",
    'fon'   => 'Fon',
    'fr'    => 'франц',
    'fr_ca' => "Canadian\ French",
    'fr_ch' => "Swiss\ French",
    'frm'   => "Middle\ French",
    'fro'   => "Old\ French",
    'frr'   => "Northern\ Frisian",
    'frs'   => "Eastern\ Frisian",
    'fur'   => 'Friulian',
    'fy'    => "голландын\ фрисиан\ хэл",
    'ga'    => 'ирланд',
    'gaa'   => 'Ga',
    'gay'   => 'Gayo',
    'gba'   => 'Gbaya',
    'gd'    => "шотланд\ келт",
    'gem'   => "Germanic\ Language",
    'gez'   => 'Geez',
    'gil'   => 'Gilbertese',
    'gl'    => 'галик',
    'gmh'   => "Middle\ High\ German",
    'gn'    => 'гуарани',
    'goh'   => "Old\ High\ German",
    'gon'   => 'Gondi',
    'gor'   => 'Gorontalo',
    'got'   => 'Gothic',
    'grb'   => 'Grebo',
    'grc'   => "Ancient\ Greek",
    'gsw'   => "Swiss\ German",
    'gu'    => "энэтхэгийн\ гужарати",
    'gv'    => 'Manx',
    'gwi'   => "Gwich\Ê\¼in",
    'ha'    => 'Hausa',
    'hai'   => 'Haida',
    'haw'   => 'Hawaiian',
    'he'    => 'кипр',
    'hi'    => 'хинди',
    'hil'   => 'Hiligaynon',
    'him'   => 'Himachali',
    'hit'   => 'Hittite',
    'hmn'   => 'Hmong',
    'ho'    => "Hiri\ Motu",
    'hr'    => 'хорвати',
    'hsb'   => "Upper\ Sorbian",
    'ht'    => 'Haitian',
    'hu'    => 'унгар',
    'hup'   => 'Hupa',
    'hy'    => 'армен',
    'hz'    => 'Herero',
    'ia'    => 'интерлингво',
    'iba'   => 'Iban',
    'id'    => 'индонези',
    'ie'    => "нэгдмэл\ хэл",
    'ig'    => 'Igbo',
    'ii'    => "Sichuan\ Yi",
    'ijo'   => 'Ijo',
    'ik'    => 'Inupiaq',
    'ilo'   => 'Iloko',
    'inc'   => "Indic\ Language",
    'ine'   => "Indo\-European\ Language",
    'inh'   => 'Ingush',
    'io'    => 'Ido',
    'ira'   => "Iranian\ Language",
    'iro'   => "Iroquoian\ Language",
    'is'    => 'исланд',
    'it'    => 'итали',
    'iu'    => 'Inuktitut',
    'ja'    => 'япон',
    'jbo'   => 'Lojban',
    'jpr'   => "Judeo\-Persian",
    'jrb'   => "Judeo\-Arabic",
    'jv'    => 'ява',
    'ka'    => 'гүрж',
    'kaa'   => "Kara\-Kalpak",
    'kab'   => 'Kabyle',
    'kac'   => 'Kachin',
    'kaj'   => 'Jju',
    'kam'   => 'Kamba',
    'kar'   => 'Karen',
    'kaw'   => 'Kawi',
    'kbd'   => 'Kabardian',
    'kcg'   => 'Tyap',
    'kfo'   => 'Koro',
    'kg'    => 'Kongo',
    'kha'   => 'Khasi',
    'khi'   => "Khoisan\ Language",
    'kho'   => 'Khotanese',
    'ki'    => 'Kikuyu',
    'kj'    => 'Kuanyama',
    'kk'    => 'Kazakh',
    'kl'    => 'Kalaallisut',
    'km'    => 'камбуч',
    'kmb'   => 'Kimbundu',
    'kn'    => 'каннада',
    'ko'    => 'солонгос',
    'kok'   => 'Konkani',
    'kos'   => 'Kosraean',
    'kpe'   => 'Kpelle',
    'kr'    => 'Kanuri',
    'krc'   => "Karachay\-Balkar",
    'krl'   => 'Karelian',
    'kro'   => 'Kru',
    'kru'   => 'Kurukh',
    'ks'    => 'Kashmiri',
    'ku'    => 'курд',
    'kum'   => 'Kumyk',
    'kut'   => 'Kutenai',
    'kv'    => 'Komi',
    'kw'    => 'Cornish',
    'ky'    => 'киргиз',
    'la'    => 'латин',
    'lad'   => 'Ladino',
    'lah'   => 'Lahnda',
    'lam'   => 'Lamba',
    'lb'    => 'Luxembourgish',
    'lez'   => 'Lezghian',
    'lg'    => 'Ganda',
    'li'    => 'Limburgish',
    'ln'    => 'лингала',
    'lo'    => 'лаотиан',
    'lol'   => 'Mongo',
    'loz'   => 'Lozi',
    'lt'    => 'литви',
    'lu'    => "Luba\-Katanga",
    'lua'   => "Luba\-Lulua",
    'lui'   => 'Luiseno',
    'lun'   => 'Lunda',
    'luo'   => 'Luo',
    'lus'   => 'Lushai',
    'lv'    => 'латви',
    'mad'   => 'Madurese',
    'mag'   => 'Magahi',
    'mai'   => 'Maithili',
    'mak'   => 'Makasar',
    'man'   => 'Mandingo',
    'map'   => "Austronesian\ Language",
    'mas'   => 'Masai',
    'mdf'   => 'Moksha',
    'mdr'   => 'Mandar',
    'men'   => 'Mende',
    'mfe'   => 'Morisyen',
    'mg'    => 'Malagasy',
    'mga'   => "Middle\ Irish",
    'mh'    => 'Marshallese',
    'mi'    => 'Maori',
    'mic'   => 'Micmac',
    'min'   => 'Minangkabau',
    'mis'   => "Miscellaneous\ Language",
    'mk'    => 'македони',
    'mkh'   => "Mon\-Khmer\ Language",
    'ml'    => 'малайлам',
    'mn'    => 'монгол',
    'mnc'   => 'Manchu',
    'mni'   => 'Manipuri',
    'mno'   => "Manobo\ Language",
    'mo'    => 'Moldavian',
    'moh'   => 'Mohawk',
    'mos'   => 'Mossi',
    'mr'    => "энэтхэгийн\ марати",
    'ms'    => 'малай',
    'mt'    => 'малти',
    'mul'   => "Multiple\ Languages",
    'mun'   => "Munda\ Language",
    'mus'   => 'Creek',
    'mwl'   => 'Mirandese',
    'mwr'   => 'Marwari',
    'my'    => 'Burmese',
    'myn'   => "Mayan\ Language",
    'myv'   => 'Erzya',
    'na'    => 'Nauru',
    'nah'   => 'Nahuatl',
    'nai'   => "North\ American\ Indian\ Language",
    'nap'   => 'Neapolitan',
    'nb'    => "Norwegian\ Bokm\Ã\¥l",
    'nd'    => "North\ Ndebele",
    'nds'   => "Low\ German",
    'ne'    => 'балба',
    'new'   => 'Newari',
    'ng'    => 'Ndonga',
    'nia'   => 'Nias',
    'nic'   => "Niger\-Kordofanian\ Language",
    'niu'   => 'Niuean',
    'nl'    => 'голланд',
    'nl_be' => 'Flemish',
    'nn'    => "норвеги\ \(нынорск\)",
    'no'    => 'норвеги',
    'nog'   => 'Nogai',
    'non'   => "Old\ Norse",
    'nqo'   => "N\â\\Ko",
    'nr'    => "South\ Ndebele",
    'nso'   => "Northern\ Sotho",
    'nub'   => "Nubian\ Language",
    'nv'    => 'Navajo',
    'nwc'   => "Classical\ Newari",
    'ny'    => 'Nyanja',
    'nym'   => 'Nyamwezi',
    'nyn'   => 'Nyankole',
    'nyo'   => 'Nyoro',
    'nzi'   => 'Nzima',
    'oc'    => "францын\ окситан",
    'oj'    => 'Ojibwa',
    'om'    => 'Oromo',
    'or'    => 'ория',
    'os'    => 'Ossetic',
    'osa'   => 'Osage',
    'ota'   => "Ottoman\ Turkish",
    'oto'   => "Otomian\ Language",
    'pa'    => 'пенжаби',
    'paa'   => "Papuan\ Language",
    'pag'   => 'Pangasinan',
    'pal'   => 'Pahlavi',
    'pam'   => 'Pampanga',
    'pap'   => 'Papiamento',
    'pau'   => 'Palauan',
    'peo'   => "Old\ Persian",
    'phi'   => "Philippine\ Language",
    'phn'   => 'Phoenician',
    'pi'    => 'Pali',
    'pl'    => 'польш',
    'pon'   => 'Pohnpeian',
    'pra'   => "Prakrit\ Language",
    'pro'   => "Old\ Proven\Ã\§al",
    'ps'    => 'афган',
    'pt'    => 'португали',
    'pt_br' => "португали\ \(бразил\)",
    'pt_pt' => "португали\ \(португали\)",
    'qu'    => 'Quechua',
    'raj'   => 'Rajasthani',
    'rap'   => 'Rapanui',
    'rar'   => 'Rarotongan',
    'rm'    => "Rhaeto\-Romance",
    'rn'    => 'Rundi',
    'ro'    => 'румын',
    'roa'   => "Romance\ Language",
    'rom'   => 'Romany',
    'ru'    => 'орос',
    'rup'   => 'Aromanian',
    'rw'    => 'Kinyarwanda',
    'sa'    => 'санскирит',
    'sad'   => 'Sandawe',
    'sah'   => 'Yakut',
    'sai'   => "South\ American\ Indian\ Language",
    'sal'   => "Salishan\ Language",
    'sam'   => "Samaritan\ Aramaic",
    'sas'   => 'Sasak',
    'sat'   => 'Santali',
    'sc'    => 'Sardinian',
    'scn'   => 'Sicilian',
    'sco'   => 'Scots',
    'sd'    => 'синдхи',
    'se'    => "Northern\ Sami",
    'sel'   => 'Selkup',
    'sem'   => "Semitic\ Language",
    'sg'    => 'Sango',
    'sga'   => "Old\ Irish",
    'sgn'   => "Sign\ Language",
    'sh'    => "хорватын\ серб",
    'shn'   => 'Shan',
    'si'    => "шри\ ланк",
    'sid'   => 'Sidamo',
    'sio'   => "Siouan\ Language",
    'sit'   => "Sino\-Tibetan\ Language",
    'sk'    => 'словак',
    'sl'    => 'словени',
    'sla'   => "Slavic\ Language",
    'sm'    => 'Samoan',
    'sma'   => "Southern\ Sami",
    'smi'   => "Sami\ Language",
    'smj'   => "Lule\ Sami",
    'smn'   => "Inari\ Sami",
    'sms'   => "Skolt\ Sami",
    'sn'    => 'Shona',
    'snk'   => 'Soninke',
    'so'    => 'сомали',
    'sog'   => 'Sogdien',
    'son'   => 'Songhai',
    'sq'    => 'албани',
    'sr'    => 'серби',
    'srn'   => "Sranan\ Tongo",
    'srr'   => 'Serer',
    'ss'    => 'Swati',
    'ssa'   => "Nilo\-Saharan\ Language",
    'st'    => 'сесото',
    'su'    => "сунданес\ хэл",
    'suk'   => 'Sukuma',
    'sus'   => 'Susu',
    'sux'   => 'Sumerian',
    'sv'    => 'швед',
    'sw'    => "африкийн\ свахили\ хэл",
    'syc'   => "Classical\ Syriac",
    'syr'   => 'Syriac',
    'ta'    => 'тамил',
    'tai'   => "Tai\ Language",
    'te'    => 'тэлүгү',
    'tem'   => 'Timne',
    'ter'   => 'Tereno',
    'tet'   => 'Tetum',
    'tg'    => 'Tajik',
    'th'    => 'тай',
    'ti'    => 'тикрина',
    'tig'   => 'Tigre',
    'tiv'   => 'Tiv',
    'tk'    => 'туркмен',
    'tkl'   => 'Tokelau',
    'tl'    => 'Tagalog',
    'tlh'   => "клингон\ хэл",
    'tli'   => 'Tlingit',
    'tmh'   => 'Tamashek',
    'tn'    => 'Tswana',
    'to'    => 'Tonga',
    'tog'   => "Nyasa\ Tonga",
    'tpi'   => "Tok\ Pisin",
    'tr'    => 'турк',
    'trv'   => 'Taroko',
    'ts'    => 'Tsonga',
    'tsi'   => 'Tsimshian',
    'tt'    => 'Tatar',
    'tum'   => 'Tumbuka',
    'tup'   => "Tupi\ Language",
    'tut'   => "Altaic\ Language",
    'tvl'   => 'Tuvalu',
    'tw'    => 'тви',
    'ty'    => 'Tahitian',
    'tyv'   => 'Tuvinian',
    'udm'   => 'Udmurt',
    'ug'    => 'уйгур',
    'uga'   => 'Ugaritic',
    'uk'    => 'украин',
    'umb'   => 'Umbundu',
    'und'   => "Unknown\ or\ Invalid\ Language",
    'ur'    => "пакистаны\ урду",
    'uz'    => 'узбек',
    'vai'   => 'Vai',
    've'    => 'Venda',
    'vi'    => 'вьетнам',
    'vo'    => "Volap\Ã\¼k",
    'vot'   => 'Votic',
    'wa'    => 'Walloon',
    'wak'   => "Wakashan\ Language",
    'wal'   => 'Walamo',
    'war'   => 'Waray',
    'was'   => 'Washo',
    'wen'   => "Sorbian\ Language",
    'wo'    => 'Wolof',
    'xal'   => 'Kalmyk',
    'xh'    => 'хоса',
    'yao'   => 'Yao',
    'yap'   => 'Yapese',
    'yi'    => 'иддиш',
    'yo'    => 'Yoruba',
    'ypk'   => "Yupik\ Language",
    'za'    => 'Zhuang',
    'zap'   => 'Zapotec',
    'zbl'   => 'Blissymbols',
    'zen'   => 'Zenaga',
    'zh'    => 'хятад',
    'znd'   => 'Zande',
    'zu'    => 'зулу',
    'zun'   => 'Zuni',
    'zxx'   => "No\ linguistic\ content",
    'zza'   => 'Zaza',
);

%Locales::DB::Language::mn::name_to_code = (
    'abkhazian'                              => 'ab',
    'achinese'                               => 'ace',
    'acoli'                                  => 'ach',
    'adangme'                                => 'ada',
    'adyghe'                                 => 'ady',
    'afar'                                   => 'aa',
    'afrihili'                               => 'afh',
    'afroasiaticlanguage'                    => 'afa',
    'ainu'                                   => 'ain',
    'akan'                                   => 'ak',
    'akkadian'                               => 'akk',
    'aleut'                                  => 'ale',
    'algonquianlanguage'                     => 'alg',
    'altaiclanguage'                         => 'tut',
    'ancientegyptian'                        => 'egy',
    'ancientgreek'                           => 'grc',
    'angika'                                 => 'anp',
    'apachelanguage'                         => 'apa',
    'aragonese'                              => 'an',
    'aramaic'                                => 'arc',
    'arapaho'                                => 'arp',
    'araucanian'                             => 'arn',
    'arawak'                                 => 'arw',
    'aromanian'                              => 'rup',
    'artificiallanguage'                     => 'art',
    'asturian'                               => 'ast',
    'athapascanlanguage'                     => 'ath',
    'atsam'                                  => 'cch',
    'australianenglish'                      => 'en_au',
    'australianlanguage'                     => 'aus',
    'austriangerman'                         => 'de_at',
    'austronesianlanguage'                   => 'map',
    'avaric'                                 => 'av',
    'avestan'                                => 'ae',
    'awadhi'                                 => 'awa',
    'aymara'                                 => 'ay',
    'balinese'                               => 'ban',
    'balticlanguage'                         => 'bat',
    'baluchi'                                => 'bal',
    'bambara'                                => 'bm',
    'bamilekelanguage'                       => 'bai',
    'banda'                                  => 'bad',
    'bantu'                                  => 'bnt',
    'basa'                                   => 'bas',
    'bashkir'                                => 'ba',
    'batak'                                  => 'btk',
    'beja'                                   => 'bej',
    'bemba'                                  => 'bem',
    'berber'                                 => 'ber',
    'bhojpuri'                               => 'bho',
    'bikol'                                  => 'bik',
    'bini'                                   => 'bin',
    'bislama'                                => 'bi',
    'blin'                                   => 'byn',
    'blissymbols'                            => 'zbl',
    'braj'                                   => 'bra',
    'britishenglish'                         => 'en_gb',
    'buginese'                               => 'bug',
    'buriat'                                 => 'bua',
    'burmese'                                => 'my',
    'caddo'                                  => 'cad',
    'canadianenglish'                        => 'en_ca',
    'canadianfrench'                         => 'fr_ca',
    'carib'                                  => 'car',
    'caucasianlanguage'                      => 'cau',
    'cebuano'                                => 'ceb',
    'celticlanguage'                         => 'cel',
    'centralamericanindianlanguage'          => 'cai',
    'chagatai'                               => 'chg',
    'chamiclanguage'                         => 'cmc',
    'chamorro'                               => 'ch',
    'chechen'                                => 'ce',
    'cherokee'                               => 'chr',
    'cheyenne'                               => 'chy',
    'chibcha'                                => 'chb',
    'chinookjargon'                          => 'chn',
    'chipewyan'                              => 'chp',
    'choctaw'                                => 'cho',
    'churchslavic'                           => 'cu',
    'chuukese'                               => 'chk',
    'chuvash'                                => 'cv',
    'classicalnewari'                        => 'nwc',
    'classicalsyriac'                        => 'syc',
    'coptic'                                 => 'cop',
    'cornish'                                => 'kw',
    'corsican'                               => 'co',
    'cree'                                   => 'cr',
    'creek'                                  => 'mus',
    'creoleorpidgin'                         => 'crp',
    'crimeanturkish'                         => 'crh',
    'cushiticlanguage'                       => 'cus',
    'dakota'                                 => 'dak',
    'dargwa'                                 => 'dar',
    'dayak'                                  => 'day',
    'delaware'                               => 'del',
    'dinka'                                  => 'din',
    'divehi'                                 => 'dv',
    'dogri'                                  => 'doi',
    'dogrib'                                 => 'dgr',
    'dravidianlanguage'                      => 'dra',
    'duala'                                  => 'dua',
    'dyula'                                  => 'dyu',
    'dzongkha'                               => 'dz',
    'easternfrisian'                         => 'frs',
    'efik'                                   => 'efi',
    'ekajuk'                                 => 'eka',
    'elamite'                                => 'elx',
    'englishbasedcreoleorpidgin'             => 'cpe',
    'erzya'                                  => 'myv',
    'ewe'                                    => 'ee',
    'ewondo'                                 => 'ewo',
    'fang'                                   => 'fan',
    'fanti'                                  => 'fat',
    'fijian'                                 => 'fj',
    'finnougrianlanguage'                    => 'fiu',
    'flemish'                                => 'nl_be',
    'fon'                                    => 'fon',
    'frenchbasedcreoleorpidgin'              => 'cpf',
    'friulian'                               => 'fur',
    'fulah'                                  => 'ff',
    'ga'                                     => 'gaa',
    'ganda'                                  => 'lg',
    'gayo'                                   => 'gay',
    'gbaya'                                  => 'gba',
    'geez'                                   => 'gez',
    'germaniclanguage'                       => 'gem',
    'gilbertese'                             => 'gil',
    'gondi'                                  => 'gon',
    'gorontalo'                              => 'gor',
    'gothic'                                 => 'got',
    'grebo'                                  => 'grb',
    "gwich\Ê\¼in"                          => 'gwi',
    'haida'                                  => 'hai',
    'haitian'                                => 'ht',
    'hausa'                                  => 'ha',
    'hawaiian'                               => 'haw',
    'herero'                                 => 'hz',
    'hiligaynon'                             => 'hil',
    'himachali'                              => 'him',
    'hirimotu'                               => 'ho',
    'hittite'                                => 'hit',
    'hmong'                                  => 'hmn',
    'hupa'                                   => 'hup',
    'iban'                                   => 'iba',
    'iberianspanish'                         => 'es_es',
    'ido'                                    => 'io',
    'igbo'                                   => 'ig',
    'ijo'                                    => 'ijo',
    'iloko'                                  => 'ilo',
    'inarisami'                              => 'smn',
    'indiclanguage'                          => 'inc',
    'indoeuropeanlanguage'                   => 'ine',
    'ingush'                                 => 'inh',
    'inuktitut'                              => 'iu',
    'inupiaq'                                => 'ik',
    'iranianlanguage'                        => 'ira',
    'iroquoianlanguage'                      => 'iro',
    'jju'                                    => 'kaj',
    'judeoarabic'                            => 'jrb',
    'judeopersian'                           => 'jpr',
    'kabardian'                              => 'kbd',
    'kabyle'                                 => 'kab',
    'kachin'                                 => 'kac',
    'kalaallisut'                            => 'kl',
    'kalmyk'                                 => 'xal',
    'kamba'                                  => 'kam',
    'kanuri'                                 => 'kr',
    'karachaybalkar'                         => 'krc',
    'karakalpak'                             => 'kaa',
    'karelian'                               => 'krl',
    'karen'                                  => 'kar',
    'kashmiri'                               => 'ks',
    'kashubian'                              => 'csb',
    'kawi'                                   => 'kaw',
    'kazakh'                                 => 'kk',
    'khasi'                                  => 'kha',
    'khoisanlanguage'                        => 'khi',
    'khotanese'                              => 'kho',
    'kikuyu'                                 => 'ki',
    'kimbundu'                               => 'kmb',
    'kinyarwanda'                            => 'rw',
    'komi'                                   => 'kv',
    'kongo'                                  => 'kg',
    'konkani'                                => 'kok',
    'koro'                                   => 'kfo',
    'kosraean'                               => 'kos',
    'kpelle'                                 => 'kpe',
    'kru'                                    => 'kro',
    'kuanyama'                               => 'kj',
    'kumyk'                                  => 'kum',
    'kurukh'                                 => 'kru',
    'kutenai'                                => 'kut',
    'ladino'                                 => 'lad',
    'lahnda'                                 => 'lah',
    'lamba'                                  => 'lam',
    'lezghian'                               => 'lez',
    'limburgish'                             => 'li',
    'lojban'                                 => 'jbo',
    'lowersorbian'                           => 'dsb',
    'lowgerman'                              => 'nds',
    'lozi'                                   => 'loz',
    'lubakatanga'                            => 'lu',
    'lubalulua'                              => 'lua',
    'luiseno'                                => 'lui',
    'lulesami'                               => 'smj',
    'lunda'                                  => 'lun',
    'luo'                                    => 'luo',
    'lushai'                                 => 'lus',
    'luxembourgish'                          => 'lb',
    'madurese'                               => 'mad',
    'magahi'                                 => 'mag',
    'maithili'                               => 'mai',
    'makasar'                                => 'mak',
    'malagasy'                               => 'mg',
    'manchu'                                 => 'mnc',
    'mandar'                                 => 'mdr',
    'mandingo'                               => 'man',
    'manipuri'                               => 'mni',
    'manobolanguage'                         => 'mno',
    'manx'                                   => 'gv',
    'maori'                                  => 'mi',
    'mari'                                   => 'chm',
    'marshallese'                            => 'mh',
    'marwari'                                => 'mwr',
    'masai'                                  => 'mas',
    'mayanlanguage'                          => 'myn',
    'mende'                                  => 'men',
    'micmac'                                 => 'mic',
    'middledutch'                            => 'dum',
    'middleenglish'                          => 'enm',
    'middlefrench'                           => 'frm',
    'middlehighgerman'                       => 'gmh',
    'middleirish'                            => 'mga',
    'minangkabau'                            => 'min',
    'mirandese'                              => 'mwl',
    'miscellaneouslanguage'                  => 'mis',
    'mohawk'                                 => 'moh',
    'moksha'                                 => 'mdf',
    'moldavian'                              => 'mo',
    'mongo'                                  => 'lol',
    'monkhmerlanguage'                       => 'mkh',
    'morisyen'                               => 'mfe',
    'mossi'                                  => 'mos',
    'multiplelanguages'                      => 'mul',
    'mundalanguage'                          => 'mun',
    'nahuatl'                                => 'nah',
    'nauru'                                  => 'na',
    'navajo'                                 => 'nv',
    'ndonga'                                 => 'ng',
    'neapolitan'                             => 'nap',
    'newari'                                 => 'new',
    'nias'                                   => 'nia',
    'nigerkordofanianlanguage'               => 'nic',
    'nilosaharanlanguage'                    => 'ssa',
    'niuean'                                 => 'niu',
    'nogai'                                  => 'nog',
    'nolinguisticcontent'                    => 'zxx',
    'northamericanindianlanguage'            => 'nai',
    'northernfrisian'                        => 'frr',
    'northernsami'                           => 'se',
    'northernsotho'                          => 'nso',
    'northndebele'                           => 'nd',
    "norwegianbokm\Ã\¥l"                   => 'nb',
    'nubianlanguage'                         => 'nub',
    'nyamwezi'                               => 'nym',
    'nyanja'                                 => 'ny',
    'nyankole'                               => 'nyn',
    'nyasatonga'                             => 'tog',
    'nyoro'                                  => 'nyo',
    'nzima'                                  => 'nzi',
    "n\â\\ko"                           => 'nqo',
    'ojibwa'                                 => 'oj',
    'oldenglish'                             => 'ang',
    'oldfrench'                              => 'fro',
    'oldhighgerman'                          => 'goh',
    'oldirish'                               => 'sga',
    'oldnorse'                               => 'non',
    'oldpersian'                             => 'peo',
    "oldproven\Ã\§al"                      => 'pro',
    'oromo'                                  => 'om',
    'osage'                                  => 'osa',
    'ossetic'                                => 'os',
    'otomianlanguage'                        => 'oto',
    'ottomanturkish'                         => 'ota',
    'pahlavi'                                => 'pal',
    'palauan'                                => 'pau',
    'pali'                                   => 'pi',
    'pampanga'                               => 'pam',
    'pangasinan'                             => 'pag',
    'papiamento'                             => 'pap',
    'papuanlanguage'                         => 'paa',
    'philippinelanguage'                     => 'phi',
    'phoenician'                             => 'phn',
    'pohnpeian'                              => 'pon',
    'portuguesebasedcreoleorpidgin'          => 'cpp',
    'prakritlanguage'                        => 'pra',
    'quechua'                                => 'qu',
    'rajasthani'                             => 'raj',
    'rapanui'                                => 'rap',
    'rarotongan'                             => 'rar',
    'rhaetoromance'                          => 'rm',
    'romancelanguage'                        => 'roa',
    'romany'                                 => 'rom',
    'rundi'                                  => 'rn',
    'salishanlanguage'                       => 'sal',
    'samaritanaramaic'                       => 'sam',
    'samilanguage'                           => 'smi',
    'samoan'                                 => 'sm',
    'sandawe'                                => 'sad',
    'sango'                                  => 'sg',
    'santali'                                => 'sat',
    'sardinian'                              => 'sc',
    'sasak'                                  => 'sas',
    'scots'                                  => 'sco',
    'selkup'                                 => 'sel',
    'semiticlanguage'                        => 'sem',
    'serer'                                  => 'srr',
    'shan'                                   => 'shn',
    'shona'                                  => 'sn',
    'sichuanyi'                              => 'ii',
    'sicilian'                               => 'scn',
    'sidamo'                                 => 'sid',
    'signlanguage'                           => 'sgn',
    'siksika'                                => 'bla',
    'sinotibetanlanguage'                    => 'sit',
    'siouanlanguage'                         => 'sio',
    'skoltsami'                              => 'sms',
    'slave'                                  => 'den',
    'slaviclanguage'                         => 'sla',
    'sogdien'                                => 'sog',
    'songhai'                                => 'son',
    'soninke'                                => 'snk',
    'sorbianlanguage'                        => 'wen',
    'southamericanindianlanguage'            => 'sai',
    'southernaltai'                          => 'alt',
    'southernsami'                           => 'sma',
    'southndebele'                           => 'nr',
    'sranantongo'                            => 'srn',
    'sukuma'                                 => 'suk',
    'sumerian'                               => 'sux',
    'susu'                                   => 'sus',
    'swati'                                  => 'ss',
    'swissfrench'                            => 'fr_ch',
    'swissgerman'                            => 'gsw',
    'swisshighgerman'                        => 'de_ch',
    'syriac'                                 => 'syr',
    'tagalog'                                => 'tl',
    'tahitian'                               => 'ty',
    'tailanguage'                            => 'tai',
    'tajik'                                  => 'tg',
    'tamashek'                               => 'tmh',
    'taroko'                                 => 'trv',
    'tatar'                                  => 'tt',
    'tereno'                                 => 'ter',
    'tetum'                                  => 'tet',
    'tibetan'                                => 'bo',
    'tigre'                                  => 'tig',
    'timne'                                  => 'tem',
    'tiv'                                    => 'tiv',
    'tlingit'                                => 'tli',
    'tokelau'                                => 'tkl',
    'tokpisin'                               => 'tpi',
    'tonga'                                  => 'to',
    'tsimshian'                              => 'tsi',
    'tsonga'                                 => 'ts',
    'tswana'                                 => 'tn',
    'tumbuka'                                => 'tum',
    'tupilanguage'                           => 'tup',
    'tuvalu'                                 => 'tvl',
    'tuvinian'                               => 'tyv',
    'tyap'                                   => 'kcg',
    "u\.s\.english"                          => 'en_us',
    'udmurt'                                 => 'udm',
    'ugaritic'                               => 'uga',
    'umbundu'                                => 'umb',
    'unknownorinvalidlanguage'               => 'und',
    'uppersorbian'                           => 'hsb',
    'vai'                                    => 'vai',
    'venda'                                  => 've',
    "volap\Ã\¼k"                           => 'vo',
    'votic'                                  => 'vot',
    'wakashanlanguage'                       => 'wak',
    'walamo'                                 => 'wal',
    'walloon'                                => 'wa',
    'waray'                                  => 'war',
    'washo'                                  => 'was',
    'wolof'                                  => 'wo',
    'yakut'                                  => 'sah',
    'yao'                                    => 'yao',
    'yapese'                                 => 'yap',
    'yoruba'                                 => 'yo',
    'yupiklanguage'                          => 'ypk',
    'zande'                                  => 'znd',
    'zapotec'                                => 'zap',
    'zaza'                                   => 'zza',
    'zenaga'                                 => 'zen',
    'zhuang'                                 => 'za',
    'zuni'                                   => 'zun',
    'азарбежан'                     => 'az',
    'албани'                           => 'sq',
    'амхарик'                         => 'am',
    'англи'                             => 'en',
    'араб'                               => 'ar',
    'армен'                             => 'hy',
    'ассамүндэстэн'             => 'as',
    'афган'                             => 'ps',
    'африк'                             => 'af',
    'африкийнсвахилихэл'   => 'sw',
    'балба'                             => 'ne',
    'баск'                               => 'eu',
    'беларусь'                       => 'be',
    'бенгаль'                         => 'bn',
    'бихарихэл'                     => 'bh',
    'болгар'                           => 'bg',
    'босниа'                           => 'bs',
    'бретон'                           => 'br',
    'вьетнам'                         => 'vi',
    'галик'                             => 'gl',
    'герман'                           => 'de',
    'голланд'                         => 'nl',
    'голландынфрисианхэл' => 'fy',
    'грек'                               => 'el',
    'гуарани'                         => 'gn',
    'гүрж'                               => 'ka',
    'дани'                               => 'da',
    'зулу'                               => 'zu',
    'иддиш'                             => 'yi',
    'индонези'                       => 'id',
    'интерлингво'                 => 'ia',
    'ирланд'                           => 'ga',
    'исланд'                           => 'is',
    'испани'                           => 'es',
    'итали'                             => 'it',
    'камбуч'                           => 'km',
    'каннада'                         => 'kn',
    'каталан'                         => 'ca',
    'кипр'                               => 'he',
    'киргиз'                           => 'ky',
    'клингонхэл'                   => 'tlh',
    'курд'                               => 'ku',
    'лаотиан'                         => 'lo',
    'латви'                             => 'lv',
    'латин'                             => 'la',
    'лингала'                         => 'ln',
    'литви'                             => 'lt',
    'македони'                       => 'mk',
    'малай'                             => 'ms',
    'малайлам'                       => 'ml',
    'малти'                             => 'mt',
    'монгол'                           => 'mn',
    'норвеги'                         => 'no',
    'норвегинынорск'           => 'nn',
    'нэгдмэлхэл'                   => 'ie',
    'ория'                               => 'or',
    'орос'                               => 'ru',
    'пакистаныурду'             => 'ur',
    'пенжаби'                         => 'pa',
    'перс'                               => 'fa',
    'польш'                             => 'pl',
    'португали'                     => 'pt',
    'португалибразил'         => 'pt_br',
    'португалипортугали'   => 'pt_pt',
    'румын'                             => 'ro',
    'санскирит'                     => 'sa',
    'серби'                             => 'sr',
    'сесото'                           => 'st',
    'синдхи'                           => 'sd',
    'словак'                           => 'sk',
    'словени'                         => 'sl',
    'солонгос'                       => 'ko',
    'сомали'                           => 'so',
    'сунданесхэл'                 => 'su',
    'тагало'                           => 'fil',
    'тай'                                 => 'th',
    'тамил'                             => 'ta',
    'тви'                                 => 'tw',
    'тикрина'                         => 'ti',
    'турк'                               => 'tr',
    'туркмен'                         => 'tk',
    'тэлүгү'                           => 'te',
    'узбек'                             => 'uz',
    'уйгур'                             => 'ug',
    'украин'                           => 'uk',
    'унгар'                             => 'hu',
    'уэлс'                               => 'cy',
    'финлянд'                         => 'fi',
    'франц'                             => 'fr',
    'францынокситан'           => 'oc',
    'фөриэсхэл'                     => 'fo',
    'хинди'                             => 'hi',
    'хорвати'                         => 'hr',
    'хорватынсерб'               => 'sh',
    'хоса'                               => 'xh',
    'хятад'                             => 'zh',
    'чех'                                 => 'cs',
    'швед'                               => 'sv',
    'шотландкелт'                 => 'gd',
    'шриланк'                         => 'si',
    'энэтхэгийнгужарати'   => 'gu',
    'энэтхэгийнмарати'       => 'mr',
    'эсперанто'                     => 'eo',
    'эстони'                           => 'et',
    'ява'                                 => 'jv',
    'япон'                               => 'ja',
);

1;
