/* liblouisxml Braille Transcription Library

   This file may contain code borrowed from the Linux screenreader
   BRLTTY, copyright (C) 1999-2006 by
   the BRLTTY Team

   Copyright (C) 2004, 2005, 2006
   ViewPlus Technologies, Inc. www.viewplus.com
   and
   JJB Software, Inc. www.jjb-software.com
   All rights reserved

   This file is free software; you can redistribute it and/or modify it
   under the terms of the Lesser or Library GNU General Public License 
   as published by the
   Free Software Foundation; either version 3, or (at your option) any
   later version.

   This file is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
   Library GNU General Public License for more details.

   You should have received a copy of the Library GNU General Public 
   License along with this program; see the file COPYING.  If not, write to
   the Free Software Foundation, 51 Franklin Street, Fifth Floor,
   Boston, MA 02110-1301, USA.

   Maintained by John J. Boyer john.boyer@jjb-software.com
   */

#include <stdio.h>
#include <string.h>
#include "louisxml.h"

static void musicText (xmlNode * node, int action);
static void musicCdata (xmlNode * node);
static int musicEmptyElement (xmlNode * node);

int
transcribe_music (xmlNode * node, int action)
{
  xmlNode *child;
  int branchCount = 0;
  if (action != 0)
push_sem_stack (node);
  switch (ud->stack[ud->top])
    {
    case no:
      if (ud->text_length > 0 && ud->text_length < MAX_LENGTH &&
	  ud->text_buffer[ud->text_length - 1] > 32)
	ud->text_buffer[ud->text_length++] = 32;
      break;
    case skip:
      if (action != 0)
	pop_sem_stack ();
      return 0;
    case math:
      transcribe_math (node, 0);
      if (action != 0)
	pop_sem_stack ();
      return 1;
    default:
      break;
    }
  child = node->children;
  while (child)
    {
      switch (child->type)
	{
	case XML_ELEMENT_NODE:
insert_code (node, branchCount);
branchCount++;
	  if (child->children)
	    transcribe_paragraph (child, 1);
	  else
	    musicEmptyElement (child);
	  break;
	case XML_TEXT_NODE:
	  musicText (child, action);
	  break;
	case XML_CDATA_SECTION_NODE:
	  musicCdata (child);
	  break;
	default:
	  break;
	}
      child = child->next;
    }
insert_code (node, branchCount);
  insert_code (node, -1);
  if (action != 0)
    {
      pop_sem_stack ();
      return 1;
    }
  switch (ud->stack[ud->top])
    {
    case table:
    case tblhead:
    case tblrow:
    case caption:
    case exercise1:
    case exercise2:
    case exercise3:
    case directions:
    case stanza:
    case quotation:
    case attribution:
    case section:
    case subsection:
    case list:
      write_paragraph (para);
      break;
    case para:
      write_paragraph (para);
      break;
    case center:
      write_paragraph (para);
      break;
    case heading4:
    case heading3:
      write_paragraph (para);
      break;
    case heading2:
      write_paragraph (para);
      break;
    case heading1:
      write_paragraph (para);
      break;
    default:
      break;
    }
  pop_sem_stack ();
  return 1;
}

static int
musicEmptyElement (xmlNode * node)
{
push_sem_stack (node);
  switch (ud->stack[ud->top])
    {
    case softreturn:
      insert_code (node, 0);
      break;
    case boxline:
      break;
    case blankline:
      break;
    case newpage:
      break;
    case righthandpage:
      break;
    default:
      break;
    }
  pop_sem_stack ();
  return 1;
}

static void
musicText (xmlNode * node, int action)
{
insert_text (node);
}

static void
musicCdata (xmlNode * node)
{
  insert_utf8 (node->content);
}
