#!/usr/bin/env python3

vars = 'k','l','p','q','r','s','x','y','z'

# ===== top

csh = '''// auto-generated by inttypes/create.py

#ifndef crypto_intN_h
#define crypto_intN_h

#include <inttypes.h>
#define crypto_intN intN_t

#define crypto_intN_optblocker namespace_intN_optblocker
extern volatile crypto_intN crypto_intN_optblocker;

'''

cuh = '''// auto-generated by inttypes/create.py

#ifndef crypto_uintN_h
#define crypto_uintN_h

#include <inttypes.h>
#define crypto_uintN uintN_t
#define crypto_uintN_signed intN_t

#define crypto_uintN_signed_optblocker namespace_uintN_signed_optblocker
extern volatile crypto_uintN_signed crypto_uintN_signed_optblocker;

'''

# ===== functions

for which,fun in (

('both',
'''TYPE TYPE_load(const unsigned char *S) {
  TYPE Z = 0;
  int K;
  for (K = 0;K < N;K += 8)
    Z |= ((TYPE) (*S++)) << K;
  return Z;
}'''
),

('both',
'''void TYPE_store(unsigned char *S,TYPE X) {
  int K;
  for (K = 0;K < N;K += 8)
    *S++ = X >> K;
}'''
),

# same as (X << (S % N)) but without assuming barrel shifter
('both',
'''TYPE TYPE_shlmod(TYPE X,TYPE S) {
  int K, L;
  for (L = 0,K = 1;K < N;++L,K *= 2)
    X ^= (X ^ (X << K)) & -((S >> L) & 1);
  return X;
}'''
),

('both',
'''SIGNED SIGNED_negative_mask(SIGNED X) {
  X >>= N-6;
  X ^= SIGNED_optblocker;
  X >>= 5;
  return X;
}'''
),

('both',
'''TYPE TYPE_nonzero_mask(TYPE X) {
  return SIGNED_negative_mask(X | -X);
}'''
),

('signed',
'''TYPE TYPE_positive_mask(TYPE X)
{
  TYPE Z = -X;
  Z ^= X & Z;
  return TYPE_negative_mask(Z);
}'''
),

('both',
'''TYPE TYPE_zero_mask(TYPE X) {
  return ~TYPE_nonzero_mask(X);
}''',
),

('both',
'''TYPE TYPE_unequal_mask(TYPE X,TYPE Y) {
  return TYPE_nonzero_mask(X ^ Y);
}''',
),

('both',
'''TYPE TYPE_equal_mask(TYPE X,TYPE Y) {
  return ~TYPE_unequal_mask(X,Y);
}''',
),

('signed',
'''TYPE TYPE_min(TYPE X,TYPE Y)
{
  TYPE R = Y ^ X;
  TYPE Z = Y - X;
  Z ^= R & (Z ^ Y);
  Z = TYPE_negative_mask(Z);
  Z &= R;
  return X ^ Z;
}'''
),

('unsigned',
'''TYPE TYPE_min(TYPE X,TYPE Y) {
  TYPE R = Y ^ X;
  TYPE Z = Y - X;
  Z ^= R & (Z ^ Y ^ (((TYPE) 1) << (N-1)));
  Z = SIGNED_negative_mask(Z);
  Z &= R;
  return X ^ Z;
}'''
),

('signed',
'''TYPE TYPE_max(TYPE X,TYPE Y) {
  TYPE R = Y ^ X;
  TYPE Z = Y - X;
  Z ^= R & (Z ^ Y);
  Z = TYPE_negative_mask(Z);
  Z &= R;
  return Y ^ Z;
}'''
),

('unsigned',
'''TYPE TYPE_max(TYPE X,TYPE Y) {
  TYPE R = Y ^ X;
  TYPE Z = Y - X;
  Z ^= R & (Z ^ Y ^ (((TYPE) 1) << (N-1)));
  Z = SIGNED_negative_mask(Z);
  Z &= R;
  return Y ^ Z;
}'''
),

('signed',
'''void TYPE_minmax(TYPE *P,TYPE *Q) {
  TYPE X = *P;
  TYPE Y = *Q;
  TYPE R = Y ^ X;
  TYPE Z = Y - X;
  Z ^= R & (Z ^ Y);
  Z = TYPE_negative_mask(Z);
  Z &= R;
  *P = X ^ Z;
  *Q = Y ^ Z;
}'''
),

('unsigned',
'''void TYPE_minmax(TYPE *P,TYPE *Q) {
  TYPE X = *P;
  TYPE Y = *Q;
  TYPE R = Y ^ X;
  TYPE Z = Y - X;
  Z ^= R & (Z ^ Y ^ (((TYPE) 1) << (N-1)));
  Z = SIGNED_negative_mask(Z);
  Z &= R;
  *P = X ^ Z;
  *Q = Y ^ Z;
}'''
),

('signed',
'''TYPE TYPE_smaller_mask(TYPE X,TYPE Y) {
  TYPE R = X ^ Y;
  TYPE Z = X - Y;
  Z ^= R & (Z ^ X);
  return TYPE_negative_mask(Z);
}'''
),

('unsigned',
'''TYPE TYPE_smaller_mask(TYPE X,TYPE Y) {
  TYPE R = X ^ Y;
  TYPE Z = X - Y;
  Z ^= R & (Z ^ X ^ (((TYPE) 1) << (N-1)));
  return SIGNED_negative_mask(Z);
}'''
),

('both',
'''TYPE TYPE_leq_mask(TYPE X,TYPE Y) {
  return ~TYPE_smaller_mask(Y,X);
}'''
),

):
  if which in ('both','signed'):
    data = fun
    data = data.replace('TYPE','crypto_intN')
    data = data.replace('SIGNED','crypto_intN')
    for v in vars:
      data = data.replace(v.upper(),'crypto_intN_'+v)
    csh += '__attribute__((unused))\n'
    csh += 'static inline\n'
    csh += data
    csh += '\n\n'

  if which in ('both','unsigned'):
    data = fun
    data = data.replace('TYPE','crypto_uintN')
    data = data.replace('SIGNED','crypto_uintN_signed')
    for v in vars:
      data = data.replace(v.upper(),'crypto_uintN_'+v)
    cuh += '__attribute__((unused))\n'
    cuh += 'static inline\n'
    cuh += data
    cuh += '\n\n'

# ===== bottom

csh += '''#endif'''

cuh += '''#endif'''

# ===== ship it

with open('crypto_intN.h','w') as f:
  f.write(csh)

with open('crypto_uintN.h','w') as f:
  f.write(cuh)

with open('intN_optblocker.c','w') as f:
  f.write('''// auto-generated by inttypes/create.py
#include "crypto_intN.h"

volatile crypto_intN crypto_intN_optblocker = 0;
''')

with open('uintN_optblocker.c','w') as f:
  f.write('''// auto-generated by inttypes/create.py
#include "crypto_uintN.h"

volatile crypto_uintN_signed crypto_uintN_signed_optblocker = 0;
''')
