#include "printer_parts.hpp"

const TestData PRINTER_PART_POLYGONS =
{
    {
        {-5000000, 8954050},
        {5000000, 8954050},
        {5000000, -45949},
        {4972609, -568550},
        {3500000, -8954050},
        {-3500000, -8954050},
        {-4972609, -568550},
        {-5000000, -45949},
        {-5000000, 8954050},
    },
    {
        {-63750000, -8000000},
        {-54750000, 46000000},
        {50750000, 46000000},
        {63750000, 33000000},
        {63750000, -46000000},
        {-54750000, -46000000},
        {-63750000, -28000000},
        {-63750000, -8000000},
    },
    {
        {-52750000, 41512348},
        {-31250000, 45987651},
        {52750000, 45987651},
        {52750000, -45987651},
        {-52750000, -45987651},
        {-52750000, 41512348},
    },
    {
        {-3900000, 14000000},
        {-2167950, 14000000},
        {1721454, 7263400},
        {3828529, 3613790},
        {3838809, 3582149},
        {3871560, 3270569},
        {3900000, 3000000},
        {3500000, -3000000},
        {3471560, -3270565},
        {3447549, -3498986},
        {3292510, -3976167},
        {3099999, -4512949},
        {2530129, -5500000},
        {807565, -8483570},
        {-2377349, -14000000},
        {-3900000, -14000000},
        {-3900000, 14000000},
    },
    {
        {-31750000, -1000000},
        {-25250000, 40500000},
        {-18250000, 47500000},
        {10750000, 47500000},
        {16750000, 41500000},
        {31750000, -37000000},
        {31750000, -43857898},
        {28107900, -47500000},
        {18392099, -47500000},
        {-20750000, -46500000},
        {-31750000, -4000000},
        {-31750000, -1000000},
    },
    {
        {-34625000, -14265399},
        {-10924999, 24875000},
        {33325000, 24875000},
        {37575000, 20625000},
        {37575000, 17625000},
        {26575000, -24875000},
        {-8924999, -24875000},
        {-34625000, -24484600},
        {-37575000, -19375000},
        {-34625000, -14265399},
    },
    {
        {-14000000, 9000000},
        {-11000000, 17000000},
        {14000000, 17000000},
        {14000000, -17000000},
        {-11000000, -17000000},
        {-14000000, -8000000},
        {-14000000, 9000000},
    },
    {
        {-5300000, 2227401},
        {-237800, 5150001},
        {5299999, 5150001},
        {5299999, 650001},
        {4699999, -5149997},
        {-5300000, -5149997},
        {-5300000, 2227401},
    },
    {
        {-12000000, 18000000},
        {12000000, 18000000},
        {12000000, -18000000},
        {-12000000, -18000000},
        {-12000000, 18000000},
    },
    {
        {-18000000, -1000000},
        {-15000000, 22000000},
        {-11000000, 26000000},
        {11000000, 26000000},
        {15000000, 22000000},
        {18000000, -1000000},
        {18000000, -26000000},
        {-18000000, -26000000},
        {-18000000, -1000000},
    },
    {
        {-77500000, 30000000},
        {-72500000, 35000000},
        {72500000, 35000000},
        {77500000, 30000000},
        {77500000, -32928901},
        {75428901, -35000000},
        {-75428901, -35000000},
        {-77500000, -32928901},
        {-77500000, 30000000},
    },
    {
        {-9945219, -3065619},
        {-9781479, -2031780},
        {-9510560, -1020730},
        {-9135450, -43529},
        {-2099999, 14110899},
        {2099999, 14110899},
        {9135450, -43529},
        {9510560, -1020730},
        {9781479, -2031780},
        {9945219, -3065619},
        {10000000, -4110899},
        {9945219, -5156179},
        {9781479, -6190019},
        {9510560, -7201069},
        {9135450, -8178270},
        {8660249, -9110899},
        {8090169, -9988750},
        {7431449, -10802209},
        {6691309, -11542349},
        {5877850, -12201069},
        {5000000, -12771149},
        {4067369, -13246350},
        {3090169, -13621459},
        {2079119, -13892379},
        {1045279, -14056119},
        {0, -14110899},
        {-1045279, -14056119},
        {-2079119, -13892379},
        {-3090169, -13621459},
        {-4067369, -13246350},
        {-5000000, -12771149},
        {-5877850, -12201069},
        {-6691309, -11542349},
        {-7431449, -10802209},
        {-8090169, -9988750},
        {-8660249, -9110899},
        {-9135450, -8178270},
        {-9510560, -7201069},
        {-9781479, -6190019},
        {-9945219, -5156179},
        {-10000000, -4110899},
        {-9945219, -3065619},
    },
    {
        {-34192394, -5192389},
        {-31499996, 39000000},
        {-8183795, 47668998},
        {-6769596, 47668998},
        {-4648197, 45547698},
        {34192394, 6707109},
        {34192394, 5192389},
        {31500003, -39000000},
        {8183803, -47668998},
        {6769603, -47668998},
        {4648202, -45547698},
        {-32474895, -8424619},
        {-34192394, -6707109},
        {-34192394, -5192389},
    },
    {
        {-23475500, -11910099},
        {-18000000, 8217699},
        {-11139699, 20100000},
        {-10271400, 20899999},
        {9532010, 20899999},
        {11199999, 20100000},
        {18500000, 8600000},
        {23475500, -11910099},
        {23799999, -14899999},
        {23706600, -15788900},
        {23668899, -16147499},
        {23281299, -17340400},
        {22654100, -18426700},
        {21814800, -19358900},
        {20799999, -20096199},
        {19654100, -20606300},
        {18427200, -20867099},
        {17799999, -20899999},
        {-17799999, -20899999},
        {-18427200, -20867099},
        {-19654100, -20606300},
        {-20799999, -20096199},
        {-21814800, -19358900},
        {-22654100, -18426700},
        {-23281299, -17340400},
        {-23668899, -16147499},
        {-23799999, -14899999},
        {-23475500, -11910099},
    },
    {
        {-32000000, 10000000},
        {-31934440, 10623733},
        {-31740640, 11220210},
        {-31427049, 11763360},
        {-31007389, 12229430},
        {-30500000, 12598079},
        {-29927051, 12853170},
        {-29313585, 12983570},
        {16000000, 16000000},
        {26000000, 16000000},
        {31007400, 12229430},
        {31427101, 11763360},
        {31740600, 11220210},
        {31934398, 10623733},
        {32000000, 10000000},
        {32000000, -13000000},
        {31934398, -13623699},
        {31740600, -14220199},
        {31427101, -14763399},
        {31007400, -15229400},
        {30500000, -15598100},
        {29927101, -15853200},
        {29313598, -15983600},
        {29000000, -16000000},
        {-28000000, -16000000},
        {-29313585, -15983600},
        {-29927051, -15853200},
        {-30500000, -15598100},
        {-31007389, -15229400},
        {-31427049, -14763399},
        {-31740640, -14220199},
        {-31934440, -13623699},
        {-32000000, -13000000},
        {-32000000, 10000000},
    },
    {
        {-36133789, -46431022},
        {-36040100, -46171817},
        {-35852722, -45653411},
        {2200073, 59616485},
        {12112792, 87039184},
        {14274505, 93019332},
        {14382049, 93291641},
        {14508483, 93563430},
        {14573425, 93688369},
        {14654052, 93832443},
        {14818634, 94096328},
        {14982757, 94327621},
        {15001708, 94352630},
        {15202392, 94598999},
        {15419342, 94833160},
        {15497497, 94910552},
        {15650848, 95053039},
        {15894866, 95256866},
        {16104309, 95412185},
        {16149047, 95443206},
        {16410888, 95611038},
        {16677795, 95759750},
        {16782348, 95812332},
        {16947143, 95889144},
        {17216400, 95999465},
        {17483123, 96091293},
        {17505554, 96098251},
        {17745178, 96165542},
        {18000671, 96223373},
        {18245880, 96265884},
        {18484039, 96295257},
        {18976715, 96319580},
        {31135131, 96319580},
        {31697082, 96287902},
        {31746368, 96282104},
        {32263000, 96190719},
        {32338623, 96172576},
        {32821411, 96026641},
        {32906188, 95995391},
        {33360565, 95797012},
        {33443420, 95754882},
        {33869171, 95505874},
        {33900756, 95485122},
        {34136413, 95318618},
        {34337127, 95159790},
        {34377288, 95125930},
        {34619628, 94905410},
        {34756286, 94767364},
        {34859008, 94656143},
        {35090606, 94378067},
        {35120849, 94338546},
        {35309295, 94072113},
        {35434875, 93871475},
        {35510070, 93740310},
        {35688232, 93385772},
        {35699096, 93361679},
        {35839782, 93012557},
        {35905487, 92817459},
        {35961578, 92625488},
        {36048004, 92249023},
        {36051574, 92229934},
        {36108856, 91831405},
        {36122985, 91667816},
        {36133789, 91435317},
        {36129669, 91085830},
        {36127685, 91046661},
        {36092742, 90669830},
        {36069946, 90514739},
        {36031829, 90308425},
        {35948211, 89965225},
        {34482635, 84756820},
        {27911407, 61403976},
        {-5872558, -58657440},
        {-14243621, -88406509},
        {-14576812, -89590599},
        {-15421997, -92594200},
        {-15657684, -93431732},
        {-16038940, -93720520},
        {-16420196, -94009307},
        {-17182708, -94586875},
        {-18834838, -95838272},
        {-19470275, -96319580},
        {-21368133, -96319580},
        {-22763854, -96319534},
        {-29742462, -96319274},
        {-32533935, -96319168},
        {-36133789, -54619018},
        {-36133789, -46431022},
    },
    {
        {-26000000, 25500000},
        {-6500000, 45000000},
        {17499998, 45000000},
        {23966310, 38533699},
        {26000000, 36500000},
        {26000000, -19000000},
        {25950000, -24500000},
        {17000000, -42214698},
        {14300000, -45000000},
        {-14299999, -45000000},
        {-17500000, -41714698},
        {-23400001, -24500000},
        {-26000000, -10464000},
        {-26000000, 25500000},
    },
    {
        {-26000000, 16636100},
        {-25072200, 18777799},
        {-16500000, 35299999},
        {-15050000, 36750000},
        {13550000, 36750000},
        {15000000, 35299999},
        {26000000, 16045200},
        {26000000, -2750000},
        {16500000, -34507900},
        {14840600, -36167301},
        {14257900, -36750000},
        {-14257900, -36750000},
        {-16500000, -34507900},
        {-26000000, -2750000},
        {-26000000, 16636100},
    },
    {
        {-18062349, 18950099},
        {4644938, 20049900},
        {6230361, 20049900},
        {7803279, 19851200},
        {9338899, 19456899},
        {10812990, 18873300},
        {12202310, 18109500},
        {13484951, 17177600},
        {14640670, 16092300},
        {15651250, 14870700},
        {16500749, 13532100},
        {17175849, 12097599},
        {17665750, 10589700},
        {17962850, 9032400},
        {18062349, 7450099},
        {17962850, 5867799},
        {15810750, -11007740},
        {15683750, -11727769},
        {15506849, -12437200},
        {15280929, -13132559},
        {15007040, -13810470},
        {14686531, -14467609},
        {14320949, -15100799},
        {13912099, -15706950},
        {13461959, -16283100},
        {12972730, -16826450},
        {12446790, -17334339},
        {11886699, -17804309},
        {11295190, -18234069},
        {10675149, -18621520},
        {10029590, -18964771},
        {9361650, -19262149},
        {8674600, -19512220},
        {7971780, -19713699},
        {7256609, -19865798},
        {6532589, -19967498},
        {5803222, -20018501},
        {5437650, -20024900},
        {-1062349, -20049900},
        {-16562349, -20049900},
        {-18062349, -18549900},
        {-18062349, 18950099},
    },
    {
        {-18062349, 41299900},
        {-1062349, 41299900},
        {15280929, -8117440},
        {15506849, -8812799},
        {15683750, -9522230},
        {15810750, -10242259},
        {17962850, -27117799},
        {18062349, -28700099},
        {17962850, -30282400},
        {17665750, -31839700},
        {17175849, -33347599},
        {16500749, -34782100},
        {15651250, -36120700},
        {14640670, -37342300},
        {13484951, -38427600},
        {12202310, -39359500},
        {10812990, -40123298},
        {9338899, -40706901},
        {7803279, -41101200},
        {6230361, -41299900},
        {4644938, -41299900},
        {-18062349, -40200099},
        {-18062349, 41299900},
    },
    {
        {-11750000, 13057900},
        {-9807860, 15000000},
        {4392139, 24000000},
        {11750000, 24000000},
        {11750000, -24000000},
        {4392139, -24000000},
        {-9807860, -15000000},
        {-11750000, -13057900},
        {-11750000, 13057900},
    },
    {
        {-12500000, 17500000},
        {12500000, 17500000},
        {12500000, -17500000},
        {-12500000, -17500000},
        {-12500000, 17500000},
    },
    {
        {-23500000, 11500000},
        {-13857859, 21000000},
        {-11000000, 21000000},
        {18500000, 500000},
        {23500000, -4500000},
        {23500000, -19500000},
        {22000000, -21000000},
        {-23500000, -21000000},
        {-23500000, 11500000},
    },
    {
        {-13000000, 5250000},
        {-4000000, 6750000},
        {4000000, 6750000},
        {13000000, 5250000},
        {13000000, 838459},
        {11376299, -1973939},
        {10350899, -3750000},
        {8618800, -6750000},
        {-8498290, -6750000},
        {-13000000, 1047180},
        {-13000000, 5250000},
    },
    {
        {-25000000, 50500000},
        {-21500000, 54000000},
        {18286800, 54000000},
        {25000000, 47286800},
        {25000000, -47286800},
        {18286800, -54000000},
        {-21500000, -54000000},
        {-25000000, -50500000},
        {-25000000, 50500000},
    },
    {
        {-19000000, 46000000},
        {-16799999, 46000000},
        {14000000, 34000000},
        {19000000, 29000000},
        {19000000, -29000000},
        {14000000, -34000000},
        {-16799999, -46000000},
        {-19000000, -46000000},
        {-19000000, 46000000},
    },
    {
        {-7956170, 836226},
        {-7825180, 1663290},
        {-7767529, 1914530},
        {-7608449, 2472140},
        {-7308360, 3253890},
        {-7083650, 3717780},
        {-6928199, 4000000},
        {-6472139, 4702280},
        {-5988090, 5304979},
        {-5945159, 5353040},
        {-5353040, 5945159},
        {-4702280, 6472139},
        {-4544519, 6583869},
        {-4000000, 6928199},
        {-3253890, 7308360},
        {-2836839, 7480130},
        {-2472140, 7608449},
        {-1663290, 7825180},
        {-964293, 7941669},
        {-836226, 7956170},
        {0, 8000000},
        {836226, 7956170},
        {964293, 7941669},
        {1663290, 7825180},
        {2472140, 7608449},
        {2836839, 7480130},
        {3253890, 7308360},
        {4000000, 6928199},
        {4544519, 6583869},
        {4702280, 6472139},
        {5353040, 5945159},
        {5945159, 5353040},
        {5988090, 5304979},
        {6472139, 4702280},
        {6928199, 4000000},
        {7083650, 3717780},
        {7308360, 3253890},
        {7608449, 2472140},
        {7767529, 1914530},
        {7825180, 1663290},
        {7956170, 836226},
        {8000000, 0},
        {7956170, -836226},
        {7825180, -1663290},
        {7767529, -1914530},
        {7608449, -2472140},
        {7308360, -3253890},
        {7083650, -3717780},
        {6928199, -4000000},
        {6472139, -4702280},
        {5988090, -5304979},
        {5945159, -5353040},
        {5353040, -5945159},
        {4702280, -6472139},
        {4544519, -6583869},
        {4000000, -6928199},
        {3253890, -7308360},
        {2836839, -7480130},
        {2472140, -7608449},
        {1663290, -7825180},
        {964293, -7941669},
        {836226, -7956170},
        {0, -8000000},
        {-836226, -7956170},
        {-964293, -7941669},
        {-1663290, -7825180},
        {-2472140, -7608449},
        {-2836839, -7480130},
        {-3253890, -7308360},
        {-4000000, -6928199},
        {-4544519, -6583869},
        {-4702280, -6472139},
        {-5353040, -5945159},
        {-5945159, -5353040},
        {-5988090, -5304979},
        {-6472139, -4702280},
        {-6928199, -4000000},
        {-7083650, -3717780},
        {-7308360, -3253890},
        {-7608449, -2472140},
        {-7767529, -1914530},
        {-7825180, -1663290},
        {-7956170, -836226},
        {-8000000, 0},
        {-7956170, 836226},
    },
};

const TestData STEGOSAUR_POLYGONS =
{
    {
        {113210205, 107034095},
        {113561798, 109153793},
        {113750099, 109914001},
        {114396499, 111040199},
        {114599197, 111321998},
        {115570404, 112657096},
        {116920097, 114166595},
        {117630599, 114609390},
        {119703704, 115583900},
        {120559494, 115811996},
        {121045410, 115754493},
        {122698097, 115526496},
        {123373001, 115370193},
        {123482406, 115315689},
        {125664199, 114129798},
        {125920303, 113968193},
        {128551208, 111866195},
        {129075592, 111443199},
        {135044692, 106572608},
        {135254898, 106347694},
        {135415100, 106102897},
        {136121704, 103779891},
        {136325103, 103086303},
        {136690093, 101284896},
        {136798309, 97568496},
        {136798309, 97470397},
        {136787399, 97375297},
        {136753295, 97272102},
        {136687988, 97158699},
        {136539794, 96946899},
        {135526702, 95550994},
        {135388488, 95382293},
        {135272491, 95279098},
        {135214904, 95250595},
        {135122894, 95218002},
        {134966705, 95165191},
        {131753997, 94380798},
        {131226806, 94331001},
        {129603393, 94193893},
        {129224197, 94188003},
        {127874107, 94215103},
        {126812797, 94690200},
        {126558197, 94813896},
        {118361801, 99824195},
        {116550796, 101078796},
        {116189704, 101380493},
        {114634002, 103027999},
        {114118103, 103820297},
        {113399200, 105568000},
        {113201705, 106093597},
        {113210205, 107034095},
    },
    {
        {77917999, 130563003},
        {77926300, 131300903},
        {77990196, 132392700},
        {78144195, 133328002},
        {78170593, 133427093},
        {78235900, 133657592},
        {78799598, 135466705},
        {78933296, 135832397},
        {79112899, 136247604},
        {79336303, 136670898},
        {79585197, 137080596},
        {79726303, 137309005},
        {79820297, 137431900},
        {79942199, 137549407},
        {90329193, 145990203},
        {90460197, 146094390},
        {90606399, 146184509},
        {90715194, 146230010},
        {90919601, 146267211},
        {142335296, 153077697},
        {143460296, 153153594},
        {143976593, 153182189},
        {145403991, 153148605},
        {145562301, 153131195},
        {145705993, 153102905},
        {145938796, 153053192},
        {146134094, 153010101},
        {146483184, 152920196},
        {146904693, 152806396},
        {147180099, 152670196},
        {147357788, 152581695},
        {147615295, 152423095},
        {147782287, 152294708},
        {149281799, 150908386},
        {149405303, 150784912},
        {166569305, 126952499},
        {166784301, 126638099},
        {166938491, 126393699},
        {167030899, 126245101},
        {167173004, 126015899},
        {167415298, 125607200},
        {167468292, 125504699},
        {167553100, 125320899},
        {167584594, 125250694},
        {167684997, 125004394},
        {167807098, 124672401},
        {167938995, 124255203},
        {168052307, 123694000},
        {170094100, 112846900},
        {170118408, 112684204},
        {172079101, 88437797},
        {172082000, 88294403},
        {171916290, 82827606},
        {171911590, 82705703},
        {171874893, 82641906},
        {169867004, 79529907},
        {155996795, 58147998},
        {155904998, 58066299},
        {155864791, 58054199},
        {134315704, 56830902},
        {134086486, 56817901},
        {98200096, 56817798},
        {97838195, 56818599},
        {79401695, 56865097},
        {79291297, 56865501},
        {79180694, 56869499},
        {79058799, 56885097},
        {78937301, 56965301},
        {78324691, 57374599},
        {77932998, 57638401},
        {77917999, 57764297},
        {77917999, 130563003},
    },
    {
        {75566848, 109289947},
        {75592651, 109421951},
        {75644248, 109534446},
        {95210548, 141223846},
        {95262649, 141307449},
        {95487854, 141401443},
        {95910850, 141511642},
        {96105651, 141550338},
        {106015045, 142803451},
        {106142852, 142815155},
        {166897460, 139500244},
        {167019348, 139484741},
        {168008239, 138823043},
        {168137542, 138735153},
        {168156250, 138616851},
        {173160751, 98882049},
        {174381546, 87916046},
        {174412246, 87579048},
        {174429443, 86988746},
        {174436141, 86297348},
        {174438949, 84912048},
        {174262939, 80999145},
        {174172546, 80477546},
        {173847549, 79140846},
        {173623840, 78294349},
        {173120239, 76485046},
        {173067138, 76300544},
        {173017852, 76137542},
        {172941543, 75903045},
        {172892547, 75753143},
        {172813537, 75533348},
        {172758453, 75387046},
        {172307556, 74196746},
        {171926544, 73192848},
        {171891448, 73100448},
        {171672546, 72524147},
        {171502441, 72085144},
        {171414459, 71859146},
        {171294250, 71552352},
        {171080139, 71019744},
        {171039245, 70928146},
        {170970550, 70813346},
        {170904235, 70704040},
        {170786254, 70524353},
        {168063247, 67259048},
        {167989547, 67184844},
        {83427947, 67184844},
        {78360847, 67201248},
        {78238845, 67220550},
        {78151550, 67350547},
        {77574554, 68220550},
        {77494949, 68342651},
        {77479949, 68464546},
        {75648345, 106513351},
        {75561050, 109165740},
        {75566848, 109289947},
    },
    {
        {75619415, 108041595},
        {83609863, 134885772},
        {83806945, 135450820},
        {83943908, 135727371},
        {84799934, 137289794},
        {86547897, 140033782},
        {86674118, 140192962},
        {86810661, 140364715},
        {87045211, 140619918},
        {88187042, 141853240},
        {93924575, 147393783},
        {94058013, 147454803},
        {111640083, 153754562},
        {111762550, 153787933},
        {111975250, 153835311},
        {112127426, 153842803},
        {116797996, 154005157},
        {116969688, 154010681},
        {117141731, 154005935},
        {117333145, 153988037},
        {118007507, 153919952},
        {118159675, 153902130},
        {118931480, 153771942},
        {120878150, 153379089},
        {121172164, 153319259},
        {122074508, 153034362},
        {122260681, 152970367},
        {122313438, 152949584},
        {130755096, 149423736},
        {130996063, 149316818},
        {138893524, 144469665},
        {138896423, 144466918},
        {169883666, 97686134},
        {170115036, 96518981},
        {170144317, 96365257},
        {174395645, 67672065},
        {174396560, 67664222},
        {174288452, 66839241},
        {174170364, 66096923},
        {174112731, 65952033},
        {174021377, 65823486},
        {173948608, 65743225},
        {173863830, 65654769},
        {170408340, 63627494},
        {170004867, 63394714},
        {169585632, 63194389},
        {169441162, 63137046},
        {168944274, 62952133},
        {160605072, 60214218},
        {160331573, 60126396},
        {159674743, 59916877},
        {150337249, 56943778},
        {150267730, 56922073},
        {150080139, 56864868},
        {149435333, 56676422},
        {149310241, 56640579},
        {148055419, 56285041},
        {147828796, 56230949},
        {147598205, 56181800},
        {147149963, 56093917},
        {146834457, 56044700},
        {146727966, 56028717},
        {146519729, 56004882},
        {146328521, 55989326},
        {146170684, 55990036},
        {146151321, 55990745},
        {145800170, 56003616},
        {145639526, 56017753},
        {145599426, 56022491},
        {145481338, 56039184},
        {145389556, 56052757},
        {145325134, 56062591},
        {145176574, 56086135},
        {145017272, 56113922},
        {107163085, 63504539},
        {101013870, 65454101},
        {100921798, 65535285},
        {95362182, 74174079},
        {75652366, 107803443},
        {75635391, 107834983},
        {75628814, 107853294},
        {75603431, 107933692},
        {75619415, 108041595},
    },
    {
        {83617141, 120264900},
        {84617370, 126416427},
        {84648635, 126601341},
        {84693695, 126816085},
        {84762496, 127082641},
        {84772140, 127117034},
        {84860748, 127391693},
        {84927398, 127550239},
        {85072967, 127789642},
        {85155151, 127908851},
        {86745422, 130042907},
        {86982666, 130317489},
        {89975143, 133230743},
        {90091384, 133338500},
        {96260833, 138719818},
        {96713928, 139103668},
        {98139297, 140307388},
        {102104766, 143511505},
        {102142089, 143536468},
        {102457626, 143735107},
        {103386764, 144312988},
        {103845001, 144579177},
        {104139175, 144737136},
        {104551254, 144932250},
        {104690155, 144985778},
        {104844238, 145010009},
        {105020034, 145010375},
        {128999633, 144082305},
        {129096542, 144076141},
        {133932327, 143370178},
        {134130615, 143326751},
        {134281250, 143289520},
        {135247116, 142993438},
        {150774948, 137828704},
        {150893478, 137786178},
        {151350921, 137608901},
        {159797760, 134318115},
        {159979827, 134244384},
        {159988128, 134240997},
        {160035186, 134221633},
        {160054962, 134211486},
        {160168762, 134132736},
        {160181228, 134121047},
        {160336425, 133961502},
        {160689147, 133564331},
        {161446258, 132710739},
        {163306427, 130611648},
        {164845474, 128873855},
        {165270233, 128393600},
        {165281478, 128380706},
        {165300598, 128358673},
        {165303497, 128355194},
        {166411590, 122772674},
        {166423767, 122708648},
        {164745605, 66237312},
        {164740341, 66193061},
        {164721755, 66082092},
        {164721160, 66078750},
        {164688476, 65914146},
        {164668426, 65859436},
        {164563110, 65765937},
        {164431152, 65715034},
        {163997619, 65550788},
        {163946426, 65531440},
        {162998107, 65173629},
        {162664978, 65049140},
        {162482696, 64991668},
        {162464660, 64989639},
        {148029083, 66896141},
        {147862396, 66932853},
        {130087829, 73341102},
        {129791564, 73469726},
        {100590927, 90307685},
        {100483535, 90373847},
        {100364990, 90458930},
        {96447448, 93276664},
        {95179656, 94189010},
        {93692718, 95260208},
        {87904327, 99430885},
        {87663711, 99606147},
        {87576202, 99683990},
        {87498199, 99801719},
        {85740264, 104173728},
        {85538925, 104710494},
        {84786132, 107265830},
        {84635955, 107801383},
        {84619506, 107868064},
        {84518463, 108287200},
        {84456848, 108613471},
        {84419158, 108826194},
        {84375244, 109093818},
        {84329818, 109435180},
        {84249862, 110179664},
        {84218429, 110572166},
        {83630020, 117995208},
        {83595535, 118787673},
        {83576217, 119290679},
        {83617141, 120264900},
    },
    {
        {91735549, 117640846},
        {91748252, 117958145},
        {91823547, 118515449},
        {92088752, 119477249},
        {97995346, 140538452},
        {98031051, 140660446},
        {98154449, 141060241},
        {98179855, 141133758},
        {98217056, 141232849},
        {98217147, 141233047},
        {98269256, 141337051},
        {98298950, 141387954},
        {98337753, 141445755},
        {99455047, 142984451},
        {99656250, 143247344},
        {102567855, 146783752},
        {102685150, 146906845},
        {102828948, 147031250},
        {102972457, 147120452},
        {103676147, 147539642},
        {103758956, 147586151},
        {103956756, 147682144},
        {104479949, 147931457},
        {104744453, 148044143},
        {104994750, 148123443},
        {105375648, 148158645},
        {109266250, 148178253},
        {109447753, 148169052},
        {109693649, 148129150},
        {113729949, 147337448},
        {113884552, 147303054},
        {115155349, 146956146},
        {117637145, 146174346},
        {154694046, 134048049},
        {156979949, 133128555},
        {157076843, 133059356},
        {157125045, 133001449},
        {157561340, 132300750},
        {157865753, 131795959},
        {157923156, 131667358},
        {158007049, 131297653},
        {158112747, 130777053},
        {158116653, 130640853},
        {158268951, 119981643},
        {158260040, 119824752},
        {158229949, 119563751},
        {149914047, 73458648},
        {149877548, 73331748},
        {144460754, 66413558},
        {144230545, 66153152},
        {144128051, 66075057},
        {143974853, 65973152},
        {142812744, 65353149},
        {141810943, 64837249},
        {141683349, 64805152},
        {141505157, 64784652},
        {108214355, 61896251},
        {107826354, 61866352},
        {107072151, 61821750},
        {106938850, 61873550},
        {106584251, 62055152},
        {106419952, 62147548},
        {100459152, 65546951},
        {100343849, 65615150},
        {100198852, 65716949},
        {99825149, 65979751},
        {94619247, 70330352},
        {94492355, 70480850},
        {94445846, 70547355},
        {94425354, 70588752},
        {94379753, 70687652},
        {94110252, 71443450},
        {94095252, 71569053},
        {91737251, 117308746},
        {91731048, 117430946},
        {91735549, 117640846},
    },
    {
        {108231399, 111763748},
        {108335403, 111927955},
        {108865203, 112754745},
        {109206703, 113283851},
        {127117500, 125545951},
        {127212097, 125560951},
        {127358497, 125563652},
        {131348007, 125551147},
        {131412002, 125550849},
        {131509506, 125535446},
        {131579391, 125431343},
        {132041000, 124735656},
        {132104690, 124637847},
        {144108505, 100950546},
        {144120605, 100853042},
        {144123291, 100764648},
        {144122695, 100475143},
        {144086898, 85637748},
        {144083602, 85549346},
        {144071105, 85451843},
        {144007003, 85354545},
        {143679595, 84864547},
        {143468597, 84551048},
        {143367889, 84539146},
        {109847702, 84436347},
        {109684700, 84458953},
        {105946502, 89406143},
        {105915901, 91160446},
        {105880905, 93187744},
        {105876701, 93441345},
        {108231399, 111763748},
    },
    {
        {102614700, 117684249},
        {102675102, 118074157},
        {102888999, 118743148},
        {103199707, 119517555},
        {103446800, 120099655},
        {103488204, 120193450},
        {104063903, 121373947},
        {104535499, 122192245},
        {104595802, 122295249},
        {104663002, 122402854},
        {104945701, 122854858},
        {105740501, 124038848},
        {106809700, 125479354},
        {107564399, 126380050},
        {108116203, 126975646},
        {123724700, 142516540},
        {124938400, 143705444},
        {127919601, 146599243},
        {128150894, 146821456},
        {128251602, 146917251},
        {128383605, 147041839},
        {128527709, 147176147},
        {128685699, 147321456},
        {128861007, 147481246},
        {132825103, 151046661},
        {133005493, 151205657},
        {133389007, 151488143},
        {133896499, 151858062},
        {134172302, 151991546},
        {134375000, 152063140},
        {135316101, 152300949},
        {136056304, 152220947},
        {136242706, 152186843},
        {136622207, 152016448},
        {136805404, 151908355},
        {147099594, 145766845},
        {147246704, 144900756},
        {147387603, 144048461},
        {144353698, 99345855},
        {144333801, 99232254},
        {144244598, 98812850},
        {144228698, 98757858},
        {144174606, 98616455},
        {133010101, 72396743},
        {132018905, 70280853},
        {130667404, 67536949},
        {129167297, 64854446},
        {128569198, 64098350},
        {124458503, 59135948},
        {124260597, 58946949},
        {123908706, 58658851},
        {123460098, 58327850},
        {122674499, 57840648},
        {122041801, 57712150},
        {121613403, 57699047},
        {121359901, 57749351},
        {121123199, 57826450},
        {120953498, 57882247},
        {120431701, 58198547},
        {120099205, 58599349},
        {119892303, 58903049},
        {102835296, 115179351},
        {102686599, 115817245},
        {102612396, 116540557},
        {102614700, 117684249},
    },
    {
        {98163757, 71203430},
        {98212463, 73314544},
        {98326538, 74432693},
        {98402908, 75169799},
        {98524154, 76328353},
        {99088806, 79911361},
        {99304885, 80947769},
        {100106689, 84244186},
        {100358123, 85080337},
        {101715545, 89252807},
        {101969528, 89987213},
        {107989440, 106391418},
        {126299575, 140277343},
        {127061813, 141486663},
        {127405746, 141872253},
        {127846908, 142318450},
        {130818496, 145301574},
        {134366424, 148100921},
        {135308380, 148798828},
        {135745666, 149117523},
        {136033020, 149251800},
        {136500579, 149387725},
        {136662719, 149418395},
        {136973922, 149474822},
        {137184890, 149484375},
        {137623748, 149434356},
        {137830810, 149355072},
        {138681732, 148971343},
        {139374465, 148463409},
        {139589187, 148264312},
        {139809707, 148010711},
        {139985610, 147685028},
        {140196029, 147284973},
        {140355834, 146978668},
        {142079666, 142575622},
        {146702194, 129469726},
        {151285888, 113275238},
        {151543731, 112046264},
        {151701629, 110884704},
        {151837020, 108986206},
        {151837097, 107724029},
        {151760101, 106529205},
        {151581970, 105441925},
        {151577301, 105413757},
        {151495269, 105014709},
        {151393142, 104551513},
        {151058502, 103296112},
        {150705520, 102477264},
        {150137725, 101686370},
        {149427032, 100938537},
        {102979965, 60772064},
        {101930953, 60515609},
        {101276748, 60634414},
        {100717803, 60918136},
        {100125732, 61584625},
        {99618148, 62413436},
        {99457214, 62709442},
        {99368347, 62914794},
        {99166992, 63728332},
        {98313827, 69634780},
        {98176910, 70615707},
        {98162902, 70798233},
        {98163757, 71203430},
    },
    {
        {79090698, 116426399},
        {80959800, 137087692},
        {81030303, 137762298},
        {81190704, 138903503},
        {81253700, 139084197},
        {81479301, 139544998},
        {81952003, 140118896},
        {82319900, 140523895},
        {82967803, 140993896},
        {83022903, 141032104},
        {83777900, 141493606},
        {84722099, 141849899},
        {84944396, 141887207},
        {86144699, 141915893},
        {87643997, 141938095},
        {88277503, 141887695},
        {88582099, 141840606},
        {89395401, 141712203},
        {90531204, 141528396},
        {91014801, 141438400},
        {92097595, 141190093},
        {123348297, 132876998},
        {123399505, 132860000},
        {123452804, 132841506},
        {123515502, 132818908},
        {123543800, 132806198},
        {124299598, 132437393},
        {124975502, 132042098},
        {125047500, 131992202},
        {125119506, 131930603},
        {166848800, 86317703},
        {168976409, 83524902},
        {169359603, 82932701},
        {169852600, 81917800},
        {170686904, 79771202},
        {170829406, 79245597},
        {170885498, 78796295},
        {170909301, 78531898},
        {170899703, 78238700},
        {170842803, 77553199},
        {170701293, 76723495},
        {170302307, 75753898},
        {169924301, 75067398},
        {169359802, 74578796},
        {168148605, 73757499},
        {163261596, 71124702},
        {162986007, 70977798},
        {162248703, 70599098},
        {158193405, 68923995},
        {157514297, 68667495},
        {156892700, 68495201},
        {156607299, 68432998},
        {154301895, 68061904},
        {93440299, 68061904},
        {88732002, 68255996},
        {88627304, 68298500},
        {88111396, 68541900},
        {86393898, 69555404},
        {86138298, 69706695},
        {85871704, 69913200},
        {85387199, 70393402},
        {79854499, 76783203},
        {79209701, 77649398},
        {79108505, 78072502},
        {79090698, 78472198},
        {79090698, 116426399},
    },
    {
        {90956314, 84639938},
        {91073814, 85141891},
        {91185752, 85505371},
        {109815368, 137196487},
        {110342590, 138349899},
        {110388549, 138447540},
        {110652862, 138971343},
        {110918045, 139341140},
        {114380859, 143159042},
        {114446723, 143220352},
        {114652198, 143392166},
        {114712196, 143437301},
        {114782165, 143476028},
        {114873054, 143514923},
        {115217086, 143660934},
        {115306060, 143695526},
        {115344009, 143707580},
        {115444541, 143737747},
        {115589378, 143779937},
        {115751358, 143823989},
        {115802780, 143825820},
        {116872810, 143753616},
        {116927055, 143744644},
        {154690734, 133504180},
        {155009704, 133371856},
        {155029907, 133360061},
        {155089141, 133323181},
        {155342315, 133163360},
        {155602294, 132941406},
        {155669158, 132880294},
        {155821624, 132737884},
        {155898986, 132656890},
        {155934936, 132608932},
        {155968627, 132562713},
        {156062896, 132431808},
        {156111694, 132363174},
        {156148147, 132297180},
        {158738342, 127281066},
        {159026672, 126378631},
        {159073699, 125806335},
        {159048522, 125299743},
        {159040313, 125192901},
        {158898300, 123934677},
        {149829376, 70241508},
        {149763031, 69910629},
        {149684692, 69628723},
        {149557800, 69206214},
        {149366485, 68864326},
        {149137390, 68578514},
        {148637466, 68048767},
        {147027725, 66632934},
        {146228607, 66257507},
        {146061309, 66184646},
        {146017929, 66174186},
        {145236465, 66269500},
        {144802490, 66345039},
        {144673995, 66376220},
        {93732284, 79649864},
        {93345336, 79785865},
        {93208084, 79840286},
        {92814521, 79997779},
        {92591087, 80098968},
        {92567016, 80110511},
        {92032684, 80860725},
        {91988853, 80930152},
        {91471725, 82210029},
        {91142349, 83076683},
        {90969284, 83653182},
        {90929664, 84043212},
        {90926315, 84325256},
        {90956314, 84639938},
    },
    {
        {114758499, 88719909},
        {114771591, 88860549},
        {115515533, 94195907},
        {115559539, 94383651},
        {119882980, 109502059},
        {120660522, 111909683},
        {126147735, 124949630},
        {127127212, 127107215},
        {129976379, 132117279},
        {130754470, 133257080},
        {130820968, 133340835},
        {130889312, 133423858},
        {131094787, 133652832},
        {131257629, 133828247},
        {131678619, 134164276},
        {131791107, 134248901},
        {131969482, 134335189},
        {132054107, 134373718},
        {132927368, 134701141},
        {133077072, 134749313},
        {133196075, 134785705},
        {133345230, 134804351},
        {133498809, 134809051},
        {133611541, 134797607},
        {134621170, 134565322},
        {134741165, 134527511},
        {134892089, 134465240},
        {135071212, 134353820},
        {135252029, 134185821},
        {135384979, 134003631},
        {135615585, 133576675},
        {135793029, 132859008},
        {135890228, 131382904},
        {135880828, 131261657},
        {135837570, 130787963},
        {135380661, 127428909},
        {132830596, 109495368},
        {132815826, 109411666},
        {132765869, 109199302},
        {132724380, 109068161},
        {127490066, 93353515},
        {125330810, 87852828},
        {125248336, 87647026},
        {125002182, 87088424},
        {124894592, 86872482},
        {121007278, 80019584},
        {120962829, 79941261},
        {120886489, 79833923},
        {120154983, 78949615},
        {119366561, 78111709},
        {119014755, 77776794},
        {116728790, 75636238},
        {116660522, 75593933},
        {116428192, 75458541},
        {116355255, 75416870},
        {116264663, 75372528},
        {115952728, 75233367},
        {115865554, 75205482},
        {115756835, 75190956},
        {115564163, 75197830},
        {115481170, 75202087},
        {115417144, 75230400},
        {115226959, 75337806},
        {115203842, 75351448},
        {114722015, 75746932},
        {114672103, 75795661},
        {114594619, 75891891},
        {114565811, 75973831},
        {114478256, 76240814},
        {114178039, 77252197},
        {114137664, 77769668},
        {114109771, 78154464},
        {114758499, 88719909},
    },
    {
        {108135070, 109828002},
        {108200347, 110091529},
        {108319419, 110298500},
        {108439025, 110488388},
        {108663574, 110766731},
        {108812957, 110935768},
        {109321914, 111398925},
        {109368087, 111430320},
        {109421295, 111466331},
        {110058998, 111849746},
        {127160308, 120588981},
        {127350692, 120683456},
        {128052749, 120997207},
        {128326919, 121113449},
        {131669586, 122213058},
        {131754745, 122240592},
        {131854583, 122264770},
        {132662048, 122449813},
        {132782669, 122449897},
        {132909118, 122443687},
        {133013442, 122436058},
        {140561035, 121609939},
        {140786346, 121583320},
        {140876144, 121570228},
        {140962356, 121547996},
        {141052612, 121517837},
        {141231292, 121442184},
        {141309371, 121390007},
        {141370132, 121327003},
        {141456008, 121219932},
        {141591598, 121045005},
        {141905761, 120634796},
        {141894607, 120305725},
        {141881881, 120110855},
        {141840881, 119885009},
        {141685043, 119238922},
        {141617416, 118962882},
        {141570434, 118858856},
        {131617462, 100598548},
        {131542846, 100487213},
        {131229385, 100089019},
        {131091476, 99928108},
        {119824127, 90297180},
        {119636337, 90142387},
        {119507492, 90037765},
        {119436744, 89983657},
        {119423942, 89974159},
        {119207366, 89822471},
        {119117149, 89767097},
        {119039489, 89726867},
        {116322929, 88522857},
        {114817031, 87882110},
        {114683975, 87826751},
        {114306411, 87728507},
        {113876434, 87646003},
        {113792106, 87629974},
        {113658988, 87615974},
        {113574333, 87609275},
        {112813575, 87550102},
        {112578567, 87560157},
        {112439880, 87571647},
        {112306922, 87599395},
        {112225082, 87622535},
        {112132568, 87667175},
        {112103477, 87682830},
        {110795242, 88511634},
        {110373565, 88847793},
        {110286537, 88934989},
        {109730873, 89531501},
        {109648735, 89628883},
        {109552581, 89768859},
        {109514228, 89838470},
        {109501640, 89877586},
        {109480964, 89941864},
        {109461761, 90032417},
        {109457778, 90055458},
        {108105194, 109452575},
        {108094238, 109620979},
        {108135070, 109828002},
    },
    {
        {108764694, 108910400},
        {108965499, 112306495},
        {109598602, 120388298},
        {110573898, 128289596},
        {110597801, 128427795},
        {113786201, 137983795},
        {113840301, 138134704},
        {113937202, 138326904},
        {114046005, 138520401},
        {114150802, 138696792},
        {114164703, 138717895},
        {114381896, 139021194},
        {114701004, 139425292},
        {114997398, 139747497},
        {115065597, 139805191},
        {115134498, 139850891},
        {115167098, 139871704},
        {115473396, 139992797},
        {115537498, 139995101},
        {116762596, 139832000},
        {116897499, 139808593},
        {118401802, 139225585},
        {118437500, 139209594},
        {118488204, 139182189},
        {118740097, 139033996},
        {118815795, 138967285},
        {134401000, 116395492},
        {134451507, 116309997},
        {135488098, 113593597},
        {137738006, 106775695},
        {140936492, 97033889},
        {140960006, 96948997},
        {141026504, 96660995},
        {141067291, 96467094},
        {141124893, 95771896},
        {141511795, 90171600},
        {141499801, 90026000},
        {141479598, 89907798},
        {141276794, 88844596},
        {141243804, 88707397},
        {140778305, 87031593},
        {140733306, 86871696},
        {140697204, 86789993},
        {140619796, 86708190},
        {140398391, 86487396},
        {125798797, 72806198},
        {125415802, 72454498},
        {123150398, 70566093},
        {123038803, 70503997},
        {122681198, 70305397},
        {121919204, 70104797},
        {121533699, 70008094},
        {121273696, 70004898},
        {121130599, 70020797},
        {121045097, 70033294},
        {120847099, 70082298},
        {120481895, 70278999},
        {120367004, 70379692},
        {120272796, 70475097},
        {119862098, 71004791},
        {119745101, 71167297},
        {119447799, 71726997},
        {119396499, 71825798},
        {119348701, 71944496},
        {109508796, 98298797},
        {109368598, 98700897},
        {109298400, 98926391},
        {108506301, 102750991},
        {108488197, 102879898},
        {108764694, 108910400},
    },
    {
        {106666252, 87231246},
        {106673248, 87358055},
        {107734146, 101975646},
        {107762649, 102357955},
        {108702445, 111208351},
        {108749450, 111345153},
        {108848350, 111542648},
        {110270645, 114264358},
        {110389648, 114445144},
        {138794845, 143461151},
        {139048355, 143648956},
        {139376144, 143885345},
        {139594451, 144022644},
        {139754043, 144110046},
        {139923950, 144185852},
        {140058242, 144234451},
        {140185653, 144259552},
        {140427551, 144292648},
        {141130950, 144281448},
        {141157653, 144278152},
        {141214355, 144266555},
        {141347457, 144223449},
        {141625350, 144098953},
        {141755142, 144040145},
        {141878143, 143971557},
        {142011444, 143858154},
        {142076843, 143796356},
        {142160644, 143691055},
        {142224456, 143560852},
        {142925842, 142090850},
        {142935653, 142065353},
        {142995956, 141899154},
        {143042556, 141719757},
        {143102951, 141436157},
        {143129257, 141230453},
        {143316055, 139447250},
        {143342544, 133704650},
        {143307556, 130890960},
        {142461257, 124025558},
        {141916046, 120671051},
        {141890457, 120526153},
        {140002349, 113455749},
        {139909149, 113144149},
        {139853454, 112974456},
        {137303756, 105228057},
        {134700546, 98161254},
        {134617950, 97961547},
        {133823547, 96118057},
        {133688751, 95837356},
        {133481353, 95448059},
        {133205444, 94948150},
        {131178955, 91529853},
        {131144744, 91482055},
        {113942047, 67481246},
        {113837051, 67360549},
        {113048950, 66601745},
        {112305549, 66002746},
        {112030853, 65790351},
        {111970649, 65767547},
        {111912445, 65755249},
        {111854248, 65743453},
        {111657447, 65716354},
        {111576950, 65707351},
        {111509750, 65708549},
        {111443550, 65718551},
        {111397247, 65737449},
        {111338546, 65764648},
        {111129547, 65863349},
        {111112449, 65871551},
        {110995254, 65927856},
        {110968849, 65946151},
        {110941444, 65966751},
        {110836448, 66057853},
        {110490447, 66445449},
        {110404144, 66576751},
        {106802055, 73202148},
        {106741950, 73384948},
        {106715454, 73469650},
        {106678054, 73627151},
        {106657455, 75433448},
        {106666252, 87231246},
    },
    {
        {101852752, 106261352},
        {101868949, 106406051},
        {102347549, 108974250},
        {112286750, 152027954},
        {112305648, 152106536},
        {112325752, 152175857},
        {112391448, 152290863},
        {113558250, 154187454},
        {113592048, 154226745},
        {113694351, 154313156},
        {113736549, 154335647},
        {113818145, 154367462},
        {114284454, 154490951},
        {114415847, 154504547},
        {114520751, 154489151},
        {114571350, 154478057},
        {114594551, 154472854},
        {114630546, 154463958},
        {114715148, 154429443},
        {146873657, 136143051},
        {146941741, 136074249},
        {147190155, 135763549},
        {147262649, 135654937},
        {147309951, 135557159},
        {147702255, 133903945},
        {147934143, 131616348},
        {147967041, 131273864},
        {148185852, 127892250},
        {148195648, 127669754},
        {148179656, 126409851},
        {148119552, 126182151},
        {147874053, 125334152},
        {147818954, 125150352},
        {146958557, 122656646},
        {139070251, 101025955},
        {139002655, 100879051},
        {119028450, 63067649},
        {118846649, 62740753},
        {115676048, 57814651},
        {115550453, 57629852},
        {115330352, 57319751},
        {115094749, 56998352},
        {114978347, 56847454},
        {114853050, 56740550},
        {114695053, 56609550},
        {114582252, 56528148},
        {114210449, 56375953},
        {113636245, 56214950},
        {113470352, 56171649},
        {109580749, 55503551},
        {109491645, 55495452},
        {109238754, 55511550},
        {109080352, 55534049},
        {108027748, 55687351},
        {107839950, 55732349},
        {107614456, 55834953},
        {107488143, 55925952},
        {107302551, 56062553},
        {107218353, 56145751},
        {107199447, 56167251},
        {107052749, 56354850},
        {106978652, 56476348},
        {106869644, 56710754},
        {104541351, 62448753},
        {104454551, 62672554},
        {104441253, 62707351},
        {104231750, 63366348},
        {104222648, 63419952},
        {104155746, 63922649},
        {104127349, 64147552},
        {104110847, 64299957},
        {102235450, 92366752},
        {101804351, 102877655},
        {101852752, 106261352},
    },
    {
        {106808700, 120885696},
        {106818695, 120923103},
        {106873901, 121057098},
        {115123603, 133614700},
        {115128799, 133619598},
        {115182197, 133661804},
        {115330101, 133740707},
        {115455398, 133799407},
        {115595001, 133836807},
        {115651000, 133851806},
        {116413604, 134055206},
        {116654495, 134097900},
        {116887603, 134075210},
        {117071098, 134040405},
        {117458801, 133904891},
        {118057998, 133572601},
        {118546997, 133261001},
        {118578498, 133239395},
        {118818603, 133011596},
        {121109695, 130501495},
        {122661598, 128760101},
        {142458190, 102765197},
        {142789001, 102099601},
        {143105010, 101386505},
        {143154800, 101239700},
        {143193908, 100825500},
        {143160507, 100282501},
        {143133499, 100083602},
        {143092697, 99880500},
        {143050689, 99766700},
        {142657501, 98974502},
        {142580307, 98855201},
        {122267196, 76269897},
        {122036399, 76105003},
        {121832000, 76028305},
        {121688796, 75983108},
        {121591598, 75955001},
        {121119697, 75902099},
        {120789596, 75953498},
        {120487495, 76041900},
        {120042701, 76365798},
        {119886695, 76507301},
        {119774200, 76635299},
        {119739097, 76686904},
        {119685195, 76798202},
        {119456199, 77320098},
        {106877601, 119561401},
        {106854797, 119645103},
        {106849098, 119668807},
        {106847099, 119699005},
        {106840400, 119801406},
        {106807800, 120719299},
        {106806098, 120862808},
        {106808700, 120885696},
    },
    {
        {99663352, 105328948},
        {99690048, 105797050},
        {99714050, 105921447},
        {99867248, 106439949},
        {100111557, 107256546},
        {104924850, 120873649},
        {105106155, 121284049},
        {105519149, 122184753},
        {105586051, 122292655},
        {105665054, 122400154},
        {106064147, 122838455},
        {106755355, 123453453},
        {106929054, 123577651},
        {107230346, 123771949},
        {107760650, 123930648},
        {108875854, 124205154},
        {108978752, 124228050},
        {131962051, 123738754},
        {135636047, 123513954},
        {135837249, 123500747},
        {136357345, 123442749},
        {136577346, 123394454},
        {136686645, 123367752},
        {137399353, 123185050},
        {137733947, 123063156},
        {137895355, 122997154},
        {138275650, 122829154},
        {138394256, 122767753},
        {138516845, 122670150},
        {139987045, 121111251},
        {149171646, 108517349},
        {149274353, 108372848},
        {149314758, 108314247},
        {149428848, 108140846},
        {149648651, 107650550},
        {149779541, 107290252},
        {149833343, 107115249},
        {149891357, 106920051},
        {150246353, 105630249},
        {150285842, 105423454},
        {150320953, 105233749},
        {150336639, 104981552},
        {150298049, 104374053},
        {150287948, 104271850},
        {150026153, 103481147},
        {149945449, 103301651},
        {149888946, 103213455},
        {149800949, 103103851},
        {149781143, 103079650},
        {149714141, 103005447},
        {149589950, 102914146},
        {149206054, 102698951},
        {128843856, 91378150},
        {128641754, 91283050},
        {119699851, 87248046},
        {117503555, 86311950},
        {117145851, 86178054},
        {116323654, 85925048},
        {115982551, 85834045},
        {115853050, 85819252},
        {115222549, 85771949},
        {107169357, 85771949},
        {107122650, 85776451},
        {106637145, 85831550},
        {105095046, 86423950},
        {104507850, 86703750},
        {104384155, 86763153},
        {104332351, 86790145},
        {104198257, 86882644},
        {103913757, 87109451},
        {103592346, 87388450},
        {103272651, 87666748},
        {103198051, 87779052},
        {101698654, 90600952},
        {101523551, 90958450},
        {101360054, 91347450},
        {101295349, 91542144},
        {99774551, 98278152},
        {99746749, 98417755},
        {99704055, 98675453},
        {99663352, 99022949},
        {99663352, 105328948},
    },
    {
        {95036499, 101778106},
        {95479103, 102521301},
        {95587295, 102700103},
        {98306503, 106984901},
        {98573303, 107377700},
        {100622406, 110221702},
        {101252304, 111089599},
        {104669502, 115750198},
        {121838500, 131804107},
        {122000503, 131943695},
        {122176803, 132023406},
        {122474105, 132025390},
        {122703804, 132023101},
        {123278808, 131878112},
        {124072998, 131509109},
        {124466506, 131102508},
        {152779296, 101350906},
        {153016510, 101090606},
        {153269699, 100809097},
        {153731994, 100214096},
        {153927902, 99939796},
        {154641098, 98858100},
        {154864303, 98517601},
        {155056594, 97816604},
        {155083511, 97645599},
        {155084899, 97462097},
        {154682601, 94386100},
        {154376007, 92992599},
        {154198593, 92432403},
        {153830505, 91861701},
        {153686904, 91678695},
        {151907104, 90314605},
        {151368896, 89957603},
        {146983306, 87632202},
        {139082397, 84273605},
        {128947692, 80411399},
        {121179000, 78631301},
        {120264701, 78458198},
        {119279510, 78304603},
        {116913101, 77994102},
        {116151504, 77974601},
        {115435104, 78171401},
        {113544105, 78709106},
        {113231002, 78879898},
        {112726303, 79163604},
        {112310501, 79411102},
        {96169998, 97040802},
        {95196304, 98364402},
        {95167800, 98409599},
        {95083503, 98570701},
        {94986999, 99022201},
        {94915100, 100413299},
        {95036499, 101778106},
    },
    {
        {82601348, 96004745},
        {83443847, 128861953},
        {84173248, 136147354},
        {104268249, 141388839},
        {104373649, 141395355},
        {105686950, 141389541},
        {149002243, 140435653},
        {159095748, 133388244},
        {159488143, 133112655},
        {159661849, 132894653},
        {163034149, 128290847},
        {164801849, 124684249},
        {167405746, 72553245},
        {167330444, 71960746},
        {167255050, 71791847},
        {167147155, 71572044},
        {166999557, 71341545},
        {166723937, 70961448},
        {166238250, 70611541},
        {165782348, 70359649},
        {165649444, 70286849},
        {165332946, 70122344},
        {165164154, 70062248},
        {164879150, 69967544},
        {164744949, 69928947},
        {164691452, 69915245},
        {164669448, 69910247},
        {159249938, 68738952},
        {158528259, 68704742},
        {147564254, 68604644},
        {116196655, 68982742},
        {115364944, 69005050},
        {115193145, 69013549},
        {101701248, 70984146},
        {93918449, 72233047},
        {93789749, 72285247},
        {93777046, 72292648},
        {93586044, 72444046},
        {93366348, 72662345},
        {93301147, 72745452},
        {93260345, 72816345},
        {83523948, 92593849},
        {83430145, 92810241},
        {82815048, 94665542},
        {82755554, 94858551},
        {82722953, 95014350},
        {82594253, 95682350},
        {82601348, 96004745},
    },
    {
        {110371345, 125796493},
        {110411544, 126159599},
        {110445251, 126362899},
        {111201950, 127863800},
        {112030052, 129270492},
        {112367050, 129799301},
        {113088348, 130525604},
        {113418144, 130853698},
        {117363449, 134705505},
        {118131149, 135444793},
        {118307449, 135607299},
        {119102546, 136297195},
        {119385047, 136531906},
        {120080848, 137094390},
        {120794845, 137645401},
        {121150344, 137896392},
        {121528945, 138162506},
        {121644546, 138242095},
        {122142349, 138506408},
        {127540847, 141363006},
        {127933448, 141516204},
        {128728256, 141766799},
        {129877151, 141989898},
        {130626052, 142113891},
        {130912246, 142135192},
        {131246841, 142109100},
        {131496047, 142027404},
        {131596252, 141957794},
        {131696350, 141873504},
        {131741043, 141803405},
        {138788452, 128037704},
        {139628646, 125946197},
        {138319351, 112395401},
        {130035354, 78066703},
        {124174049, 69908798},
        {123970649, 69676895},
        {123874252, 69571899},
        {123246643, 68961303},
        {123193954, 68924400},
        {121952049, 68110000},
        {121787345, 68021896},
        {121661544, 67970306},
        {121313446, 67877502},
        {121010650, 67864799},
        {120995346, 67869705},
        {120583747, 68122207},
        {120509750, 68170600},
        {120485847, 68189102},
        {112160148, 77252403},
        {111128646, 78690704},
        {110969650, 78939407},
        {110512550, 79663406},
        {110397247, 79958206},
        {110371345, 80038299},
        {110371345, 125796493},
    },
    {
        {112163948, 137752700},
        {112171150, 137837997},
        {112203048, 137955993},
        {112240150, 138008209},
        {112343246, 138111099},
        {112556243, 138223205},
        {112937149, 138307998},
        {113318748, 138331909},
        {126076446, 138428298},
        {126165245, 138428695},
        {126312446, 138417907},
        {134075546, 136054504},
        {134322753, 135949401},
        {134649948, 135791198},
        {135234954, 135493408},
        {135290145, 135464691},
        {135326248, 135443695},
        {135920043, 135032592},
        {135993850, 134975799},
        {136244247, 134761199},
        {136649444, 134378692},
        {137067153, 133964294},
        {137188156, 133839096},
        {137298049, 133704498},
        {137318954, 133677795},
        {137413543, 133522201},
        {137687347, 133043792},
        {137816055, 132660705},
        {137836044, 131747695},
        {137807144, 131318603},
        {136279342, 119078704},
        {136249053, 118945800},
        {127306152, 81348602},
        {127114852, 81065505},
        {127034248, 80951400},
        {126971649, 80893707},
        {125093551, 79178001},
        {124935745, 79036003},
        {115573745, 71767601},
        {115411148, 71701805},
        {115191947, 71621002},
        {115017051, 71571304},
        {114870147, 71572898},
        {113869552, 71653900},
        {112863349, 72976104},
        {112756347, 73223899},
        {112498947, 73832206},
        {112429351, 73998504},
        {112366050, 74168098},
        {112273246, 74487098},
        {112239250, 74605400},
        {112195549, 74899902},
        {112163948, 75280700},
        {112163948, 137752700},
    },
    {
        {78562347, 141451843},
        {79335624, 142828186},
        {79610343, 143188140},
        {79845077, 143445724},
        {81379173, 145126678},
        {81826751, 145577178},
        {82519126, 146209472},
        {83964973, 147280502},
        {85471343, 148377868},
        {86115539, 148760803},
        {88839988, 150281188},
        {89021247, 150382217},
        {90775917, 151320526},
        {91711380, 151767288},
        {92757591, 152134277},
        {93241058, 152201766},
        {113402145, 153091995},
        {122065994, 146802825},
        {164111053, 91685104},
        {164812759, 90470565},
        {165640182, 89037384},
        {171027435, 66211853},
        {171450805, 64406951},
        {171463150, 64349624},
        {171469787, 64317184},
        {171475585, 64282028},
        {171479812, 64253036},
        {171483596, 64210433},
        {171484405, 64153488},
        {171483001, 64140785},
        {171481719, 64132751},
        {171478668, 64115478},
        {171472702, 64092437},
        {171462768, 64075408},
        {171448089, 64061347},
        {171060333, 63854789},
        {169640502, 63197738},
        {169342147, 63086711},
        {166413101, 62215766},
        {151881774, 58826736},
        {146010574, 57613151},
        {141776962, 56908004},
        {140982940, 57030628},
        {139246154, 57540817},
        {139209609, 57566974},
        {127545310, 66015594},
        {127476654, 66104812},
        {105799087, 98784980},
        {85531921, 129338897},
        {79319717, 138704513},
        {78548156, 140188079},
        {78530448, 140530456},
        {78515594, 141299987},
        {78562347, 141451843},
    },
    {
        {77755004, 128712387},
        {78073547, 130552612},
        {78433593, 132017822},
        {79752693, 136839645},
        {80479461, 138929260},
        {80903221, 140119674},
        {81789848, 141978454},
        {82447387, 143105575},
        {83288436, 144264328},
        {84593582, 145846542},
        {84971939, 146242813},
        {86905578, 147321304},
        {87874191, 147594131},
        {89249092, 147245132},
        {89541542, 147169052},
        {98759140, 144071609},
        {98894233, 144024261},
        {113607818, 137992843},
        {128324356, 131649307},
        {139610076, 126210189},
        {146999572, 122112884},
        {147119415, 122036041},
        {148717330, 120934616},
        {149114776, 120652725},
        {171640289, 92086624},
        {171677917, 92036224},
        {171721191, 91973869},
        {171851608, 91721557},
        {171927795, 91507644},
        {172398696, 89846351},
        {172436752, 89559959},
        {169361663, 64753852},
        {169349029, 64687164},
        {169115127, 63616458},
        {168965728, 63218254},
        {168911788, 63121219},
        {168901611, 63106807},
        {168896896, 63100486},
        {168890686, 63092460},
        {168876586, 63081058},
        {168855529, 63067909},
        {168808746, 63046024},
        {167251068, 62405864},
        {164291717, 63716899},
        {152661651, 69910156},
        {142312393, 75421356},
        {78778053, 111143295},
        {77887222, 113905914},
        {77591979, 124378433},
        {77563247, 126586669},
        {77755004, 128712387},
    },
    {
        {105954101, 131182754},
        {105959197, 131275848},
        {105972801, 131473556},
        {105981498, 131571044},
        {106077903, 132298553},
        {106134094, 132715255},
        {106155700, 132832351},
        {106180099, 132942657},
        {106326797, 133590347},
        {106375099, 133719345},
        {106417602, 133829345},
        {106471000, 133930343},
        {106707901, 134308654},
        {106728401, 134340545},
        {106778198, 134417556},
        {106832397, 134491851},
        {106891296, 134562957},
        {106981300, 134667358},
        {107044204, 134736557},
        {107111000, 134802658},
        {107180999, 134865661},
        {107291099, 134961349},
        {107362998, 135020355},
        {107485397, 135112854},
        {107558998, 135166946},
        {107690399, 135256256},
        {107765098, 135305252},
        {107903594, 135390548},
        {108183898, 135561843},
        {108459503, 135727951},
        {108532501, 135771850},
        {108796096, 135920059},
        {108944099, 135972549},
        {109102401, 136010757},
        {109660598, 136071044},
        {109971595, 136100250},
        {110209594, 136116851},
        {110752799, 136122344},
        {111059906, 136105758},
        {111152900, 136100357},
        {111237197, 136091354},
        {111316101, 136075057},
        {111402000, 136050949},
        {111475296, 136026657},
        {143546600, 123535949},
        {143899002, 122454353},
        {143917404, 122394348},
        {143929199, 122354652},
        {143944793, 122295753},
        {143956207, 122250953},
        {143969497, 122192253},
        {143980102, 122143249},
        {143991302, 122083053},
        {144000396, 122031753},
        {144009796, 121970954},
        {144017303, 121917655},
        {144025405, 121850250},
        {144030609, 121801452},
        {144036804, 121727455},
        {144040008, 121683456},
        {144043502, 121600952},
        {144044708, 121565048},
        {144045700, 121470352},
        {144045898, 121446952},
        {144041503, 121108657},
        {144037506, 121023452},
        {143733795, 118731750},
        {140461395, 95238647},
        {140461105, 95236755},
        {140433807, 95115249},
        {140392608, 95011650},
        {134840805, 84668952},
        {134824996, 84642456},
        {134781494, 84572952},
        {134716796, 84480850},
        {127473899, 74425453},
        {127467002, 74417152},
        {127431701, 74381652},
        {127402603, 74357147},
        {127375503, 74334457},
        {127294906, 74276649},
        {127181900, 74207649},
        {127177597, 74205451},
        {127123901, 74178451},
        {127078903, 74155853},
        {127028999, 74133148},
        {126870803, 74070953},
        {126442901, 73917648},
        {126432403, 73914955},
        {126326004, 73889846},
        {126262405, 73880645},
        {126128097, 73878456},
        {125998199, 73877655},
        {108701095, 74516647},
        {108644599, 74519348},
        {108495201, 74528953},
        {108311302, 74556457},
        {108252799, 74569458},
        {108079002, 74612152},
        {107981399, 74638954},
        {107921295, 74657951},
        {107862197, 74685951},
        {107601303, 74828948},
        {107546997, 74863449},
        {107192794, 75098846},
        {107131202, 75151153},
        {106260002, 76066146},
        {106195098, 76221145},
        {106168502, 76328453},
        {106144699, 76437454},
        {106124496, 76538452},
        {106103698, 76649650},
        {106084197, 76761650},
        {106066299, 76874450},
        {106049903, 76987457},
        {106034797, 77101150},
        {106020904, 77214950},
        {106008201, 77328948},
        {105996902, 77443145},
        {105986099, 77565849},
        {105977005, 77679649},
        {105969299, 77793151},
        {105963096, 77906349},
        {105958297, 78019149},
        {105955299, 78131454},
        {105954101, 78242950},
        {105954101, 131182754},
    },
    {
        {91355499, 77889205},
        {114834197, 120804504},
        {114840301, 120815200},
        {124701507, 132324798},
        {124798805, 132436706},
        {124901504, 132548309},
        {125126602, 132788909},
        {125235000, 132901901},
        {125337707, 133005401},
        {125546302, 133184707},
        {125751602, 133358703},
        {126133300, 133673004},
        {126263900, 133775604},
        {126367401, 133855499},
        {126471908, 133935104},
        {126596008, 134027496},
        {127119308, 134397094},
        {127135101, 134408203},
        {127433609, 134614303},
        {127554107, 134695709},
        {128155395, 135070907},
        {128274505, 135141799},
        {129132003, 135573211},
        {129438003, 135713195},
        {129556106, 135767196},
        {131512695, 136648498},
        {132294509, 136966598},
        {132798400, 137158798},
        {133203796, 137294494},
        {133377410, 137350799},
        {133522399, 137396606},
        {133804397, 137480697},
        {134017807, 137542205},
        {134288696, 137618408},
        {134564208, 137680099},
        {134844696, 137740097},
        {135202606, 137807098},
        {135489105, 137849807},
        {135626800, 137864898},
        {135766906, 137878692},
        {135972808, 137895797},
        {136110107, 137905502},
        {136235000, 137913101},
        {136485809, 137907196},
        {139194305, 136979202},
        {140318298, 136536209},
        {140380004, 136505004},
        {140668197, 136340499},
        {140724304, 136298904},
        {140808197, 136228210},
        {140861801, 136180603},
        {140917404, 136129104},
        {140979202, 136045104},
        {141022903, 135984207},
        {147591094, 126486999},
        {147661315, 126356101},
        {147706100, 126261901},
        {147749099, 126166000},
        {147817108, 126007507},
        {147859100, 125908599},
        {153693206, 111901100},
        {153731109, 111807800},
        {153760894, 111698806},
        {158641998, 92419303},
        {158644500, 92263702},
        {158539703, 92013504},
        {158499603, 91918899},
        {158335510, 91626800},
        {158264007, 91516304},
        {158216308, 91449203},
        {158178314, 91397506},
        {158094299, 91283203},
        {157396408, 90368202},
        {157285491, 90224700},
        {157169906, 90079200},
        {157050003, 89931304},
        {156290603, 89006805},
        {156221099, 88922897},
        {156087707, 88771003},
        {155947906, 88620498},
        {155348602, 88004203},
        {155113204, 87772796},
        {154947296, 87609703},
        {154776306, 87448204},
        {154588806, 87284301},
        {153886306, 86716400},
        {153682403, 86560501},
        {152966705, 86032402},
        {152687805, 85828704},
        {152484313, 85683204},
        {152278808, 85539001},
        {150878204, 84561401},
        {150683013, 84426498},
        {150599395, 84372703},
        {150395599, 84243202},
        {149988906, 83989395},
        {149782897, 83864501},
        {149568908, 83739799},
        {148872100, 83365303},
        {148625396, 83242202},
        {128079010, 73079605},
        {127980506, 73031005},
        {126701103, 72407104},
        {126501701, 72312202},
        {126431503, 72280601},
        {126311706, 72230606},
        {126260101, 72210899},
        {126191902, 72187599},
        {126140106, 72170303},
        {126088203, 72155303},
        {126036102, 72142700},
        {125965904, 72126899},
        {125913009, 72116600},
        {125859603, 72108505},
        {125788101, 72100296},
        {125733505, 72094398},
        {125678100, 72090400},
        {125621398, 72088302},
        {125548805, 72087303},
        {125490707, 72086898},
        {125430908, 72088203},
        {125369804, 72091094},
        {125306900, 72095306},
        {125233505, 72100997},
        {125168609, 72106506},
        {125102203, 72113601},
        {125034103, 72122207},
        {124964309, 72132095},
        {124890701, 72143707},
        {124819305, 72155105},
        {91355499, 77889099},
        {91355499, 77889205},
    },
    {
        {84531845, 127391708},
        {84916946, 130417510},
        {86133247, 131166900},
        {86338447, 131292892},
        {86748847, 131544799},
        {102193946, 136599502},
        {103090942, 136796798},
        {103247146, 136822509},
        {104083549, 136911499},
        {106119346, 137109802},
        {106265853, 137122207},
        {106480247, 137139205},
        {110257850, 137133605},
        {116917747, 136131408},
        {117054946, 136106704},
        {119043945, 135244293},
        {119249046, 135154708},
        {136220947, 126833007},
        {165896347, 91517105},
        {166032546, 91314697},
        {166055435, 91204902},
        {166056152, 91176803},
        {166047256, 91100006},
        {166039733, 91063705},
        {165814849, 90080802},
        {165736450, 89837707},
        {165677246, 89732101},
        {165676956, 89731803},
        {165560241, 89629302},
        {154419952, 82608505},
        {153822143, 82239700},
        {137942749, 74046104},
        {137095245, 73845504},
        {135751342, 73537704},
        {134225952, 73208602},
        {132484344, 72860801},
        {124730346, 73902000},
        {120736549, 74464401},
        {100401245, 78685401},
        {90574645, 90625701},
        {90475944, 90748809},
        {90430747, 90808700},
        {90321548, 90958305},
        {90254852, 91077903},
        {90165641, 91244003},
        {90134941, 91302398},
        {84474647, 103745697},
        {84328048, 104137901},
        {84288543, 104327606},
        {84038047, 106164604},
        {84013351, 106368698},
        {83943847, 110643203},
        {84531845, 127391708},
    },
};

const TestDataEx PRINTER_PART_POLYGONS_EX =
{
    {
        {
            {533726562, 142141690},
            {532359712, 143386134},
            {530141290, 142155145},
            {528649729, 160091460},
            {533659500, 157607547},
            {538669739, 160091454},
            {537178168, 142155145},
            {534959534, 143386102},
            {533726562, 142141690},
        },
        {
        },
    },
    {
        {
            {118305840, 11603332},
            {118311095, 26616786},
            {113311095, 26611146},
            {109311095, 29604752},
            {109300760, 44608489},
            {109311095, 49631801},
            {113300790, 52636806},
            {118311095, 52636806},
            {118308782, 103636810},
            {223830940, 103636981},
            {236845321, 90642174},
            {236832882, 11630488},
            {232825251, 11616786},
            {210149075, 11616786},
            {211308596, 13625149},
            {209315325, 17080886},
            {205326885, 17080886},
            {203334352, 13629720},
            {204493136, 11616786},
            {118305840, 11603332},
        },
        {
        },
    },
    {
        {
            {365619370, 111280336},
            {365609100, 198818091},
            {387109100, 198804367},
            {387109100, 203279701},
            {471129120, 203279688},
            {471128689, 111283937},
            {365619370, 111280336},
        },
        {
        },
    },
    {
        {
            {479997525, 19177632},
            {477473010, 21975778},
            {475272613, 21969219},
            {475267479, 32995796},
            {477026388, 32995796},
            {483041428, 22582411},
            {482560272, 20318630},
            {479997525, 19177632},
        },
        {
        },
    },
    {
        {
            {476809080, 4972372},
            {475267479, 4975778},
            {475272613, 16002357},
            {481018177, 18281994},
            {482638044, 15466085},
            {476809080, 4972372},
        },
        {
        },
    },
    {
        {
            {424866064, 10276075},
            {415113411, 10277960},
            {411723180, 13685293},
            {410473354, 18784347},
            {382490868, 18784008},
            {380996185, 17286945},
            {380996185, 11278161},
            {375976165, 11284347},
            {375976165, 56389754},
            {375169018, 57784347},
            {371996185, 57784347},
            {371996185, 53779177},
            {364976165, 53784347},
            {364969637, 56791976},
            {369214608, 61054367},
            {371474507, 61054367},
            {371473155, 98298160},
            {378476349, 105317193},
            {407491306, 105307497},
            {413509785, 99284903},
            {413496185, 48304367},
            {419496173, 48315719},
            {422501887, 45292801},
            {422500504, 39363184},
            {420425079, 37284347},
            {419476165, 43284347},
            {413496185, 43284347},
            {413497261, 30797428},
            {418986175, 25308513},
            {424005230, 25315076},
            {428496185, 20815924},
            {428512720, 13948847},
            {424866064, 10276075},
        },
        {
        },
    },
    {
        {
            {723893066, 37354349},
            {717673034, 37370791},
            {717673034, 44872138},
            {715673034, 44867768},
            {715673034, 46055353},
            {699219526, 40066777},
            {697880758, 37748547},
            {691985477, 37748293},
            {689014018, 42869257},
            {691985477, 48016003},
            {697575093, 48003007},
            {715671494, 54589493},
            {715656800, 87142158},
            {759954611, 87142158},
            {764193054, 82897328},
            {764193054, 79872138},
            {757173034, 79866968},
            {757173034, 83872138},
            {754419422, 83869509},
            {753193054, 81739327},
            {753193054, 37360571},
            {723893066, 37354349},
        },
        {
        },
    },
    {
        {
            {85607478, 4227596},
            {61739211, 4230337},
            {61739211, 13231393},
            {58725066, 13231405},
            {58721589, 27731406},
            {58738375, 30262521},
            {61739211, 30251413},
            {61736212, 38251411},
            {70759231, 38254724},
            {70905600, 33317391},
            {73749222, 31251468},
            {76592843, 33317393},
            {76739211, 38254516},
            {86765007, 38251411},
            {86759599, 4231393},
            {85607478, 4227596},
        },
        {
        },
    },
    {
        {
            {534839721, 53437770},
            {534839721, 60849059},
            {539898273, 63773857},
            {545461140, 63757881},
            {544859741, 53447836},
            {541839721, 53437862},
            {541710836, 56353878},
            {540193984, 57229659},
            {538859741, 53437862},
            {534839721, 53437770},
        },
        {
        },
    },
    {
        {
            {756086230, 136598477},
            {732054387, 136605752},
            {732052489, 172629505},
            {756091994, 172627853},
            {756086230, 136598477},
        },
        {
        },
    },
    {
        {
            {100337034, 79731391},
            {70296833, 79731391},
            {70311095, 92263567},
            {74329808, 96264260},
            {96344976, 96257215},
            {100344419, 92232243},
            {100337034, 79731391},
        },
        {
        },
    },
    {
        {
            {102331115, 44216643},
            {67311095, 44217252},
            {67311095, 69250964},
            {74329808, 76264260},
            {96334594, 76251411},
            {103335261, 69241401},
            {103345839, 44231404},
            {102331115, 44216643},
        },
        {
        },
    },
    {
        {
            {93849749, 109613798},
            {91771666, 111698636},
            {91772404, 174626800},
            {96782902, 179645338},
            {241790509, 179645349},
            {246800716, 174626800},
            {246802574, 111699755},
            {243934250, 109616385},
            {93849749, 109613798},
        },
        {
        },
    },
    {
        {
            {15856630, 87966835},
            {8414359, 91273170},
            {5891847, 99010553},
            {8403012, 104668172},
            {13739106, 107763252},
            {13739106, 116209175},
            {17959116, 116219127},
            {17959127, 107763252},
            {23952579, 103855773},
            {25806388, 96944174},
            {22553953, 90543787},
            {15856630, 87966835},
        },
        {
        },
    },
    {
        {
            {503922805, 110421794},
            {491110107, 123244292},
            {479598157, 123244304},
            {479601067, 149264312},
            {494260327, 149265241},
            {502929782, 157948320},
            {506490250, 155806171},
            {502950518, 155094962},
            {507193172, 150852294},
            {504364680, 148023895},
            {535816833, 116571757},
            {538656617, 119411542},
            {542887886, 115157558},
            {543594970, 118693080},
            {545330008, 116966050},
            {540309189, 110425901},
            {503922805, 110421794},
        },
        {
        },
    },
    {
        {
            {519310433, 62560296},
            {515749982, 64702434},
            {519289696, 65413661},
            {515047062, 69656303},
            {517875553, 72484703},
            {486423431, 103936848},
            {483595031, 101108448},
            {479352325, 105351055},
            {478645233, 101815525},
            {476917724, 103520870},
            {481923478, 110077233},
            {518337308, 110084297},
            {531130127, 97264312},
            {542630127, 97281049},
            {542639167, 71244292},
            {527979906, 71243363},
            {519310433, 62560296},
        },
        {
        },
    },
    {
        {
            {528658425, 14775300},
            {525975568, 24475413},
            {522556814, 29181341},
            {517517474, 32090757},
            {511736147, 32698600},
            {506200465, 30901018},
            {501879743, 27011092},
            {497782491, 14775300},
            {492372374, 15588397},
            {489384268, 20795320},
            {491253082, 28537271},
            {495185363, 34469052},
            {495178475, 43927542},
            {502032399, 55796416},
            {524402581, 55807400},
            {531706434, 44295318},
            {531205383, 34469052},
            {536679415, 23789946},
            {535868173, 17264403},
            {532873348, 15073849},
            {528658425, 14775300},
        },
        {
        },
    },
    {
        {
            {481122222, 166062916},
            {478115710, 166824472},
            {477103577, 169063247},
            {477106058, 192070670},
            {478623652, 194687013},
            {525109130, 195083267},
            {525117792, 198086965},
            {535129140, 198091624},
            {535129150, 195083267},
            {539038502, 194940807},
            {540865280, 193308821},
            {541132038, 169100183},
            {539614599, 166459484},
            {481122222, 166062916},
        },
        {
        },
    },
    {
        {
            {23771404, 13005453},
            {24774973, 19182457},
            {31971050, 18727127},
            {32556286, 58337520},
            {25390683, 58337566},
            {25063762, 54707065},
            {20168811, 54707252},
            {20171550, 62917175},
            {70810377, 202895528},
            {74314421, 205588631},
            {88674817, 205515176},
            {91837376, 203083756},
            {92280287, 199307207},
            {40674807, 15904975},
            {36849630, 13006690},
            {23771404, 13005453},
        },
        {
        },
    },
    {
        {
            {336421201, 2986256},
            {331176570, 6498191},
            {327552287, 5825511},
            {324913825, 2988891},
            {316226154, 2989990},
            {313040282, 6275291},
            {313040282, 23489990},
            {307126391, 23490002},
            {307140289, 25510010},
            {313040282, 25510010},
            {313040282, 28989990},
            {307126391, 28990002},
            {307140289, 31015515},
            {313040282, 31010010},
            {313040282, 35989990},
            {304534809, 37529785},
            {304524991, 73488855},
            {308554680, 77518546},
            {324040282, 77510010},
            {324040295, 93025333},
            {334574441, 93010010},
            {334574441, 90989990},
            {332560302, 90989990},
            {332560302, 85010010},
            {334560302, 85010010},
            {334561237, 82010010},
            {338540282, 82010010},
            {339540282, 83760010},
            {338540293, 93020012},
            {348060655, 93014679},
            {356564448, 84500000},
            {356560555, 28989990},
            {347334198, 29039989},
            {347334198, 25510010},
            {356510304, 25521084},
            {356510315, 23478922},
            {347560302, 23489990},
            {347560302, 5775291},
            {344874443, 2989990},
            {336421201, 2986256},
        },
        {
        },
    },
    {
        {
            {465152221, 31684687},
            {457606880, 31688302},
            {452659362, 35508617},
            {449044605, 34734089},
            {446478972, 31692751},
            {437784814, 31692957},
            {435521210, 33956565},
            {435532195, 65697616},
            {426028494, 65691361},
            {426025938, 85049712},
            {435532195, 95717636},
            {435524445, 103754026},
            {436995898, 105225463},
            {447552204, 105226323},
            {447552215, 103197497},
            {444552215, 103197616},
            {444552215, 99217636},
            {452032195, 99217636},
            {452032195, 105221758},
            {465588513, 105225463},
            {467059965, 103754026},
            {467052215, 95717636},
            {478053039, 84511285},
            {478056214, 65697616},
            {468552215, 65697616},
            {468563959, 33957323},
            {465152221, 31684687},
        },
        {
        },
    },
    {
        {
            {764927063, 92658416},
            {762115426, 94171595},
            {762122741, 131696443},
            {786415417, 132779578},
            {793690904, 129904572},
            {797383202, 124822853},
            {798269157, 120142660},
            {796710161, 114090278},
            {793387498, 110215980},
            {796094093, 103892242},
            {794107594, 96994001},
            {787445494, 92840355},
            {764927063, 92658416},
        },
        {
        },
    },
    {
        {
            {27496331, 123147467},
            {3202195, 124246400},
            {3203433, 205768600},
            {20223453, 205775606},
            {20223644, 163243606},
            {31297341, 162189074},
            {36789517, 155659691},
            {36967183, 150566416},
            {34468182, 145711036},
            {38465496, 140400171},
            {38952460, 132613091},
            {34771593, 126022444},
            {27496331, 123147467},
        },
        {
        },
    },
    {
        {
            {797556553, 39197820},
            {791313598, 39199767},
            {789506233, 39864015},
            {789522521, 48199767},
            {775974570, 48195721},
            {774022521, 50129235},
            {774008720, 76258022},
            {775974570, 78223833},
            {789522521, 78219787},
            {789522521, 86576919},
            {797556547, 87221747},
            {797556553, 39197820},
        },
        {
        },
    },
    {
        {
            {676593113, 129820144},
            {676565322, 164844636},
            {701599609, 164858650},
            {701599609, 129823260},
            {676593113, 129820144},
        },
        {
        },
    },
    {
        {
            {727646871, 93121321},
            {709122741, 93122138},
            {709122741, 125656310},
            {718769809, 135145243},
            {721622937, 135156111},
            {724152429, 132626619},
            {723734126, 112688301},
            {725837154, 107378546},
            {728976138, 104430846},
            {735847924, 102664848},
            {741289364, 104430846},
            {745202882, 108599767},
            {746590596, 114642158},
            {751137173, 114644887},
            {756151199, 109641674},
            {756149037, 94634278},
            {754642761, 93122138},
            {727646871, 93121321},
        },
        {
        },
    },
    {
        {
            {135915724, 185598906},
            {131396265, 193419009},
            {131399444, 197643260},
            {140399444, 197636810},
            {140399444, 199138818},
            {157419464, 197643916},
            {157422805, 193210743},
            {153046747, 185604789},
            {149044579, 185614655},
            {147324399, 189850396},
            {144168954, 191108901},
            {141187892, 189479768},
            {139917659, 185615382},
            {135915724, 185598906},
        },
        {
        },
    },
    {
        {
            {312619110, 154485844},
            {309601817, 157488332},
            {309599764, 203494810},
            {313109244, 207010010},
            {352900849, 207019221},
            {359629120, 200302405},
            {359638705, 159501827},
            {354621096, 154487830},
            {312619110, 154485844},
        },
        {
        },
    },
    {
        {
            {313120315, 98984639},
            {309609100, 102486971},
            {309596977, 148492024},
            {312591195, 151510010},
            {354608772, 151524494},
            {359629120, 146515788},
            {359638123, 105715491},
            {352907860, 98987790},
            {313120315, 98984639},
        },
        {
        },
    },
    {
        {
            {657746643, 86246732},
            {651722477, 92270881},
            {651720052, 131280884},
            {653947196, 131280884},
            {659746643, 125487816},
            {659746643, 119273826},
            {663742413, 112352691},
            {671726623, 112352691},
            {675733721, 119283349},
            {684745297, 119298573},
            {689758503, 114263168},
            {689752066, 91272158},
            {684746643, 86260871},
            {657746643, 86246732},
        },
        {
        },
    },
    {
        {
            {653940791, 39260871},
            {651720052, 39260871},
            {651726623, 78280611},
            {657746631, 84295035},
            {684746643, 84280891},
            {689752066, 79269604},
            {689746643, 56247942},
            {684745283, 51243184},
            {675733721, 51258413},
            {671726623, 58189071},
            {663742413, 58189071},
            {659746643, 51267936},
            {659746643, 45053950},
            {653940791, 39260871},
        },
        {
        },
    },
    {
        {
            {442365208, 3053303},
            {436408500, 5694021},
            {434342552, 11072741},
            {436986326, 17009033},
            {442365367, 19073360},
            {448299202, 16431441},
            {450365150, 11052721},
            {448299202, 5694021},
            {442365208, 3053303},
        },
        {
        },
    },
};
