#!/bin/sh
# --- BEGIN COPYRIGHT BLOCK ---
# Copyright (C) 2015  Red Hat
# see files 'COPYING' and 'COPYING.openssl' for use and warranty
# information
# 
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
# 
# Additional permission under GPLv3 section 7:
# 
# If you modify this Program, or any covered work, by linking or
# combining it with OpenSSL, or a modified version of OpenSSL licensed
# under the OpenSSL license
# (https://www.openssl.org/source/license.html), the licensors of this
# Program grant you additional permission to convey the resulting
# work. Corresponding Source for a non-source form of such a
# combination shall include the source code for the parts that are
# licensed under the OpenSSL license as well as that of the covered
# work.
# --- END COPYRIGHT BLOCK ---
set -o errexit

echo Begin $0
pwd

PORTNUMS=10000
USE_POLL=1 MAX_THREADS=3 ./socket-event-test-threads $PORTNUMS & SERVERPID=$!

smallsizes="1 2 64 128 1024 8192 65536 1048560"
largesizes="$smallsizes 8388608 67108864 536870912"

NPROC=${NPROC:-8}

if [ $NPROC -gt 4 ] ; then
    sizes="$smallsizes"
else
    sizes="$largesizes"
fi

make_file() {
    if [ $1 -lt 512 ] ; then
        count=$1
        bs=1
    else
        bs=512
        count=`expr $1 / 512`
    fi
    dd if=/dev/zero of=$2 count=$count bs=$bs > /dev/null 2>&1
}

run_file_tests() {
    indir=$1/in
    outdir=$1/out.$2
    mkdir -p $outdir
    for size in $sizes ; do
        infile=$indir/file.$size.in
        outfile=$outdir/file.$size.out
#        curl -s -T $infile -o $outfile http://localhost:10000 || { echo error $! uploading file $infile ; exit 1 ; }
        
#        cmp -s $infile $outfile || { echo error files $infile and $outfile differ ; exit 1 ; }
        python put.py $infile || exit 1
    done
}

testdir=`mktemp -d`
indir=$testdir/in
if [ ! -d $indir ] ; then mkdir -p $indir ; fi
for size in $sizes ; do
    infile=$indir/file.$size.in
    make_file $size $infile
done

ii=$NPROC
PIDS=""
while [ $ii -gt 0 ] ; do
    echo proc $ii
    run_file_tests $testdir $ii & PIDS="$PIDS $!"
    ii=`expr $ii - 1`
done || : # why does while fail????
echo waiting
wait $PIDS || echo no procs to wait for
kill $SERVERPID
wait
rm -rf $testdir
echo done
