/*
  File autogenerated by gengetopt version 2.13
  generated with the following command:
  gengetopt --unamed-opts 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "getopt.h"

#include "cmdline.h"

static
void clear_given (struct gengetopt_args_info *args_info);
static
void clear_args (struct gengetopt_args_info *args_info);

static int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error);


static char *
gengetopt_strdup (const char *s);

static
void clear_given (struct gengetopt_args_info *args_info)
{
  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->statement_req_given = 0 ;
  args_info->accountinfo_req_given = 0 ;
  args_info->fid_given = 0 ;
  args_info->org_given = 0 ;
  args_info->bank_given = 0 ;
  args_info->broker_given = 0 ;
  args_info->user_given = 0 ;
  args_info->pass_given = 0 ;
  args_info->acct_given = 0 ;
  args_info->type_given = 0 ;
  args_info->past_given = 0 ;
  args_info->url_given = 0 ;
}

static
void clear_args (struct gengetopt_args_info *args_info)
{
  args_info->statement_req_flag = 0;
  args_info->accountinfo_req_flag = 0;
  args_info->fid_arg = NULL;
  args_info->org_arg = NULL;
  args_info->bank_arg = NULL;
  args_info->broker_arg = NULL;
  args_info->user_arg = NULL;
  args_info->pass_arg = NULL;
  args_info->acct_arg = NULL;
  args_info->url_arg = NULL;
}

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n%s\n", "prints to stdout the created OFX file based on the options you pass it. \ncurrently it will only create a statement request file.  you can POST this to \nan OFX server to request a statement from that financial institution for that \naccount.");
  printf("\nUsage: %s [OPTIONS]... [FILES]...\n\n", CMDLINE_PARSER_PACKAGE);
  printf("%s\n","  -h, --help             Print help and exit");
  printf("%s\n","  -V, --version          Print version and exit");
  printf("%s\n","  -s, --statement-req    Request for a statement  (default=off)");
  printf("%s\n","  -a, --accountinfo-req  Request for a list of accounts  (default=off)");
  printf("%s\n","      --fid=STRING       FI identifier");
  printf("%s\n","      --org=STRING       FI org tag");
  printf("%s\n","      --bank=STRING      IBAN bank identifier");
  printf("%s\n","      --broker=STRING    Broker identifier");
  printf("%s\n","      --user=STRING      User name");
  printf("%s\n","      --pass=STRING      Password");
  printf("%s\n","      --acct=STRING      Account ID");
  printf("%s\n","      --type=INT         Account Type 1=checking 2=invest 3=ccard");
  printf("%s\n","      --past=LONG        How far back to look from today (in days)");
  printf("%s\n","      --url=STRING       Url to POST the data to (otherwise goes to stdout)");
  
}

void
cmdline_parser_init (struct gengetopt_args_info *args_info)
{
  clear_given (args_info);
  clear_args (args_info);

  args_info->inputs = NULL;
  args_info->inputs_num = 0;
}

void
cmdline_parser_free (struct gengetopt_args_info *args_info)
{
  
  unsigned int i;
  if (args_info->fid_arg)
    {
      free (args_info->fid_arg); /* free previous argument */
      args_info->fid_arg = 0;
    }
  if (args_info->org_arg)
    {
      free (args_info->org_arg); /* free previous argument */
      args_info->org_arg = 0;
    }
  if (args_info->bank_arg)
    {
      free (args_info->bank_arg); /* free previous argument */
      args_info->bank_arg = 0;
    }
  if (args_info->broker_arg)
    {
      free (args_info->broker_arg); /* free previous argument */
      args_info->broker_arg = 0;
    }
  if (args_info->user_arg)
    {
      free (args_info->user_arg); /* free previous argument */
      args_info->user_arg = 0;
    }
  if (args_info->pass_arg)
    {
      free (args_info->pass_arg); /* free previous argument */
      args_info->pass_arg = 0;
    }
  if (args_info->acct_arg)
    {
      free (args_info->acct_arg); /* free previous argument */
      args_info->acct_arg = 0;
    }
  if (args_info->url_arg)
    {
      free (args_info->url_arg); /* free previous argument */
      args_info->url_arg = 0;
    }
  
  for (i = 0; i < args_info->inputs_num; ++i)
    free (args_info->inputs [i]);
  
  if (args_info->inputs_num)
    free (args_info->inputs);
  
  clear_given (args_info);
}

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = NULL;
  if (!s)
    return result;

  result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  return cmdline_parser2 (argc, argv, args_info, 0, 1, 1);
}

int
cmdline_parser2 (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required)
{
  int result;

  result = cmdline_parser_internal (argc, argv, args_info, override, initialize, check_required, NULL);

  if (result == EXIT_FAILURE)
    {
      cmdline_parser_free (args_info);
      exit (EXIT_FAILURE);
    }
  
  return result;
}

int
cmdline_parser_required (struct gengetopt_args_info *args_info, const char *prog_name)
{
  return EXIT_SUCCESS;
}

int
cmdline_parser_internal (int argc, char * const *argv, struct gengetopt_args_info *args_info, int override, int initialize, int check_required, const char *additional_error)
{
  int c;	/* Character of the parsed option.  */

  int error = 0;
  struct gengetopt_args_info local_args_info;

  if (initialize)
    cmdline_parser_init (args_info);

  cmdline_parser_init (&local_args_info);

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "statement-req",	0, NULL, 's' },
        { "accountinfo-req",	0, NULL, 'a' },
        { "fid",	1, NULL, 0 },
        { "org",	1, NULL, 0 },
        { "bank",	1, NULL, 0 },
        { "broker",	1, NULL, 0 },
        { "user",	1, NULL, 0 },
        { "pass",	1, NULL, 0 },
        { "acct",	1, NULL, 0 },
        { "type",	1, NULL, 0 },
        { "past",	1, NULL, 0 },
        { "url",	1, NULL, 0 },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVsa", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 's':	/* Request for a statement.  */
          if (local_args_info.statement_req_given)
            {
              fprintf (stderr, "%s: `--statement-req' (`-s') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->statement_req_given && ! override)
            continue;
          local_args_info.statement_req_given = 1;
          args_info->statement_req_given = 1;
          args_info->statement_req_flag = !(args_info->statement_req_flag);
          break;

        case 'a':	/* Request for a list of accounts.  */
          if (local_args_info.accountinfo_req_given)
            {
              fprintf (stderr, "%s: `--accountinfo-req' (`-a') option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
              goto failure;
            }
          if (args_info->accountinfo_req_given && ! override)
            continue;
          local_args_info.accountinfo_req_given = 1;
          args_info->accountinfo_req_given = 1;
          args_info->accountinfo_req_flag = !(args_info->accountinfo_req_flag);
          break;


        case 0:	/* Long option with no short option */
          /* FI identifier.  */
          if (strcmp (long_options[option_index].name, "fid") == 0)
          {
            if (local_args_info.fid_given)
              {
                fprintf (stderr, "%s: `--fid' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->fid_given && ! override)
              continue;
            local_args_info.fid_given = 1;
            args_info->fid_given = 1;
            if (args_info->fid_arg)
              free (args_info->fid_arg); /* free previous string */
            args_info->fid_arg = gengetopt_strdup (optarg);
          }
          /* FI org tag.  */
          else if (strcmp (long_options[option_index].name, "org") == 0)
          {
            if (local_args_info.org_given)
              {
                fprintf (stderr, "%s: `--org' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->org_given && ! override)
              continue;
            local_args_info.org_given = 1;
            args_info->org_given = 1;
            if (args_info->org_arg)
              free (args_info->org_arg); /* free previous string */
            args_info->org_arg = gengetopt_strdup (optarg);
          }
          /* IBAN bank identifier.  */
          else if (strcmp (long_options[option_index].name, "bank") == 0)
          {
            if (local_args_info.bank_given)
              {
                fprintf (stderr, "%s: `--bank' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->bank_given && ! override)
              continue;
            local_args_info.bank_given = 1;
            args_info->bank_given = 1;
            if (args_info->bank_arg)
              free (args_info->bank_arg); /* free previous string */
            args_info->bank_arg = gengetopt_strdup (optarg);
          }
          /* Broker identifier.  */
          else if (strcmp (long_options[option_index].name, "broker") == 0)
          {
            if (local_args_info.broker_given)
              {
                fprintf (stderr, "%s: `--broker' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->broker_given && ! override)
              continue;
            local_args_info.broker_given = 1;
            args_info->broker_given = 1;
            if (args_info->broker_arg)
              free (args_info->broker_arg); /* free previous string */
            args_info->broker_arg = gengetopt_strdup (optarg);
          }
          /* User name.  */
          else if (strcmp (long_options[option_index].name, "user") == 0)
          {
            if (local_args_info.user_given)
              {
                fprintf (stderr, "%s: `--user' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->user_given && ! override)
              continue;
            local_args_info.user_given = 1;
            args_info->user_given = 1;
            if (args_info->user_arg)
              free (args_info->user_arg); /* free previous string */
            args_info->user_arg = gengetopt_strdup (optarg);
          }
          /* Password.  */
          else if (strcmp (long_options[option_index].name, "pass") == 0)
          {
            if (local_args_info.pass_given)
              {
                fprintf (stderr, "%s: `--pass' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->pass_given && ! override)
              continue;
            local_args_info.pass_given = 1;
            args_info->pass_given = 1;
            if (args_info->pass_arg)
              free (args_info->pass_arg); /* free previous string */
            args_info->pass_arg = gengetopt_strdup (optarg);
          }
          /* Account ID.  */
          else if (strcmp (long_options[option_index].name, "acct") == 0)
          {
            if (local_args_info.acct_given)
              {
                fprintf (stderr, "%s: `--acct' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->acct_given && ! override)
              continue;
            local_args_info.acct_given = 1;
            args_info->acct_given = 1;
            if (args_info->acct_arg)
              free (args_info->acct_arg); /* free previous string */
            args_info->acct_arg = gengetopt_strdup (optarg);
          }
          /* Account Type 1=checking 2=invest 3=ccard.  */
          else if (strcmp (long_options[option_index].name, "type") == 0)
          {
            if (local_args_info.type_given)
              {
                fprintf (stderr, "%s: `--type' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->type_given && ! override)
              continue;
            local_args_info.type_given = 1;
            args_info->type_given = 1;
            args_info->type_arg = strtol (optarg,&stop_char,0);
          }
          /* How far back to look from today (in days).  */
          else if (strcmp (long_options[option_index].name, "past") == 0)
          {
            if (local_args_info.past_given)
              {
                fprintf (stderr, "%s: `--past' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->past_given && ! override)
              continue;
            local_args_info.past_given = 1;
            args_info->past_given = 1;
            args_info->past_arg = strtol (optarg,&stop_char,0);
          }
          /* Url to POST the data to (otherwise goes to stdout).  */
          else if (strcmp (long_options[option_index].name, "url") == 0)
          {
            if (local_args_info.url_given)
              {
                fprintf (stderr, "%s: `--url' option given more than once%s\n", argv[0], (additional_error ? additional_error : ""));
                goto failure;
              }
            if (args_info->url_given && ! override)
              continue;
            local_args_info.url_given = 1;
            args_info->url_given = 1;
            if (args_info->url_arg)
              free (args_info->url_arg); /* free previous string */
            args_info->url_arg = gengetopt_strdup (optarg);
          }
          
          break;
        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          goto failure;

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c%s\n", CMDLINE_PARSER_PACKAGE, c, (additional_error ? additional_error : ""));
          abort ();
        } /* switch */
    } /* while */




  cmdline_parser_free (&local_args_info);

  if ( error )
    return (EXIT_FAILURE);

  if (optind < argc)
    {
      int i = 0 ;

      args_info->inputs_num = argc - optind ;
      args_info->inputs =
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ;
    }

  return 0;

failure:
  
  cmdline_parser_free (&local_args_info);
  return (EXIT_FAILURE);
}
