MODULE DirTest;

IMPORT D   := VO:Base:Display,
       U   := VO:Base:Util,
           
       DF  := VO:Dlg:File,
       
              VO:Prefs:All,

              Err,             
              Locales;

VAR
  buffer : ARRAY 1024 OF CHAR;

  PROCEDURE GetFile*(parent : D.Window; title : ARRAY OF CHAR;
                     VAR full : ARRAY OF CHAR):BOOLEAN;

  VAR
    dlg    : DF.FileDlg;
    string : U.Text;

  BEGIN
    NEW(dlg);
    dlg.Init;
    dlg.SetParent(parent);
    dlg.SetPosition(D.centerOnParent,D.centerOnParent);
    dlg.SetTitle(title);
    dlg.Open;
    dlg.EventLoop;
    dlg.Close;

    IF dlg.result THEN
        string:=dlg.full.GetText();
        COPY(string^,full);
        RETURN TRUE;
    END;

    RETURN FALSE;
  END GetFile;


BEGIN       
  Locales.Set(Locales.ALL,"",buffer);

  D.display.SetAppName("VOE");
  IF ~D.display.Open() THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  IF GetFile(NIL,"Test",buffer) THEN
    Err.String("Selected: "); Err.String(buffer); Err.Ln;
  ELSE
    Err.String("Nothing selected!"); Err.Ln;
  END;

  D.display.Close;
END DirTest.