MODULE WRITE;

IMPORT D   := VO:Base:Display,

              VO:Prefs:All,  (* Include preferences for all objects *)

       E   := VO:Edit,
       F   := VO:EditFile,
       T   := VO:EditText,
       DC  := VO:StringClock,
       G   := VO:Object,
       P   := VO:Panel,
       ST  := VO:StatusLine,
       TE  := VO:Text,
       V   := VO:View,
       W   := VO:Window,
       Z   := VO:Base:Size,

              Err,
       f   := Files,
       PA  := ProgramArgs,
       TR  := TextRider;

VAR
  text      : T.Text;

  fileName,
  ErrStr    : ARRAY 256 OF CHAR;
  Error     : f.Result;


  w          : W.Window;
  edit       : E.Edit;
  digiClock  : DC.StringClock;
  vert       : P.Panel;
  status     : ST.StatusLine;
  statusText : TE.Text;
  view       : V.View;

  msg2Exit   : D.Msg2Exit;

  PROCEDURE ParseArgs;

  VAR
    reader : TR.Reader;
    buffer : ARRAY 256 OF CHAR;

  BEGIN
    reader:=TR.ConnectReader(PA.args);
    IF reader#NIL THEN
      reader.ReadLine(buffer);
      fileName:="";
      IF PA.args.ArgNumber()=1 THEN
        reader.ReadLine(fileName);
      ELSE
       Err.String("Test <filename>"); Err.Ln;
       HALT(1);
      END;
    END;
  END ParseArgs;


BEGIN
  ParseArgs;

  D.display.SetAppName("Test");
  IF ~D.display.Open() THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  NEW(w);
  w.Init;

  NEW(text);
  text.Init;

  Error:=F.LoadFromFile(text,fileName);
  IF Error#f.done THEN
    F.ErrorToString(Error,ErrStr);
    Err.String("Fehler in ");
    Err.String(fileName);
    Err.String(": ");
    Err.String(ErrStr);
    Err.Ln;
    HALT(1);
  ELSE
    text.SetFileName(fileName);
    text.FileToBufferName;
    text.EvaluateParser;
  END;

  NEW(vert);
  vert.Init;
  vert.SetFlags({G.horizontalFlex,G.verticalFlex});
  vert.Set(P.vertical);

    edit:=E.CreateEdit();
    edit.SetMinWidth(Z.unit,80);
    edit.SetMinHeight(Z.unit,25);
    edit.SetModel(text);
    edit.SetReadWrite(TRUE);

    view:=V.CreateView(edit);
    view.SetFlags({G.horizontalFlex,G.verticalFlex});

  vert.Add(view);

    NEW(status);
    status.Init;
    status.SetFlags({G.horizontalFlex});

      NEW(statusText);
      statusText.Init;
      statusText.SetFlags({G.horizontalFlex});
      edit.SetStatusObject(statusText);
    status.Add(statusText);

      NEW(digiClock);
      digiClock.Init;
      digiClock.SetFlags({G.verticalFlex});
    status.Add(digiClock);

  vert.Add(status);

  w.AddFocusObject(edit);

  w.SetTop(vert);
  w.SetTitle("Test");

  NEW(msg2Exit);
  msg2Exit.destination:=D.display;
  w.AddHandler(msg2Exit,W.closeMsg);

  w.Open;

  D.display.EventLoop;

  D.display.Close
END WRITE.