/*################################################################################
# Linux Management Providers (LMP), Provider Common Library
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
################################################################################*/

#include "Common.h"
#include "EmbeddedInstance.h"
#include <libxml/xpath.h>
#include <libxml/parser.h>
#include <libxml/tree.h>

static int parse_sizeof(const char* str) {
	size_t size = 0;
	while (str[size] != '\0') {
		++size;
	}
	return size;
}

int CF_parseXmlInstance(const char *xml,
                               const CMPIBroker *broker,
                               const char *ns,
                               CMPIInstance **instance)
{
	xmlDocPtr doc = xmlReadMemory(xml, parse_sizeof(xml), NULL, NULL, 0);
	if (doc == NULL) {
		return 1;
	}

	xmlNodePtr node, cur;
	node = xmlDocGetRootElement(doc);
	if (node == NULL) {
		return 1;
	}

	xmlChar* classname = xmlGetProp(node, BAD_CAST "CLASSNAME");
	if (classname == NULL) {
		return 1;
	}

	CMPIStatus status = {CMPI_RC_OK, NULL};
        CMPIObjectPath* op = CMNewObjectPath(broker, ns, (char *)classname, &status);
	if (status.rc != CMPI_RC_OK || op == NULL) {
		return 1;
	}

	CMPIInstance* temp_instance = CMNewInstance(broker, op, &status);
	if (status.rc != CMPI_RC_OK || temp_instance == NULL) {
		return 1;
	}

	cur = node->children;
	while(cur != NULL) {
		if (cur->type == XML_ELEMENT_NODE &&
					xmlStrcasecmp(cur->name, BAD_CAST "PROPERTY")==0 ) {
			xmlChar* prop_name = xmlGetProp(cur, BAD_CAST "NAME");
			xmlChar* type_name = xmlGetProp(cur, BAD_CAST "TYPE");
	
			CMPIValue cmpi_value;
			xmlNodePtr child = cur->children;
			while (child != NULL) {
				if (xmlStrcasecmp(child->name, BAD_CAST "VALUE")==0 && child->children != NULL) {
					xmlChar* value = child->children->content;
	
					if (xmlStrcasecmp(type_name, BAD_CAST "string") == 0) { 
						CMPIString* str_value = CMNewString(broker, (char *)value, NULL);
						cmpi_value.string = str_value;
						CMSetProperty(temp_instance, (char *) prop_name, &cmpi_value, CMPI_string);
					}
					else if (xmlStrcasecmp(type_name, BAD_CAST "uint16") == 0) { 
						cmpi_value.uint16 = atoi((char *)value);
						CMSetProperty(temp_instance, (char *) prop_name, &cmpi_value, CMPI_uint16);
					}
					else if (xmlStrcasecmp(type_name, BAD_CAST "uint32") == 0) { 
						cmpi_value.uint32 = atoi((char *)value);
						CMSetProperty(temp_instance, (char *) prop_name, &cmpi_value, CMPI_uint32);
					}
					else if (xmlStrcasecmp(type_name, BAD_CAST "uint64") == 0) { 
						cmpi_value.uint64 = atoi((char *)value);
						CMSetProperty(temp_instance, (char *) prop_name, &cmpi_value, CMPI_uint64);
					} else if (xmlStrcasecmp(type_name, BAD_CAST "sint16") == 0) { 
						cmpi_value.sint16 = atoi((char *)value);
						CMSetProperty(temp_instance, (char *) prop_name, &cmpi_value, CMPI_sint16);
					}
					else if (xmlStrcasecmp(type_name, BAD_CAST "sint32") == 0) { 
						cmpi_value.sint32 = atoi((char *)value);
						CMSetProperty(temp_instance, (char *) prop_name, &cmpi_value, CMPI_sint32);
					}
					else if (xmlStrcasecmp(type_name, BAD_CAST "sint64") == 0) { 
						cmpi_value.sint64 = atoi((char *)value);
						CMSetProperty(temp_instance, (char *) prop_name, &cmpi_value, CMPI_sint64);
					} else if (xmlStrcasecmp(type_name, BAD_CAST "boolean") == 0) { 
						if (strcasecmp((char *)value, "true") == 0) {
							cmpi_value.boolean = true;
						} else if (strcasecmp((char *)value, "false") == 0) {
							cmpi_value.boolean = false;
						} else {
							_DEBUG("boolean type can has only two values:true or false.");
							return 1;
						}
						CMSetProperty(temp_instance, (char *) prop_name, &cmpi_value, CMPI_boolean);
					}
					break;
				}
				child = child->next;
			}
	
		}
	cur = cur->next;
	}

	xmlFree(doc);
	xmlCleanupParser();
	
	*instance = temp_instance;
	return 0;
}
