/***************************************************************************
 $RCSfile: bankparams.cpp,v $
                             -------------------
    cvs         : $Id: bankparams.cpp,v 1.10 2002/09/08 19:30:51 cstim Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif


#include "bankparams.h"
#include "hbcistring.h"


namespace HBCI {

bpdCom::bpdCom()
:_language(1)
,_type(0)
,_filterVersion(0)
{
}


bpdCom::~bpdCom(){
}


bpd::bpd()
    :_version(0)
    ,_country(280)
    ,_maxmsgsize(0)
    ,_maxdifferentactions(0)
{
}


bpd::~bpd(){
}




bankParams::bankParams(){
}


bankParams::bankParams(const bankParams &p){
    *this=p;
}


bankParams::bankParams(int cn, const string &co, const string &server){
    _bpd.setCountry(cn);
    _bpd.setInstituteCode(co);
    _bpdcom.setAddr(server);
}


bankParams::bankParams(bpd b, bpdCom c, list<bpdJob> j){
    _bpd=b;
    _bpdcom=c;
    _supportedJobs=j;
}


bankParams::~bankParams(){
}


const bpdJob *bankParams::findJob(const string &segname, 
				  int minv, int maxv) const
{
    list<bpdJob>::const_iterator it;
    // if no job with minV <= segversion <= maxV is found
    // we return the job with the highest segversion we can find
    const bpdJob *fallback = 0;

    for (it=_supportedJobs.begin();
         it!=_supportedJobs.end();
         it++) {
	if ((*it).segmentCode()==segname) {
	    fallback = &(*it);
	    if ((minv==-1 || (*it).segmentVersion()>=minv) &&
		(maxv==-1 || (*it).segmentVersion()<=maxv))
		return &(*it);
	}
    } // for

    return fallback;
}

} // namespace HBCI
