/***************************************************************************
 $RCSfile: transaction.cpp,v $
                             -------------------
    cvs         : $Id: transaction.cpp,v 1.8 2003/07/02 23:07:05 aquamaniac Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2002 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/*
 Changes

 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "transaction.h"
#include "hbcistring.h"
#include "assert.h"

namespace HBCI {


Transaction::Transaction()
    :_tid(0)
    ,_ourCountryCode(280)
    ,_otherCountryCode(280)
    ,_transactionCode(51)
    ,_value(Value("0,:EUR"))
    ,_originalValue(Value("0,:EUR"))
    ,_charge(Value("0,:EUR"))
{
}


Transaction::~Transaction() {
}

void Transaction::dump(FILE *f) const{
  list<string>::const_iterator it;

  fprintf(f,"Transaction  :\n");
  fprintf(f,"TID              : %d\n", _tid);
  fprintf(f,"OurCountry       : %d\n", _ourCountryCode);
  fprintf(f,"OurInstCode      : %s\n", _ourInstCode.c_str());
  fprintf(f,"OurId            : %s\n", _ourId.c_str());
  fprintf(f,"OtherCountry     : %d\n", _otherCountryCode);
  fprintf(f,"OtherInstCode    : %s\n", _otherInstCode.c_str());
  fprintf(f,"OtherId          : %s\n", _otherId.c_str());
  fprintf(f,"Value            : %s\n", _value.toReadableString().c_str());
  fprintf(f,"Primanota        : %s\n", _primanota.c_str());
  fprintf(f,"TransactionKey   : %s\n", _transactionKey.c_str());
  fprintf(f,"CustomerReference: %s\n", _customerReference.c_str());
  fprintf(f,"BankReference    : %s\n", _bankReference.c_str());
  fprintf(f,"TransactionCode  : %d\n", _transactionCode);
  fprintf(f,"OtherName        :\n");
  for (it=_otherName.begin(); it!=_otherName.end(); it++)
    fprintf(f,"   %s\n", (*it).c_str());
  fprintf(f,"Purpose          :\n");
  for (it=_description.begin(); it!=_description.end(); it++)
    fprintf(f,"   %s\n", (*it).c_str());
}

bool Transaction::operator==(const Transaction &t) const {
    bool result;

    result=(
        (_ourInstCode==t._ourInstCode) &&
        (_ourId==t._ourId) &&
        (_otherInstCode==t._otherInstCode) &&
        (_otherId==t._otherId) &&
        (_primanota==t._primanota) &&
        (_transactionKey==t._transactionKey) &&
        (_transactionCode==t._transactionCode) &&
        (_transactionText==t._transactionText) &&
        (_date==t._date) &&
        (_customerReference==t._customerReference) &&
        (_bankReference==t._bankReference) &&
        (_valutaDate==t._valutaDate) &&
        (_value==t._value) &&
        (_originalValue==t._originalValue) &&
        (_charge==t._charge) &&
        (_otherName.size()==t._otherName.size()) &&
        (_description.size()==t._description.size())
	   );

    /*
    if (_tid>=70) {
      fprintf(stderr,"Comparing tid %d (%d): Equal ? %s\n",
	      _tid, t._tid, result?"yes":"no");
      if (_ourInstCode!=t._ourInstCode)
	fprintf(stderr,"ourinstcode\n");
      if (_ourId!=t._ourId)
	fprintf(stderr,"ourid\n");
      if (_otherInstCode!=t._otherInstCode)
	fprintf(stderr,"otherinstcode\n");
      if (_otherId!=t._otherId)
	fprintf(stderr,"otherid\n");
      if (_primanota!=t._primanota)
	fprintf(stderr,"primanota\n");
      if (_transactionKey!=t._transactionKey)
	fprintf(stderr,"transactionkey\n");
      if (_transactionCode!=t._transactionCode)
	fprintf(stderr,"transactioncode\n");
      if (_transactionText!=t._transactionText)
	fprintf(stderr,"transactiontext\n");
      if (!(_date==t._date))
	fprintf(stderr,"date (%s!=%s)\n",
		_date.toString().c_str(),
		t._date.toString().c_str());
      if (_customerReference!=t._customerReference)
	fprintf(stderr,"customerref\n");
      if (_bankReference!=t._bankReference)
	fprintf(stderr,"bankref\n");
      if (!(_valutaDate==t._valutaDate))
	fprintf(stderr,"valutadate (%s!=%s)\n",
		_valutaDate.toString().c_str(),
		t._valutaDate.toString().c_str());
      if (!(_value==t._value))
	fprintf(stderr,"value\n");
      if (!(_originalValue==t._originalValue)) {
	fprintf(stderr,"originalvalue:\n");
	fprintf(stderr," This: %s\n", _originalValue.toString().c_str());
	fprintf(stderr," That: %s\n", t._originalValue.toString().c_str());
      }
      if (!(_charge==t._charge))
	fprintf(stderr,"charge (%s!=%s)\n",
		_charge.toString().c_str(),
		t._charge.toString().c_str());
      if (_otherName.size()!=t._otherName.size())
	fprintf(stderr,"othername\n");
      if (_description.size()!=t._description.size())
	fprintf(stderr,"othername\n");
      fprintf(stderr,"----------------------------\n");
      }
    if (result)
    fprintf(stderr," Transaction %d matches.\n", _tid);
    */
    return result;
}

} // namespace HBCI

HBCI_Transaction * HBCI_Transaction_new()
{
    return new HBCI_Transaction();
}
void HBCI_Transaction_delete(HBCI_Transaction *t)
{
    delete t;
}

int HBCI_Transaction_ourCountryCode(const HBCI_Transaction *t)
{
    assert(t);
    return t->ourCountryCode();
}
void 
HBCI_Transaction_setOurCountryCode(HBCI_Transaction *t, int i)
{
    assert(t);
    t->setOurCountryCode(i);
}
const char * HBCI_Transaction_ourBankCode(const HBCI_Transaction *t)
{
    assert(t);
    return t->ourBankCode().c_str();
}
void 
HBCI_Transaction_setOurBankCode(HBCI_Transaction *t, const char *code)
{
    assert(t);
    t->setOurBankCode(string(code ? code : ""));
}
const char * HBCI_Transaction_ourAccountId(const HBCI_Transaction *t)
{
    assert(t);
    return t->ourAccountId().c_str();
}
void 
HBCI_Transaction_setOurAccountId(HBCI_Transaction *t, const char *id)
{
    assert(t);
    t->setOurAccountId(string(id ? id : ""));
}
const char * HBCI_Transaction_ourSuffix(const HBCI_Transaction *t)
{
    assert(t);
    return t->ourSuffix().c_str();
}
void 
HBCI_Transaction_setOurSuffix(HBCI_Transaction *t, const char *id)
{
    assert(t);
    t->setOurSuffix(string(id ? id : ""));
}
const HBCI_Date* HBCI_Transaction_valutaDate(const HBCI_Transaction *t)
{
    assert(t);
    return &(t->valutaDate());
}
void 
HBCI_Transaction_setValutaDate(HBCI_Transaction *t, const HBCI_Date *d)
{
    assert(t);
    assert(d);
    t->setValutaDate(*d);
}
const HBCI_Date* HBCI_Transaction_date(const HBCI_Transaction *t)
{
    assert(t);
    return &(t->date());
}
void 
HBCI_Transaction_setDate(HBCI_Transaction *t, const HBCI_Date *d)
{
    assert(t);
    assert(d);
    t->setDate(*d);
}
const HBCI_Value* HBCI_Transaction_value(const HBCI_Transaction *t)
{
    assert(t);
    return &(t->value());
}
void 
HBCI_Transaction_setValue(HBCI_Transaction *t, const HBCI_Value *v)
{
    assert(t);
    assert(v);
    t->setValue(*v);
}
const char * HBCI_Transaction_transactionKey(const HBCI_Transaction *t)
{
    assert(t);
    return t->transactionKey().c_str();
}
void 
HBCI_Transaction_setTransactionKey(HBCI_Transaction *t, const char *s)
{
    assert(t);
    t->setTransactionKey(string(s ? s : ""));
}
const char * HBCI_Transaction_customerReference(const HBCI_Transaction *t)
{
    assert(t);
    return t->customerReference().c_str();
}
void 
HBCI_Transaction_setCustomerReference(HBCI_Transaction *t, const char *s)
{
    assert(t);
    t->setCustomerReference(string(s ? s : ""));
}
const char * HBCI_Transaction_bankReference(const HBCI_Transaction *t)
{
    assert(t);
    return t->bankReference().c_str();
}
void 
HBCI_Transaction_setBankReference(HBCI_Transaction *t, const char *s)
{
    assert(t);
    t->setBankReference(string(s ? s : ""));
}


// Now follows the obnoxious "Mehrzweckfeld :86:"

int HBCI_Transaction_transactionCode(const HBCI_Transaction *t)
{
    assert(t);
    return t->transactionCode();
}
void 
HBCI_Transaction_setTransactionCode(HBCI_Transaction *t, int c)
{
    assert(t);
    t->setTransactionCode(c);
}
const char * HBCI_Transaction_transactionText(const HBCI_Transaction *t)
{
    assert(t);
    return t->transactionText().c_str();
}
void 
HBCI_Transaction_setTransactionText(HBCI_Transaction *t, const char *s)
{
    assert(t);
    t->setTransactionText(string(s ? s : ""));
}
const char * HBCI_Transaction_primanota(const HBCI_Transaction *t)
{
    assert(t);
    return t->primanota().c_str();
}
void 
HBCI_Transaction_setPrimanota(HBCI_Transaction *t, const char *s)
{
    assert(t);
    t->setPrimanota(string(s ? s : ""));
}
const list_string* HBCI_Transaction_description(const HBCI_Transaction *t)
{
    assert(t);
    return &(t->description());
}
void 
HBCI_Transaction_addDescription(HBCI_Transaction *t, const char *s)
{
    assert(t);
    t->addDescription(string(s ? s : ""));
}
int HBCI_Transaction_otherCountryCode(const HBCI_Transaction *t)
{
    assert(t);
    return t->otherCountryCode();
}
void 
HBCI_Transaction_setOtherCountryCode(HBCI_Transaction *t, int i)
{
    assert(t);
    t->setOtherCountryCode(i);
}
const char * HBCI_Transaction_otherBankCode(const HBCI_Transaction *t)
{
    assert(t);
    return t->otherBankCode().c_str();
}
void 
HBCI_Transaction_setOtherBankCode(HBCI_Transaction *t, const char *s)
{
    assert(t);
    t->setOtherBankCode(string(s ? s : ""));
}
const char * HBCI_Transaction_otherAccountId(const HBCI_Transaction *t)
{
    assert(t);
    return t->otherAccountId().c_str();
}
void 
HBCI_Transaction_setOtherAccountId(HBCI_Transaction *t, const char *s)
{
    assert(t);
    t->setOtherAccountId(string(s ? s : ""));
}
const char * HBCI_Transaction_otherSuffix(const HBCI_Transaction *t)
{
    assert(t);
    return t->otherSuffix().c_str();
}
void 
HBCI_Transaction_setOtherSuffix(HBCI_Transaction *t, const char *id)
{
    assert(t);
    t->setOtherSuffix(string(id ? id : ""));
}
const list_string* HBCI_Transaction_otherName(const HBCI_Transaction *t)
{
    assert(t);
    return &(t->otherName());
}
void 
HBCI_Transaction_addOtherName(HBCI_Transaction *t, const char *s)
{
    assert(t);
    t->addOtherName(string(s ? s : ""));
}




void list_HBCI_Transaction_delete(list_HBCI_Transaction *l)
{
    delete l;
}
void list_HBCI_Transaction_iter_delete(list_HBCI_Transaction_iter *l)
{
    delete l;
}
int list_HBCI_Transaction_size(const list_HBCI_Transaction *l)
{
    assert(l);
    return l->size();
}
list_HBCI_Transaction_iter* 
list_HBCI_Transaction_begin(const list_HBCI_Transaction *l)
{
    assert(l);
    return new list_HBCI_Transaction_iter(l->begin());
}
list_HBCI_Transaction_iter* 
list_HBCI_Transaction_end(const list_HBCI_Transaction *l)
{
    assert(l);
    return new list_HBCI_Transaction_iter(l->end());
}
const HBCI_Transaction *
list_HBCI_Transaction_iter_get(const list_HBCI_Transaction_iter *l)
{
    assert(l);
    return &(**l);
}
void
list_HBCI_Transaction_iter_next(list_HBCI_Transaction_iter *l)
{
    assert(l);
    l->operator++();
}
int 
list_HBCI_Transaction_iter_equal(const list_HBCI_Transaction_iter *l1, 
				const list_HBCI_Transaction_iter *l2)
{
    assert(l1);
    assert(l2);
    return (*l1) == (*l2);
}
void *list_HBCI_Transaction_foreach (const list_HBCI_Transaction *list, 
				     list_HBCI_Transaction_cb func,
				     void *user_data)
{
    assert(list);
    assert(func);
    list_HBCI_Transaction_iter iter, end;
    void *ret = 0l;

    end = list->end();
    for ( iter = list->begin(); iter != end; iter++ ) {
	ret = (*func)( &(*iter), user_data);
	if (ret)
	    break;
    }
    return ret;
}


