/***************************************************************************
  $RCSfile: plugin.cpp,v $
  -------------------
  cvs         : $Id: plugin.cpp,v 1.3 2003/05/01 22:18:07 cstim Exp $
  begin       : Mon Apr 14 2003
  copyright   : (C) 2003 by Martin Preuss
  email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include "plugin.h"
#include "hbcistring.h"
#include <assert.h>


namespace HBCI {


Plugin::Plugin(){
}


Plugin::~Plugin(){
}

}; // namespace


char *HBCI_Plugin_name(const HBCI_Plugin *p)
{
    assert(p);
    return hbci_strdup(p->name());
}
char *HBCI_Plugin_description(const HBCI_Plugin *p)
{
    assert(p);
    return hbci_strdup(p->description());
}
unsigned int HBCI_Plugin_vmajor(const HBCI_Plugin *p)
{
    assert(p);
    return p->vmajor();
}
unsigned int HBCI_Plugin_vminor(const HBCI_Plugin *p)
{
    assert(p);
    return p->vminor();
}
int HBCI_Plugin_pluginType(const HBCI_Plugin *p)
{
    assert(p);
    return p->pluginType();
}


