/* turnover.c

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#include "turnover.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <openhbci/outboxaccjobs.h>
#include <openhbci/customer.h>
#include <openhbci/date.h>
#include <openhbci/transaction.h>

HBCI_Error* turnover(HBCI_API* hbciif,
		    HBCI_CmdLineOptions* opt){
    HBCI_OutboxJobGetTransactions* job_trans = 0; 
    HBCI_OutboxJobGetBalance* job_bal = 0; 
    int country;
    const char* bankCode = 0;
    const char* accnr = 0;
    const char* user_id = 0;
    HBCI_Account* account = 0;
    const HBCI_Customer* customer = 0;
    HBCI_User* user = 0;
    HBCI_Error* err = 0;
    const HBCI_Value *resultvalue = 0;
    const HBCI_AccountBalance *accBal = 0;
    const HBCI_Balance *notedBal = 0, *bookedBal = 0;
    const list_HBCI_Customer *cust_list = 0;
    /*list_HBCI_Customer_iter *cust_list_iter = 0, *cust_list_end = 0;*/
    const char *fdate = 0, *tdate = 0;
    HBCI_Date *fromdate = 0, *todate = 0;
    const HBCI_Transaction *trans = 0;
    const list_HBCI_Transaction *trans_list = 0;
    list_HBCI_Transaction_iter *trans_iter = 0, *trans_end = 0;
    struct tm mytm;
    char *vstring;
    HBCI_Bank *bank = 0;
    
    
    
    
    accnr = HBCI_CmdLineOptions_getStringVariable(opt, "accnr", "*");
    bankCode = HBCI_CmdLineOptions_getStringVariable(opt, "instid", "*");
    country = HBCI_CmdLineOptions_getIntVariable(opt, "country", 280);
    user_id = HBCI_CmdLineOptions_getStringVariable(opt, "user", "*");
    fdate = HBCI_CmdLineOptions_getStringVariable(opt, "fromdate","");
    tdate = HBCI_CmdLineOptions_getStringVariable(opt, "todate","");
    
    /* set from date */
    if (strlen(fdate)==0) 
	fromdate = HBCI_Date_new_blank();
    else {
	fromdate = HBCI_Date_new_string(fdate, 4);
	if (!HBCI_Date_isValid(fromdate))
	    return HBCI_Error_new("turnover()",
				 ERROR_LEVEL_NORMAL,
				 0,
				 ERROR_ADVISE_DONTKNOW,
				 "error in fromdate date format.", "");
    }
    if (strlen(tdate)==0) 
	todate = HBCI_Date_new_blank();
    else {
	todate = HBCI_Date_new_string(tdate, 4);
	if (!HBCI_Date_isValid(todate))
	    return HBCI_Error_new("turnover()",
				 ERROR_LEVEL_NORMAL,
				 0,
				 ERROR_ADVISE_DONTKNOW,
				 "error in todate date format.", "");
    }
    

    /* get the bank */
    bank = HBCI_API_findBank(hbciif, country, bankCode);
    if (bank == NULL) 
      return HBCI_Error_new("getBalance()",
			    ERROR_LEVEL_NORMAL,
			    0,
			    ERROR_ADVISE_DONTKNOW,
			    "No matching bank found.", " ");

    /* get the given account */
    account = (HBCI_Account *) HBCI_Bank_findAccount(bank, accnr);

    if (!account)
        return HBCI_Error_new("turnover()",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "account not found", "");

    /* get the given user */
    /*user = HBCI_Bank_findUser(bank, user_id); */

    /* get all the possible customers */
    cust_list = HBCI_Account_authorizedCustomers(account);
    if (list_HBCI_Customer_size(cust_list)>1)
	printf("More than one customer per user with user_id %s.\n Aborting -- you would need to implement choosing one of them...\n",
	       HBCI_User_userId(user));
    else
	customer = list_HBCI_Customer_iter_get(
	    list_HBCI_Customer_begin(cust_list));
    
    /* create job for the given account */
    if (account != 0) {

	/* create job for this account */
	printf("New job for Account Number: %s, Name: %s, BLZ: %s\n   name1: %s\n",
	       HBCI_Account_accountId(account),
	       HBCI_Account_accountName(account), 
	       HBCI_Bank_bankCode(HBCI_Account_bank(account)), 
	       HBCI_Account_name1(account)
	       );
	job_trans = HBCI_OutboxJobGetTransactions_new(customer, account, 
						 fromdate, todate);
	job_bal = HBCI_OutboxJobGetBalance_new(customer, account);
	
	/* enqueue jobs */
	HBCI_API_addJob(hbciif, HBCI_OutboxJobGetTransactions_OutboxJob(job_trans));
	HBCI_API_addJob(hbciif, HBCI_OutboxJobGetBalance_OutboxJob(job_bal));

	/* and execute the outbox. */
	err = HBCI_API_executeQueue(hbciif, 1);
	printf("Executed outbox with changesAllowed=1\n");
	
	if (!HBCI_Error_isOk(err))
	    return err;

	trans_list = HBCI_OutboxJobGetTransactions_transactions(job_trans);
	printf("Got %d transactions.\n", 
	       list_HBCI_Transaction_size(trans_list));
	trans_end = list_HBCI_Transaction_end(trans_list);
	for (trans_iter = list_HBCI_Transaction_begin(trans_list);
	     !list_HBCI_Transaction_iter_equal(trans_iter, trans_end);
	     list_HBCI_Transaction_iter_next(trans_iter)) {
	    trans = list_HBCI_Transaction_iter_get(trans_iter);
	    printf("Got transaction: from account %s to account %s\n",
		   HBCI_Transaction_ourAccountId(trans),
		   HBCI_Transaction_otherAccountId(trans));
	    mytm = HBCI_Date_to_tm(HBCI_Transaction_date(trans));
	    printf("\t at date %d.%d.%d ",
		   mytm.tm_mday, mytm.tm_mon, mytm.tm_year);
	    mytm = HBCI_Date_to_tm(HBCI_Transaction_valutaDate(trans));
	    printf("valutadate %d.%d.%d ",
		   mytm.tm_mday, mytm.tm_mon, 1900+mytm.tm_year);
	    vstring = 
		HBCI_Value_toReadableString(HBCI_Transaction_value(trans));
	    printf("value %s\n", vstring);
	    free(vstring);
	}
	


	accBal = HBCI_OutboxJobGetBalance_getBalance(job_bal);
	notedBal = HBCI_AccountBalance_notedBalance(accBal);
	bookedBal = HBCI_AccountBalance_bookedBalance(accBal);
	resultvalue = HBCI_Balance_value(notedBal);
	printf("Noted balance: %s for account no. %s\n",
	       HBCI_Value_toReadableString(resultvalue), /* this ought to be free'd */
	       HBCI_Account_accountId(account));
	resultvalue = HBCI_Balance_value(bookedBal);
	printf("Booked balance: %s for account no. %s\n",
	       HBCI_Value_toReadableString(resultvalue),
	       HBCI_Account_accountId(account));
    } else {
	printf("Sorry, zero matching accounts found. Exiting.\n");
	err = HBCI_Error_new("getBalance()",
			    ERROR_LEVEL_NORMAL,
			    0,
			    ERROR_ADVISE_DONTKNOW,
			    "Zero matching accounts found.", " ");
    }

    return err;
}





