/* hbcibank.cpp 
   (C) 2002 by Christian <Stimming@tuhh.de> */

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "assert.h"
#include "bank.h"

namespace HBCI {

instituteMessage::instituteMessage()
    :_country(280)
    ,_read(false)
{
}


instituteMessage::~instituteMessage(){
}

const bool instituteMessage::operator==(const instituteMessage &msg) {
    return (_date == msg._date &&
			0 == _time.compare(msg._time) &&
			_subject == msg._subject &&
			_text == msg._text &&
			_country == msg._country &&
			_instituteCode == msg._instituteCode &&
			_read == msg._read);
}

Bank::Bank(){
}


Bank::~Bank(){
  //fprintf(stderr,"Destroying Bank\n");
}
/*
bool
Bank::operator==(const Bank &b) const
{
    return (countryCode()==b.countryCode()) &&
	(bankCode() == b.bankCode());
}
*/

} // namespace HBCI
const HBCI_Hbci *HBCI_Bank_hbci(const HBCI_Bank *h)
{
    assert(h);
    return h->hbci();
}
int HBCI_Bank_countryCode(const HBCI_Bank *h)
{
    assert(h);
    return h->countryCode();
}
void HBCI_Bank_setCountryCode(HBCI_Bank *h, int i)
{ 
    assert(h); 
    h->setCountryCode(i);
}
const char *HBCI_Bank_bankCode(const HBCI_Bank *h)
{ 
    assert(h); 
    return h->bankCode().c_str();
}
void HBCI_Bank_setBankCode(HBCI_Bank *h, const char *s)
{
    assert(h); 
    h->setBankCode(string(s ? s : ""));
}
const char *HBCI_Bank_name(const HBCI_Bank *h)
{
    assert(h); 
    return h->name().c_str();
}
const list_HBCI_instituteMessage *HBCI_Bank_messages(const HBCI_Bank *h)
{
    assert(h);
    return &(h->messages());
}
const HBCI_User *HBCI_Bank_findUser(const HBCI_Bank *h, const char *userid)
{
    assert(h); 
    return (h->findUser(string(userid ? userid : ""))).ptr();
}
const HBCI_Account *HBCI_Bank_findAccount(const HBCI_Bank *h, const char *nr)
{
    assert(h); 
    return (h->findAccount(string(nr ? nr : ""))).ptr();
}
const HBCI_Account *HBCI_Bank_findAccountWSuf(const HBCI_Bank *h, 
					    const char *nr, 
					    const char *suf)
{
    assert(h); 
    return (h->findAccount(string(nr ? nr : ""), 
			   string(suf ? suf : ""))).ptr();
}
const list_HBCI_Account *HBCI_Bank_accounts(const HBCI_Bank *h)
{
    assert(h);
    return &(h->accounts());
}
const list_HBCI_User *HBCI_Bank_users(const HBCI_Bank *h)
{
    assert(h);
    return &(h->users());
}
HBCI_Error *
HBCI_Bank_addAccount(HBCI_Bank *h, HBCI_Account *a, int autoDelete)
{ 
    assert(h); 
    assert(a);
    HBCI::Pointer<HBCI::Account> ap = a;
    ap.setAutoDelete(autoDelete);
    try {
	h->addAccount(ap);
	return 0;
    }
    catch(HBCI_Error err) {
	return new HBCI_Error(err);
    }
}
HBCI_Error *HBCI_Bank_addUser(HBCI_Bank *h, HBCI_User *c, int autoDelete)
{ 
    assert(h); 
    assert(c);
    HBCI::Pointer<HBCI::User> cp = c;
    cp.setAutoDelete(autoDelete);
    try {
	h->addUser(cp);
	return 0;
    }
    catch(HBCI_Error err) {
	return new HBCI_Error(err);
    }
}
int HBCI_Bank_type(const HBCI_Bank *h)
{ 
    assert(h); 
    return h->type();
}
void HBCI_Bank_setType(HBCI_Bank *h, int i)
{ 
    assert(h); 
    h->setType(i);
}
const char *HBCI_Bank_addr(const HBCI_Bank *h)
{ 
    assert(h); 
    return h->addr().c_str();
}
void HBCI_Bank_setAddr(HBCI_Bank *h, const char *s)
{ 
    assert(h); 
    h->setAddr(string(s ? s : ""));
}


int HBCI_Bank_hbciVersion(const HBCI_Bank *h)
{ 
    assert(h); 
    return h->hbciVersion();
}
void HBCI_Bank_setHbciVersion(HBCI_Bank *h, int v)
{ 
    assert(h); 
    h->setHbciVersion(v);
}
int HBCI_Bank_bpdVersion(const HBCI_Bank *h)
{ 
    assert(h); 
    return h->bpdVersion();
}
void HBCI_Bank_setBPDVersion(HBCI_Bank *h, int i)
{ 
    assert(h); 
    h->setBPDVersion(i);
}
list_int *HBCI_Bank_supportedVersions(const HBCI_Bank *h)
{ 
    assert(h); 
    return new list_int(h->supportedVersions());
}
const HBCI_bpdJob *HBCI_Bank_findJob(const HBCI_Bank *h,
				     const char *segname)
{
    assert(h); 
    return h->findJob(segname);
}
const HBCI_bpdJob *HBCI_Bank_findJob_minv(const HBCI_Bank *h,
					  const char *segname, 
					  int minv)
{
    assert(h); 
    return h->findJob(segname, minv);
}
const HBCI_bpdJob *HBCI_Bank_findJob_maxv(const HBCI_Bank *h,
					  const char *segname, 
					  int minv, int maxv)
{
    assert(h); 
    return h->findJob(segname, minv, maxv);
}




void list_HBCI_Bank_delete(list_HBCI_Bank *l)
{
    delete l;
}
void list_HBCI_Bank_iter_delete(list_HBCI_Bank_iter *l)
{
    delete l;
}
int list_HBCI_Bank_size(const list_HBCI_Bank *l)
{
    assert(l);
    return l->size();
}
list_HBCI_Bank_iter* list_HBCI_Bank_begin(const list_HBCI_Bank *l)
{
    assert(l);
    return new list_HBCI_Bank_iter(l->begin());
}
list_HBCI_Bank_iter* list_HBCI_Bank_end(const list_HBCI_Bank *l)
{
    assert(l);
    return new list_HBCI_Bank_iter(l->end());
}
const HBCI_Bank *
list_HBCI_Bank_iter_get(const list_HBCI_Bank_iter *l)
{
    assert(l);
    return (**l).ptr();
}
void list_HBCI_Bank_iter_next(list_HBCI_Bank_iter *l)
{
    assert(l);
    l->operator++();
}
int list_HBCI_Bank_iter_equal(const list_HBCI_Bank_iter *l1, 
			      const list_HBCI_Bank_iter *l2)
{
    assert(l1);
    assert(l2);
    return (*l1) == (*l2);
}
void *list_HBCI_Bank_foreach (const list_HBCI_Bank *list, 
			      list_HBCI_Bank_cb func,
			      void *user_data)
{
    assert(list);
    assert(func);
    list_HBCI_Bank_iter iter, end;
    void *ret = 0l;

    end = list->end();
    for ( iter = list->begin(); iter != end; iter++ ) {
	ret = (*func)( (*iter).ptr(), user_data);
	if (ret)
	    break;
    }
    return ret;
}



const HBCI_Date *
HBCI_instituteMessage_date(const HBCI_instituteMessage *m)
{
    assert(m);
    return &(m->date());
}
const HBCI_Time *
HBCI_instituteMessage_time(const HBCI_instituteMessage *m)
{
    assert(m);
    return &(m->time());
}
const char * 
HBCI_instituteMessage_subject(const HBCI_instituteMessage *m)
{
    assert(m);
    return m->subject().c_str();
}
const char *
HBCI_instituteMessage_text(const HBCI_instituteMessage *m)
{
    assert(m);
    return m->text().c_str();
}

int HBCI_instituteMessage_country(const HBCI_instituteMessage *m)
{
    assert(m);
    return m->country();
}

const char *
    HBCI_instituteMessage_bankCode(const HBCI_instituteMessage *m)
{
    assert(m);
    return m->bankCode().c_str();
}

int HBCI_instituteMessage_read(const HBCI_instituteMessage *m)
{
    assert(m);
    return m->read();
}
void HBCI_instituteMessage_setRead(HBCI_instituteMessage *m, int b)
{
    assert(m);
    m->setRead(b);
}

void *
list_HBCI_instituteMessage_foreach (const list_HBCI_instituteMessage *listm, 
				    list_HBCI_instituteMessage_cb func,
				    void *user_data)
{
    assert(listm);
    assert(func);
    list<HBCI::instituteMessage>::const_iterator iter, end;
    void *ret = 0l;

    end = listm->end();
    for ( iter = listm->begin(); iter != end; iter++ ) {
	ret = (*func)( const_cast<HBCI::instituteMessage*>(&(*iter)), 
		       user_data);
	if (ret)
	    break;
    }
    return ret;
}
