/***************************************************************************
 $RCSfile: bpdjob.h,v $
                             -------------------
    cvs         : $Id: bpdjob.h,v 1.6 2003/01/29 14:44:32 cstim Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

/** @file bpdjob.h 
 * @short Definitions of HBCI::bpdJob and @ref HBCI_bpdJob*/

#ifndef BPDJOB_H
#define BPDJOB_H

#ifdef __cplusplus
namespace HBCI {
  class bpdJob;
}

#include <string>
using namespace std;

namespace HBCI {

/**
 * @short Internal bank parameter data that describes a HBCI job.
 *
 * Author of original code: Fabian Kaiser<fabian.kaiser@gmx.de>
 * Adapted to new Medium etc: Martin Preuss<openhbci@aquamaniac.de>
 */
class DLLIMPORT bpdJob {
    friend class SEGSupportedJob;
private:
    string _segmentCode;
    int _segmentVersion;
    int _jobsPerMessage;
    int _minSigCount;
    string _parameter;

public:
    bpdJob();
    ~bpdJob();

    /**
     * Create human readable string containing information about this
     * BPD job.
     */ 
    string dumpToString() const;

    /** The job-code (HKSAL, KHUMB...) */
    const string &segmentCode() const { return _segmentCode;};
    void setSegmentCode(const string &s) {_segmentCode=s;};

    /** The HBCI-segment-version */
    int segmentVersion() const { return _segmentVersion;};
    void setSegmentVersion(int i) { _segmentVersion=i;};

    /** How many jobs of this kind can max. be included in one message */
    int jobsPerMessage() const { return _jobsPerMessage;};
    void setJobsPerMessage(int i) { _jobsPerMessage=i;};

    /** Min. number of users that have to sign a job of this kind */
    int minSigCount() const { return _minSigCount;};
    void setMinSigCount(int i) { _minSigCount=i;};

    /** Job-parameter */
    const string &parameter() const { return _parameter;};
    void setParameter(const string &s) { _parameter=s;};

};

} /* namespace HBCI */

typedef struct HBCI::bpdJob HBCI_bpdJob;
extern "C" {
#else /* __cplusplus */
typedef struct HBCI_bpdJob HBCI_bpdJob;
#endif /* __cplusplus */

    extern const char*HBCI_bpdJob_segmentCode(const HBCI_bpdJob *j);
    extern int HBCI_bpdJob_jobsPerMessage(const HBCI_bpdJob *j);
    extern int HBCI_bpdJob_segmentVersion(const HBCI_bpdJob *j);
    extern const char *HBCI_bpdJob_parameter (const HBCI_bpdJob *j);
    
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif


