/* unblockableEffect.h
 */
#ifndef _UNBLOCKABLEEFFECT_H
#define _UNBLOCKABLEEFFECT_H

#include "osl/state/numEffectState.h"
#include "osl/container/pieceVector.h"
#include "osl/eval/pieceEval.h"
#include "osl/boardTable.h"
#include "osl/ptypeTraits.h"
namespace osl
{
  namespace effect_util
  {
    struct UnblockableEffect
    {
      /**
       * from にあるptypeoからunblockableな利きで届く敵の駒を
       * おいしい順にoutに格納
       */
      static int find(const NumEffectState& state,
		       PtypeO ptypeo, Position from, 
		       PieceVector& supported,
		       PieceVector& unsupported)
      {
	const int move_mask = Ptype_Table.getMoveMask(getPtype(ptypeo));
	const Player player = getOwner(ptypeo);
	const int attacker_value = abs(eval::PieceEval::captureValue(ptypeo));
	for (int i=DIRECTION_MIN; i<=DIRECTION_MAX; ++i)
	{
	  if (! (move_mask & (1<<i)))
	    continue;
	  const Direction dir = static_cast<Direction>(i);
	  const Position to
	    = Board_Table.nextPosition(player, from, dir);
	  const Piece target = state.getPieceAt(to);
	  if(!target.isOnBoardByOwner(alt(player)))
	    continue;
	  if (state.hasEffectBy(alt(player), to))
	  {
	    if (abs(eval::PieceEval::captureValue(target.ptypeO()))
		> attacker_value)
	      supported.push_back(target);
	  }
	  else
	  {
	    unsupported.push_back(target);
	  }
	}
	return attacker_value;
      }
    };
    
  } // namespace effect_util
} // namespace osl

#endif /* _UNBLOCKABLEEFFECT_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
