/**
 * defenseKing.h
 */
#ifndef EVAL_ENDGAME_DEFENSEKING_H
#define EVAL_ENDGAME_DEFENSEKING_H

#include "osl/eval/endgame/kingPieceTable.h"
#include "osl/state/simpleState.h"

namespace osl
{
  namespace eval
  {
    namespace endgame
    {
      /**
       * 玉の位置*守備駒の位置*ptype
       */
      class DefenseKing
      {
	struct Table : public KingPieceTable
	{
	  Table();
	};
	static const Table table;
      public:
	static int valueOf(const Piece king, const Piece defender)
	{
	  return valueOf(king, defender.ptypeO(), defender.position());
	}
	static int valueOf(Piece king, PtypeO ptypeo, Position position)
	{
	  assert(king.ptype() == KING);
	  if (getOwner(ptypeo) != king.owner())
	    return 0;
	  return table.valueOf(king.position(), king.owner(), 
			       position, getPtype(ptypeo));
	}
      };
    } // namespace endgame
  } // namespace endgame
} // namespace osl

#endif /* EVAL_ENDGAME_DEFENSEKING_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; coding:utf-8
// ;;; End:
