/* piecePairWithStand.h
 */
#ifndef EVAL_PPAIR_PIECEPAIRWITHSTAND_H
#define EVAL_PPAIR_PIECEPAIRWITHSTAND_H

#include "osl/eval/ppair/piecePairEval.h"
#include "osl/eval/pieceEval.h"

namespace osl
{
  namespace eval
  {
    namespace ppair
    {
      /**
       * 持駒の点数は表以外で管理するフレームワーク.  
       * 
       * (持駒の点数を表に書き込むと，同じ種類の駒を複数もっていると問
       * 題が起こるため)
       */
      template <class Table>
      class PiecePairWithStand
	: public PiecePairEval<PiecePairWithStand<Table>,Table>
      {
      public:
	static int standBonus(PtypeO ptypeo)
	{
	  assert(isBasic(getPtype(ptypeo)));
	  if (isMajorBasic(getPtype(ptypeo)))
	    return Ptype_Eval_Table.value(newPtypeO(getOwner(ptypeo), PAWN));
	  return 0;
	}
	static int standBonus(const SimpleState& state);

	typedef PiecePairEval<PiecePairWithStand<Table>, Table> base_t;
	explicit PiecePairWithStand(const SimpleState& state);
      protected:
	~PiecePairWithStand() {}
      public:
	static int diffAfterDropMove(const SimpleState& state,Position to,PtypeO ptypeo)
	{
	  const int bonus = standBonus(ptypeo);
	  return base_t::diffAfterDropMove(state,to,ptypeo) - Ptype_Eval_Table.value(ptypeo) - bonus;
	}
	static int diffAfterCaptureMove(const SimpleState& state,
					Position from, Position to, 
					PtypeO victim,int promote_mask)
	{
	  const PtypeO captured = osl::captured(victim);
	  const int bonus = standBonus(captured);
	  return base_t::diffAfterCaptureMove(state,from,to,victim,promote_mask) 
	    + Ptype_Eval_Table.value(captured) + bonus;
	}
	static int diffWithUpdate(const SimpleState& new_state, Move last_move)
	{
	  int diff = base_t::diffWithUpdate(new_state, last_move);
	  if (last_move.isDrop()) {
	    const int bonus = standBonus(last_move.ptypeO());
	    return diff - Ptype_Eval_Table.value(last_move.ptypeO()) - bonus;
	  }
	  if (last_move.capturePtype() != PTYPE_EMPTY) {
	    const PtypeO captured = osl::captured(last_move.capturePtypeO());
	    const int bonus = standBonus(captured);
	    return diff + Ptype_Eval_Table.value(captured) + bonus;
	  }
	  return diff;
	}
	static void setValues(const SimpleState&, container::PieceValues&);
      };
      
    } // namespace ppair
  } // namespace eval
} // namespace osl


#endif /* EVAL_PPAIR_PIECEPAIRWITHSTAND_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
