/* see.h
 */
#ifndef _SEE_H
#define _SEE_H

#include "osl/state/numEffectState.h"
#include "osl/container/ptypeOPositionVector.h"
namespace osl
{
  namespace eval
  {
    struct See
    {
      static int see(const NumEffectState& state, Move move,
		     const PieceMask& my_pin=PieceMask(), const PieceMask& op_pin=PieceMask());

      // public for test
      template <Player P>
      static int seeInteral(const NumEffectState& state, Move move,
			    const PieceMask& my_pin, const PieceMask& op_pin);
      template <Player P>
      static void findEffectPieces(const NumEffectState& state, Position effect_to,
				   const PieceMask& my_pin, const PieceMask& op_pin,
				   PtypeOPositionVector& my_pieces, PtypeOPositionVector& op_pieces);
      template <osl::Player P>
      static void findEffectPiecesAfterMove(const NumEffectState& state, Move move,
					    const PieceMask& my_pin, const PieceMask& op_pin,
					    PtypeOPositionVector& my_pieces, PtypeOPositionVector& op_pieces);
      static void findAdditionalPieces(const NumEffectState& state, Player attack, Position target,
				       Position direct_attack_from,
				       PtypeOPositionVector& out);
      /**
       * PtypeOPositionVector をもとに取り返し値を計算する
       * @param P alt(P) からの取り返し
       * @param target ここに関する取り返し
       * @param ptypeo target にあると想定される駒
       */
      template <Player P>
      static int computeValue(Position target, PtypeO ptypeO, 
			      const PtypeOPositionVector& my_pieces, 
			      const PtypeOPositionVector& op_pieces);
      struct StorePtypeO;
      struct FindEffectMore;

    };
  };
  using eval::See;
}

#endif /* _SEE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
