/* carray2d.h
 */
#ifndef _CARRAY2D_H
#define _CARRAY2D_H
#include "osl/player.h"
#include <algorithm>
#include <cstddef>
#include <cassert>

namespace osl
{
  namespace misc
  {
  template <typename T, size_t Capacity2>
  struct CArray2dProxy
  {
    T* a;
    explicit CArray2dProxy(T *ia) : a(ia)
    {
    }
    T& operator[](size_t j) const
    {
      assert(j < Capacity2);
      return a[j];
    }
    T& operator[] (Player p) const
    {
      return operator[](playerToIndex(p));
    }
  };

  /**
   * CArray の2次元版
   *
   * [][] でアクセスすると普通の2次元配列とは生成されるコードがちょっと違う
   * (see junk/multi_array.cc)
   * operator()(i,j) ならもちろん全く同じ
   */
  template <typename T, size_t Capacity1, size_t Capacity2>
  class CArray2d
  {
  public:
    /** {} による初期化を許すために public にしておく */
    T elements[Capacity1][Capacity2];
  public:
    typedef CArray2d<T,Capacity1,Capacity2> array_t;
    typedef CArray2dProxy<T,Capacity2> proxy_t;
    typedef CArray2dProxy<const T,Capacity2> const_proxy_t;
    
    const proxy_t operator[] (size_t i) 
    {
      assert(i < Capacity1);
      return proxy_t(elements[i]);
    }
    T& operator()(size_t i, size_t j)
    {
      assert(i < Capacity1);
      assert(j < Capacity2);
      return elements[i][j];
    }
    
    const const_proxy_t operator[] (size_t i) const
    {
      assert(i < Capacity1);
      return const_proxy_t(elements[i]);
    }
    
    void fill(T value=T()){
      for (size_t j=0; j<Capacity1; j++)
	std::fill(&elements[j][0], &elements[j][Capacity2], value);
    }
    const T& operator()(size_t i, size_t j) const
    {
      assert(i < Capacity1);
      assert(j < Capacity2);
      return elements[i][j];
    }

    static size_t capacity1() { return Capacity1; }
    static size_t capacity2() { return Capacity2; }
    static size_t size1() { return Capacity1; }
    static size_t size2() { return Capacity2; }

    const proxy_t operator[] (Player p)
    {
      return operator[](playerToIndex(p));
    }
    const const_proxy_t operator[] (Player p) const
    {
      return operator[](playerToIndex(p));
    }
  };
  } // namespace osl
  using misc::CArray2d;
} // namespace osl


#endif /* _FIXED_CAPACITY_VECTOR_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
