/* directCheck.h
 */
#ifndef _MOVE_CLASSIFIER_DIRECTCHECK_H
#define _MOVE_CLASSIFIER_DIRECTCHECK_H

#include "osl/ptype.h"
#include "osl/position.h"
#include "osl/player.h"
namespace osl
{
  namespace move_classifier
  {
    template <Player P>
    struct DirectCheck
    {
      template<class State>
      static bool isMember(const State& state, Ptype ptype, Position to)
      {
	/**
	 * 最初から王手ということはない．
	 */
	assert(!state.template hasEffectBy<P>(state.template getKingPosition<PlayerTraits<P>::opponent>()));
	/**
	 * stateを動かしていないので，fromにある駒がtoからの利きを
	 * blockすることは
	 * あるが，blockされた利きが王手だったとすると，動かす前から王手
	 * だったとして矛盾するのでOK
	 */
	return state.hasEffectFromTo(newPtypeO(P,ptype),to,
				     state.template getKingPosition<PlayerTraits<P>::opponent>());
      }

      template<class State>
      static bool isMember(const State& state, Ptype ptype, Position /*from*/, Position to)
      {
	return isMember(state, ptype, to);
      }
    };
  } // namespace move_classifier
} // namespace osl

#endif /* _DIRECTCHECK_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
