/* see.cc
 */
#include "osl/eval/see.h"
#include "osl/eval/pieceEval.h"
#include "osl/effect_action/storePtypeOPosition.h"

struct osl::eval::See::FindEffectMore
{
  PtypeOPositionVector *direct;
  PtypeOPositionVector *more;
  Position target;
  const NumEffectState *state;
  
  template<Player P,Ptype Type>
  void doActionPtype(Piece p) { store(p); }
  template<Player P>
  void doAction(Piece p, Position) { store(p);}
  void store(Piece p);  
};

void osl::eval::See::
FindEffectMore::store(Piece p)
{
  direct->push_back(std::make_pair(p.ptypeO(), p.position()));
  findAdditionalPieces(*state, p.owner(), target, p.position(), *more);
}

template <osl::Player P>
void osl::eval::
See::findEffectPieces(const NumEffectState& state, Position effect_to,
		      const PieceMask& /*my_pin*/, const PieceMask& op_pin,
		      PtypeOPositionVector& my_pieces, 
		      PtypeOPositionVector& op_pieces)
{
  typedef effect_action::StorePtypeOPosition store_t;
  store_t op_pieces_store(&op_pieces, effect_to);
  state.forEachEffect<PlayerTraits<P>::opponent,store_t>(effect_to, op_pieces_store, op_pin);
  if (op_pieces.empty())
    return;
  op_pieces.sort();
  if ((int)op_pieces.size() <= state.countEffect(P, effect_to))
  {
    store_t my_pieces_store(&my_pieces, effect_to);
    state.forEachEffect<P,store_t>(effect_to, my_pieces_store);	// ignore my_pin
    my_pieces.sort();
    return;
  }
  PtypeOPositionVector my_pieces_more;
  FindEffectMore action = { &my_pieces, &my_pieces_more, effect_to, &state };
  state.forEachEffect<P,FindEffectMore>(effect_to, action); // ignore my_pin
  my_pieces.sort();
  // sort my_pieces_more ?
  my_pieces.push_back(my_pieces_more.begin(), my_pieces_more.end());

  if (op_pieces.size() <= my_pieces.size())
    return;
  my_pieces_more.clear();
  // gather shadow efect
  for (size_t i=0; i<op_pieces.size(); ++i) {
    findAdditionalPieces(state, P, effect_to, op_pieces[i].second, my_pieces_more);
  }
  my_pieces.push_back(my_pieces_more.begin(), my_pieces_more.end());
}

template <osl::Player P>
void osl::eval::
See::findEffectPiecesAfterMove(const NumEffectState& state, Move move,
			       const PieceMask& /*my_pin*/, const PieceMask& op_pin,
			       PtypeOPositionVector& my_pieces, 
			       PtypeOPositionVector& op_pieces)
{
  const Position from=move.from();
  const Position to=move.to();

  typedef effect_action::StorePtypeOPosition store_t;
  store_t op_pieces_store(&op_pieces, to);
  state.forEachEffect<PlayerTraits<P>::opponent,store_t>(to, op_pieces_store, op_pin);
  if (op_pieces.empty())
    return;
  op_pieces.sort();

  const Piece moved = state.getPieceOnBoard(from);
  PieceMask ignore;		// here do not use my_pin to get optimistic result
  ignore.set(moved.number());
  if ((int)op_pieces.size() < state.countEffect(P, to))
  {
    store_t my_pieces_store(&my_pieces, to);
    state.forEachEffect<P,store_t>(to, my_pieces_store, ignore);
    my_pieces.sort();
    return;
  }

  PtypeOPositionVector my_pieces_more;
  findAdditionalPieces(state, move.player(), to, moved.position(), my_pieces_more);

  FindEffectMore action = { &my_pieces, &my_pieces_more, to, &state };
  state.forEachEffect<P,FindEffectMore>(to, action, ignore);
  my_pieces.sort();
  // sort my_pieces_more ?
  my_pieces.push_back(my_pieces_more.begin(), my_pieces_more.end());

  if (op_pieces.size() < my_pieces.size())
    return;
  my_pieces_more.clear();
  // gather shadow efect
  for (size_t i=0; i<op_pieces.size(); ++i) {
    findAdditionalPieces(state, P, to, op_pieces[i].second, my_pieces_more);
  }
  my_pieces.push_back(my_pieces_more.begin(), my_pieces_more.end());
}

template <osl::Player P>
int osl::eval::
See::computeValue(Position target, PtypeO ptypeO, 
		  const PtypeOPositionVector& my_pieces, 
		  const PtypeOPositionVector& op_pieces)
{
  int val = 0;
  CArray<int,Piece::SIZE> vals;
  const Player Opponent = PlayerTraits<P>::opponent;
  size_t i;
  for (i=0;i<op_pieces.size();i++)
  {
    vals[i*2]=val;
    // opponent moves
    val+=Ptype_Eval_Table.captureValue(ptypeO);
    {
      ptypeO = op_pieces[i].first;
      const bool promotable = canPromote(ptypeO) 
	&& (target.canPromote<Opponent>() 
	    || op_pieces[i].second.canPromote<Opponent>());
      if (promotable)
      {
	ptypeO=promote(ptypeO);
	val+=Ptype_Eval_Table.promoteValue(ptypeO);
      }
    }
    vals[i*2+1]=val;
    // my moves
    if (i>=my_pieces.size()){
      break;
    }
    val+=Ptype_Eval_Table.captureValue(ptypeO);
    {
      ptypeO=my_pieces[i].first;
      const bool promotable = canPromote(ptypeO) 
	&& (target.canPromote<P>() 
	    || my_pieces[i].second.canPromote<P>());
      if (promotable)
      {
	ptypeO=promote(ptypeO);
	val+=Ptype_Eval_Table.promoteValue(ptypeO);
      }
    }
  }
  for (int j=i-1;j>=0;j--)
  {
    val=EvalTraits<P>::max(val,vals[j*2+1]);
    val=EvalTraits<Opponent>::max(val,vals[j*2]);
  }
  return val;
}

template <osl::Player P>
int osl::eval::See::seeInteral(const NumEffectState& state, Move move,
			       const PieceMask& my_pin, const PieceMask& op_pin)
{
  assert(state.isAlmostValidMove(move));
  
  const Position from=move.from();
  const Position to=move.to();
  PtypeOPositionVector my_pieces, op_pieces;
  int val=0; 
  if (from.isPieceStand())
  {
    findEffectPieces<P>(state, to, my_pin, op_pin, my_pieces, op_pieces);
  }
  else
  {
    val = PieceEval::diffWithMove(state,move);
    findEffectPiecesAfterMove<P>(state, move, my_pin, op_pin, my_pieces, op_pieces);
  }
  if (op_pieces.empty())
    return val;
  return val + computeValue<P>(to, move.ptypeO(), my_pieces, op_pieces);  
}

int osl::eval::See::see(const NumEffectState& state, Move move,
			const PieceMask& my_pin, const PieceMask& op_pin)
{
  if (move.player() == BLACK)
    return seeInteral<BLACK>(state, move, my_pin, op_pin);
  else
    return -seeInteral<WHITE>(state, move, my_pin, op_pin);
}

void osl::eval::
See::findAdditionalPieces(const NumEffectState& state, Player attack, 
			  Position target,
			  Position from,
			  PtypeOPositionVector& out)
{
  const Offset32 diff32 = Offset32(from, target);
  const Offset step = Board_Table.getShortOffsetNotKnight(diff32);
  if (step.zero())
    return;
  // 利きが8方向の場合
  Piece candidate=state.nextPiece(from, step);
  if (! candidate.isPiece())
    return;
  const Offset32 diff_reverse = Offset32(target,candidate.position());
  for (; candidate.isPiece(); 
       candidate=state.nextPiece(candidate.position(), step))
  {
    if (candidate.owner() != attack)
      return;
    const EffectContent effect 
      = Ptype_Table.getEffect(candidate.ptypeO(), diff_reverse);
    if (! effect.hasEffect())
      return;
    out.push_back(std::make_pair(candidate.ptypeO(), candidate.position()));
  } 
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
