/* gnuShogiClient.cc
 */
#include "osl/game_playing/gnuShogiClient.h"
#include "osl/game_playing/gameState.h"
#include "osl/game_playing/csaLogger.h"
#include "osl/game_playing/csaStopwatch.h"
#include "osl/search/moveWithComment.h"
#include "osl/record/psn.h"
#include "osl/sennichite.h"
#include <iostream>
#include <sstream>

osl::game_playing::
GnuShogiClient::GnuShogiClient(ComputerPlayer *black, ComputerPlayer *white,
			       CsaLogger *l,
			       std::istream& is, std::ostream& os)
  : CuiClient(black, white, l, is, os)
{
}

osl::game_playing::
GnuShogiClient::~GnuShogiClient()
{
}

void osl::game_playing::
GnuShogiClient::readAndProcessCommand()
{
  CsaStopwatch timer;
  std::string line;
  std::getline(is, line);
  const long op_think_time = timer.read();
  if (! is) {
    logger->inputError("(stream not available)");
    throw EndGame();
  }

  if (line == "undo")
  {
    logger->popMove();
    popMove();
    return;
  }
  if (line == "force")
  {
    setComputerPlayer(BLACK, false);
    setComputerPlayer(WHITE, false);
    logger->breakGame();
    return;
  }
  if (line == "black") {
    setComputerPlayer(BLACK, true);
    setComputerPlayer(WHITE, false);
    return;
  }
  if (line == "white") {
    setComputerPlayer(BLACK, false);
    setComputerPlayer(WHITE, true);
    return;
  }
  if (line == "go" && ! isComputer(BLACK)) {
    const Player turn = state->state().getTurn();
    setComputerPlayer(turn, true);
    setComputerPlayer(alt(turn), false);
    return;
  }
  if (line == "new" || line == "beep" || line == "random")
    return; // XXX
  if (line.find("time") == 0 || line.find("otime") == 0) {
    if (line.find("time") == 0) {
      std::istringstream ss(line);
      std::string dummy;
      int time;
      ss >> dummy >> time;
      setTimeLeft(time/100, time/100);
    }
    std::cerr << line << "\n";
    return;
  }
  
  if (line.size() < 4)
    goto ignore;
  if (isdigit(line[0]) || line[1] == '*') // FIXME
  {
    const Move op_move=record::psn::strToMove(line, state->state());
    
    if (state->isIllegal(op_move))
    {
      os << "Illegal move\n";
      logger->inputError(line.c_str());
      return;
    }
    const Sennichite result = pushMove(MoveWithComment(op_move), op_think_time);
    if (! result.isNormal())
    {
      if (result == Sennichite::BLACK_LOSE())
	os << "White mates!\n";
      else if (result == Sennichite::WHITE_LOSE())
	os << "Black mates!\n";
      else 
	os << "Black mates!\n";	// does xshogi know draw?
      setComputerPlayer(BLACK, false);
      setComputerPlayer(WHITE, false);
      logger->endByRepetition(result);
      throw EndGame();
    }
    return;
  }
ignore:
  std::cerr << line << "\n";
  std::string comment = "ignored line " + line;
  logger->writeComment(comment.c_str());
}

void osl::game_playing::
GnuShogiClient::processComputerMove(const MoveWithComment& selected, 
				    int my_think_time)
{
  const Move best_move = selected.move;
  const Player turn = state->state().getTurn();
  if ((! best_move.isNormal())
      || (state->isIllegal(best_move)))
  {
    os << ((alt(turn) == BLACK) ? "Black" : "White")
	      << " mates!\n";
    logger->resign(turn);
    setComputerPlayer(BLACK, false);
    setComputerPlayer(WHITE, false);
    throw EndGame();
  }

  const int chess_moves = state->chessMoves();
  os << chess_moves << ". ... " << record::psn::show(best_move)
     << "  " << (time_keeper.timeLeft(turn) - my_think_time)*100
     << std::endl << std::flush;

  const Sennichite result = pushMove(selected, my_think_time);
  if (! result.isNormal())
  {
    if (result == Sennichite::BLACK_LOSE())
      os << "White mates!\n";
    else if (result == Sennichite::WHITE_LOSE())
      os << "Black mates!\n";
    else 
      os << "Black mates!\n";	// does xshogi know draw?
    setComputerPlayer(BLACK, false);
    setComputerPlayer(WHITE, false);
    logger->endByRepetition(result);
    throw EndGame();
  }
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
