/* kfendPredictor.cc
 */
#include "osl/threatmate/kfendPredictor.h"

bool osl::threatmate::KfendPredictor::predict(const NumEffectState& state, 
					      const Move move){
  const Player turn = alt(state.getTurn());
  const Position opKingPosition = state.getKingPosition(alt(turn));

  // Capture Piece
  if (move.capturePtype())
    return true;

  // Add Effect for King's Neighboring8
  if ( Neighboring8Direct::hasEffect(state, newPtypeO(turn, move.ptype()),
				     move.to(), opKingPosition) )
    return true;
  return false;
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
