/* pawnCheckmateMoves.t.cc
 */
#include "osl/checkmate/pawnCheckmateMoves.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class PawnCheckmateMovesTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(PawnCheckmateMovesTest);
  CPPUNIT_TEST(testPair);
  CPPUNIT_TEST_SUITE_END();
public:
  void testPair();
};

using namespace osl;
using namespace osl::checkmate;

CPPUNIT_TEST_SUITE_REGISTRATION(PawnCheckmateMovesTest);

void PawnCheckmateMovesTest::testPair()
{
  const Position from = Position(2,4);
  const Position to = Position(2,3);
  
  const Move p = Move(from, to, PPAWN, PTYPE_EMPTY, true, BLACK);
  const Move np = Move(from, to, PAWN, PTYPE_EMPTY, false, BLACK);
  CPPUNIT_ASSERT_EQUAL(np, p.unpromote());
  CPPUNIT_ASSERT(PawnCheckmateMoves::hasParingNoPromote(p));
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
