#include "osl/game_playing/weightTracer.h"
#include "osl/oslConfig.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::game_playing;

class WeightTracerTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(WeightTracerTest);
  CPPUNIT_TEST(testTop1);
  CPPUNIT_TEST(testTop2);
  CPPUNIT_TEST_SUITE_END();
public:
  void testTop1() 
  {
    osl::record::opening::WeightedBook book(osl::OslConfig::openingBook());
    osl::game_playing::DeterminateWeightTracer tracer(book, false, 1);
    const Move m76fu(Position(7,7),Position(7,6),PAWN,PTYPE_EMPTY,false,BLACK);

    for (int i=0; i<100; ++i)
    {
      CPPUNIT_ASSERT_EQUAL(m76fu, tracer.selectMove());
    }
  }

  void testTop2() 
  {
    osl::record::opening::WeightedBook book(osl::OslConfig::openingBook());
    osl::game_playing::DeterminateWeightTracer tracer(book, false, 2);
    const Move m76fu(Position(7,7),Position(7,6),PAWN,PTYPE_EMPTY,false,BLACK);
    const Move m26fu(Position(2,7),Position(2,6),PAWN,PTYPE_EMPTY,false,BLACK);

    for (int i=0; i<100; ++i)
    {
      const Move selected = tracer.selectMove();
      CPPUNIT_ASSERT(selected == m76fu || selected == m26fu);
    }
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(WeightTracerTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
