/* shouldPromoteFilter.t.cc
 */
#include "osl/move_action/shouldPromoteFilter.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class ShouldPromoteFilterTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(ShouldPromoteFilterTest);
  CPPUNIT_TEST(testCanIgnore);
  CPPUNIT_TEST_SUITE_END();
public:
  void testCanIgnore();
};
CPPUNIT_TEST_SUITE_REGISTRATION(ShouldPromoteFilterTest);

using namespace osl;
using namespace osl::move_action;

void ShouldPromoteFilterTest::testCanIgnore()
{
  CPPUNIT_ASSERT(! ShouldPromoteFilterBase<BLACK>::ignore(Position(1,4), Position(1,3), LANCE, false));
  CPPUNIT_ASSERT(ShouldPromoteFilterBase<BLACK>::ignore(Position(1,4), Position(1,2), LANCE, false));
  CPPUNIT_ASSERT(! ShouldPromoteFilterBase<BLACK>::ignore(Position(1,4), Position(1,3), PLANCE, false));
  CPPUNIT_ASSERT(! ShouldPromoteFilterBase<BLACK>::ignore(Position(1,4), Position(1,2), PLANCE, false));

  CPPUNIT_ASSERT(ShouldPromoteFilterBase<BLACK>::ignore(Position(7,7), Position(3,3), BISHOP, false));
  CPPUNIT_ASSERT(ShouldPromoteFilterBase<BLACK>::ignore(Position(2,7), Position(2,3), ROOK, false));
  CPPUNIT_ASSERT(! ShouldPromoteFilterBase<BLACK>::ignore(Position(7,7), Position(3,3), PBISHOP, false));
  CPPUNIT_ASSERT(! ShouldPromoteFilterBase<BLACK>::ignore(Position(2,7), Position(2,3), PROOK, false));

  CPPUNIT_ASSERT(! ShouldPromoteFilterBase<WHITE>::ignore(Position(1,4), Position(1,7), LANCE, false));
  CPPUNIT_ASSERT(ShouldPromoteFilterBase<WHITE>::ignore(Position(1,4), Position(1,8), LANCE, false));
  CPPUNIT_ASSERT(! ShouldPromoteFilterBase<WHITE>::ignore(Position(1,4), Position(1,7), PLANCE, false));
  CPPUNIT_ASSERT(! ShouldPromoteFilterBase<WHITE>::ignore(Position(1,4), Position(1,8), PLANCE, false));

  CPPUNIT_ASSERT(ShouldPromoteFilterBase<WHITE>::ignore(Position(7,7), Position(3,3), BISHOP, false));
  CPPUNIT_ASSERT(ShouldPromoteFilterBase<WHITE>::ignore(Position(2,7), Position(2,3), ROOK, false));
  CPPUNIT_ASSERT(! ShouldPromoteFilterBase<WHITE>::ignore(Position(7,7), Position(3,3), PBISHOP, false));
  CPPUNIT_ASSERT(! ShouldPromoteFilterBase<WHITE>::ignore(Position(2,7), Position(2,3), PROOK, false));
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:

