#include "osl/record/kanjiMove.h"
#include "osl/record/kanjiCode.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

#include "osl/apply_move/applyMove.h"

class KanjiMoveTest : public CppUnit::TestFixture {
  CPPUNIT_TEST_SUITE(KanjiMoveTest);
  CPPUNIT_TEST(testMove);
  CPPUNIT_TEST_SUITE_END();
 public:
  void testMove();
};

CPPUNIT_TEST_SUITE_REGISTRATION(KanjiMoveTest);

using namespace osl;
using namespace osl::record;
extern bool isShortTest;

void KanjiMoveTest::testMove()
{
  const static std::string str_b26fu     = K_BLACK_SIGN + K_R2 + K_K6 + K_PAWN;
  const static std::string str_w84fu     = K_WHITE_SIGN + K_R8 + K_K4 + K_PAWN;
  const static std::string str_b25fu     = K_BLACK_SIGN + K_R2 + K_K5 + K_PAWN;
  const static std::string str_w85fu     = K_WHITE_SIGN + K_R8 + K_K5 + K_PAWN;
  const static std::string str_b24fu     = K_BLACK_SIGN + K_R2 + K_K4 + K_PAWN;
  const static std::string str_wdofu     = K_WHITE_SIGN + K_ONAZI + K_SPACE + K_PAWN;
  const static std::string str_b58kimigi = K_BLACK_SIGN + K_R5 + K_K8 + K_GOLD + K_MIGI;
  
  KanjiMove kmove;
  NumEffectState state((SimpleState(HIRATE)));
  Move last_move;

  
  Move m26fu(Position(2,7), Position(2,6), PAWN, PTYPE_EMPTY, false, BLACK);
  CPPUNIT_ASSERT_EQUAL(m26fu, kmove.strToMove(str_b26fu, state, last_move));
  last_move = m26fu;
  ApplyMoveOfTurn::doMove(state, last_move);

  Move m84fu(Position(8,3), Position(8,4), PAWN, PTYPE_EMPTY, false, WHITE);
  CPPUNIT_ASSERT_EQUAL(m84fu, kmove.strToMove(str_w84fu, state, last_move));
  last_move = m84fu;
  ApplyMoveOfTurn::doMove(state, last_move);

  Move m25fu(Position(2,6), Position(2,5), PAWN, PTYPE_EMPTY, false, BLACK);
  CPPUNIT_ASSERT_EQUAL(m25fu, kmove.strToMove(str_b25fu, state, last_move));
  last_move = m25fu;
  ApplyMoveOfTurn::doMove(state, last_move);

  Move m85fu(Position(8,4), Position(8,5), PAWN, PTYPE_EMPTY, false, WHITE);
  CPPUNIT_ASSERT_EQUAL(m85fu, kmove.strToMove(str_w85fu, state, last_move));
  last_move = m85fu;
  ApplyMoveOfTurn::doMove(state, last_move);

  Move m24fu(Position(2,5), Position(2,4), PAWN, PTYPE_EMPTY, false, BLACK);
  CPPUNIT_ASSERT_EQUAL(m24fu, kmove.strToMove(str_b24fu, state, last_move));
  last_move = m24fu;
  ApplyMoveOfTurn::doMove(state, last_move);

  Move mdofu(Position(2,3), Position(2,4), PAWN, PAWN, false, WHITE);
  CPPUNIT_ASSERT_EQUAL(mdofu, kmove.strToMove(str_wdofu, state, last_move));
  last_move = mdofu;
  ApplyMoveOfTurn::doMove(state, last_move);

  Move m58ki(Position(4,9), Position(5,8), GOLD, PTYPE_EMPTY, false, BLACK);
  CPPUNIT_ASSERT_EQUAL(m58ki, kmove.strToMove(str_b58kimigi, state, last_move));
  last_move = m58ki;
  ApplyMoveOfTurn::doMove(state, last_move);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
