/* psn.t.cc
 */
#include "osl/record/psn.h"
#include "osl/state/simpleState.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class PsnTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(PsnTest);
  CPPUNIT_TEST(testMove);
  CPPUNIT_TEST(testShowXP);
  CPPUNIT_TEST_SUITE_END();
public:
  void testMove();
  void testShowXP();
};

CPPUNIT_TEST_SUITE_REGISTRATION(PsnTest);

using namespace osl;
using namespace osl::record;

void PsnTest::testMove()
{
  SimpleState state(HIRATE);
  const Move m76fu = Move(Position(7,7), Position(7,6), PAWN, 
			     PTYPE_EMPTY, false, BLACK);
  const std::string psn76fu = "7g7f";
  const Move m76fu2 = psn::strToMove(psn76fu, state);
  CPPUNIT_ASSERT_EQUAL(m76fu, m76fu2);

  const std::string psn76fu2 = psn::show(m76fu);
  CPPUNIT_ASSERT_EQUAL(psn76fu, psn76fu2);
}

void PsnTest::testShowXP()
{
  const Move m11kakunari = Move(Position(7,7), Position(1,1), PBISHOP, 
				LANCE, true, BLACK);
  const std::string psn11kakunari = "7gx1a+";
  CPPUNIT_ASSERT_EQUAL(psn11kakunari, psn::showXP(m11kakunari));

  const Move m11kakunarazu = Move(Position(7,7), Position(1,1), BISHOP, 
				LANCE, false, BLACK);
  const std::string psn11kakunarazu = "7gx1a=";
  CPPUNIT_ASSERT_EQUAL(psn11kakunarazu, psn::showXP(m11kakunarazu));

  const Move m11kin = Move(Position(2,2), Position(1,1), GOLD, 
			   LANCE, false, BLACK);
  const std::string psn11kin = "2bx1a";
  CPPUNIT_ASSERT_EQUAL(psn11kin, psn::showXP(m11kin));

  const Move m11ou = Move(Position(2,2), Position(1,1), KING, 
			   LANCE, false, BLACK);
  const std::string psn11ou = "2bx1a";
  CPPUNIT_ASSERT_EQUAL(psn11ou, psn::showXP(m11ou));

  const Move bpass = Move::PASS(BLACK);
  const std::string psnpass = "pass";
  CPPUNIT_ASSERT_EQUAL(psnpass, psn::showXP(bpass));

  const Move wpass = Move::PASS(WHITE);
  CPPUNIT_ASSERT_EQUAL(psnpass, psn::showXP(wpass));
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
