// dominanceCheck.t.cc
#include "osl/search/dominanceCheck.h"
#include "osl/record/csaRecord.h"
#include "osl/record/csaString.h"
#include "osl/state/numEffectState.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::search;

class SearchDominanceCheck : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(SearchDominanceCheck);
  // ここに(テストのための)メソッドを列挙する．
  CPPUNIT_TEST(testLoseBlack);
  CPPUNIT_TEST(testLoseWhite);
  CPPUNIT_TEST(testWinBlack);
  CPPUNIT_TEST(testWinWhite);
  CPPUNIT_TEST_SUITE_END();
public:
  void confirmDetectionInLast(HashKey initial, const vector<Move>& moves,
			      DominanceCheck::Result);
  void testLoseBlack();
  void testLoseWhite();
  void testWinBlack();
  void testWinWhite();
};

CPPUNIT_TEST_SUITE_REGISTRATION(SearchDominanceCheck);

void SearchDominanceCheck::
confirmDetectionInLast(HashKey key, const vector<Move>& moves,
		       DominanceCheck::Result result)
{
  HashKeyStack history;
  for (size_t i=0; i<moves.size(); ++i)
  {
    CPPUNIT_ASSERT_EQUAL(DominanceCheck::NORMAL,
			 DominanceCheck::detect(history, key));
    history.push(key);
    key = key.newHashWithMove(moves[i]);
  }
  CPPUNIT_ASSERT_EQUAL(result, DominanceCheck::detect(history, key));
}

void SearchDominanceCheck::testLoseBlack()
{
  const char *test_record_str = 
    "P1 *  *  *  *  *  *  * -KY-OU \n"
    "P2 *  *  *  *  *  *  * -KY+TO\n"
    "P3 *  *  *  *  *  *  * -KY * \n"
    "P4 *  *  *  *  *  *  *  *  * \n"
    "P5 *  *  *  *  *  *  * +KE * \n"
    "P6 *  *  *  *  *  *  *  *  * \n"
    "P7 *  *  *  *  *  *  *  *  * \n"
    "P8 *  *  *  *  *  *  *  *  * \n"
    "P9+OU *  *  *  *  *  *  *  * \n"
    "P+00FU\n"
    "P-00AL\n"
    "-\n"
    "-1112OU\n"
    "+0013FU\n"
    "-1211OU\n"
    "+1312TO\n";
  CsaString test_record(test_record_str);
  
  NumEffectState state(test_record.getInitialState());
  const vector<Move>& moves = test_record.getRecord().getMoves();
  confirmDetectionInLast(HashKey(state), moves, DominanceCheck::LOSE);
}

void SearchDominanceCheck::testLoseWhite()
{
  const char *test_record_str = 
    "P1 *  *  *  *  *  *  *  * -OU\n"
    "P2 *  *  *  *  *  *  *  *  * \n"
    "P3 *  *  *  *  *  *  *  *  * \n"
    "P4 *  *  *  *  *  *  *  *  * \n"
    "P5 * -KE *  *  *  *  *  *  * \n"
    "P6 *  *  *  *  *  *  *  *  * \n"
    "P7 * +KE *  *  *  *  *  *  * \n"
    "P8-TO+KY *  *  *  *  *  *  * \n"
    "P9+OU+KY *  *  *  *  *  *  * \n"
    "P+00FU\n"
    "P-00AL\n"
    "+\n"
    "+9998OU\n"
    "-0097FU\n"
    "+9899OU\n"
    "-9798TO\n";
  CsaString test_record(test_record_str);
  
  NumEffectState state(test_record.getInitialState());
  const vector<Move>& moves = test_record.getRecord().getMoves();
  confirmDetectionInLast(HashKey(state), moves, DominanceCheck::LOSE);
}

void SearchDominanceCheck::testWinWhite()
{
  const char *test_record_str = 
    "P1 *  *  *  *  *  *  * -KY-OU \n"
    "P2 *  *  *  *  *  *  * -KY * \n"
    "P3 *  *  *  *  *  *  * -KY+FU\n"
    "P4 *  *  *  *  *  *  *  *  * \n"
    "P5 *  *  *  *  *  *  * +KE * \n"
    "P6 *  *  *  *  *  *  *  *  * \n"
    "P7 *  *  *  *  *  *  *  *  * \n"
    "P8 *  *  *  *  *  *  *  *  * \n"
    "P9+OU *  *  *  *  *  *  *  * \n"
    "P+00FU\n"
    "P-00AL\n"
    "+\n"
    "+1312TO\n"
    "-1112OU\n"
    "+0013FU\n"
    "-1211OU\n";
  CsaString test_record(test_record_str);
  
  NumEffectState state(test_record.getInitialState());
  const vector<Move>& moves = test_record.getRecord().getMoves();
  confirmDetectionInLast(HashKey(state), moves, DominanceCheck::WIN);
}

void SearchDominanceCheck::testWinBlack()
{
  const char *test_record_str = 
    "P1 *  *  *  *  *  *  *  * -OU\n"
    "P2 *  *  *  *  *  *  *  *  * \n"
    "P3 *  *  *  *  *  *  *  *  * \n"
    "P4 *  *  *  *  *  *  *  *  * \n"
    "P5 * -KE *  *  *  *  *  *  * \n"
    "P6 *  *  *  *  *  *  *  *  * \n"
    "P7-FU+KE *  *  *  *  *  *  * \n"
    "P8 * +KY *  *  *  *  *  *  * \n"
    "P9+OU+KY *  *  *  *  *  *  * \n"
    "P+00FU\n"
    "P-00AL\n"
    "-\n"
    "-9798TO\n"
    "+9998OU\n"
    "-0097FU\n"
    "+9899OU\n";
  CsaString test_record(test_record_str);
  
  NumEffectState state(test_record.getInitialState());
  const vector<Move>& moves = test_record.getRecord().getMoves();
  confirmDetectionInLast(HashKey(state), moves, DominanceCheck::WIN);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
