#include "osl/search/dualThreatmateState.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::search;

class SearchDualThreatmateStateTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(SearchDualThreatmateStateTest);
  CPPUNIT_TEST(testConstruction);
  CPPUNIT_TEST(testTransition);
  CPPUNIT_TEST_SUITE_END();
public:
  void testConstruction() {
    DualThreatmateState s;
    CPPUNIT_ASSERT(s.status(BLACK).isUnknown());
    CPPUNIT_ASSERT(s.status(WHITE).isUnknown());
  }
  void testTransition() {
    DualThreatmateState t;
    const Move bmove(Position(5,2),GOLD,BLACK);
    const Move wmove(Position(5,8),GOLD,WHITE);

    t.setThreatmate(BLACK, bmove); // 先手番、先手玉に詰めろ
    CPPUNIT_ASSERT(t.isThreatmate(BLACK));
    CPPUNIT_ASSERT(! t.isThreatmate(WHITE));
    CPPUNIT_ASSERT_EQUAL(bmove, t.threatmateMove(BLACK));

    DualThreatmateState mc;
    mc.updateInLock(BLACK, &t, false);
    CPPUNIT_ASSERT(mc.mayHaveCheckmate(BLACK));
    CPPUNIT_ASSERT(mc.status(WHITE).isUnknown());

    mc.setThreatmate(WHITE, wmove); // さっきの先手の指しては詰めろだった
    CPPUNIT_ASSERT(mc.mayHaveCheckmate(BLACK));
    CPPUNIT_ASSERT(mc.isThreatmate(WHITE));
    
    DualThreatmateState ct;
    ct.updateInLock(WHITE, &mc, true);	// 後手が王手

    DualThreatmateState cte;
    cte.updateInLock(BLACK, &ct, false);	// 先手が逃げる

    CPPUNIT_ASSERT(cte.status(BLACK).isUnknown());
    CPPUNIT_ASSERT(cte.maybeThreatmate(WHITE));
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(SearchDualThreatmateStateTest);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
