#include "osl/search/searchRecorder.h"
#include "osl/moveLogProb.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

class SearchRecorderTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(SearchRecorderTest);
  CPPUNIT_TEST(testWrite);
  CPPUNIT_TEST_SUITE_END();
public:
  void testWrite();
};

CPPUNIT_TEST_SUITE_REGISTRATION(SearchRecorderTest);

using namespace osl;

void SearchRecorderTest::testWrite()
{
  extern bool isShortTest;
  const bool verbose = ! isShortTest;

  SearchRecorder recorder("SearchRecorderTest.log");
  MoveLogProb m(Move(Position(6,5),Position(2,1),PBISHOP,KNIGHT,true,BLACK),
		7777777);
  recorder.tryMove(m, 111, 11111);
  recorder.recordValue(m, 222, true, 22222);
  recorder.recordTopLevelLowFail(m, 333);
  recorder.recordTopLevelHighFail(m, 444);
  recorder.startSearch(555);
  recorder.finishSearch(m.getMove(), 1.0, verbose);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
