#include "osl/container/ptypeOSquareVector.h"
#include "osl/eval/pieceEval.h"
#include <algorithm>

namespace osl
{
  struct PtypeOSquareLessThan
  {
    bool operator()(const std::pair<PtypeO,Square>& l,
		    const std::pair<PtypeO,Square>& r)
    {
      const int vall = abs(eval::Ptype_Eval_Table.captureValue(l.first));
      const int valr = abs(eval::Ptype_Eval_Table.captureValue(r.first));
      if (vall != valr)
	return vall < valr;
      return l.second.uintValue() < r.second.uintValue();
    }
  };

  void container::PtypeOSquareVector::sort()
  {
    std::sort(begin(),end(),PtypeOSquareLessThan());
  }

}
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
