/* usiReporter.h
 */
#ifndef OSL_USIREPORTER_H
#define OSL_USIREPORTER_H
#include "osl/search/searchMonitor.h"
namespace osl
{
  namespace search
  {
    struct UsiReporter
    {
      static void newDepth(int depth);
      static void showPV(int depth, size_t node_count, double elapsed, int value, Move cur, const Move *first, const Move *last, bool ignore_silent=false);
      static void rootMove(Move cur, bool allow_frequent_display=false);
      static void timeInfo(size_t node_count, double elapsed);
      static void hashInfo(double ratio);
    };

    class UsiMonitor : public SearchMonitor
    {
      Move last_root_move;
    public:
      ~UsiMonitor();
      void newDepth(int depth);
      void showPV(int depth, size_t node_count, double elapsed, int value, Move cur, const Move *first, const Move *last);
      void rootMove(Move cur);
      void rootFirstMove(Move cur);
      void timeInfo(size_t node_count, double elapsed);
      void hashInfo(double ratio);
      void rootForcedMove(Move the_move);
      void rootLossByCheckmate();
    };
  }
}


#endif /* OSL_USIREPORTER_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
