/* liberty8Table.h
 */
#ifndef _LIBERTY8TABLE_H
#define _LIBERTY8TABLE_H
#include "osl/ptype.h"
#include "osl/ptypeTable.h"
#include "osl/container/nearMask.h"
#include "osl/misc/carray.h"
#include "osl/misc/carray2d.h"
#include <iosfwd>
namespace osl
{
  namespace effect
  {
  /**
   * 8近傍のどこに長い利きを持つか.
   * 最大3近傍に利きを持つ可能性があるが，攻め方に最も近い近傍への
   * オフセットも返す
   */
  struct LongEffect8
  {
    friend std::ostream& operator<<(std::ostream& os,LongEffect8 const& longEffect); 
    /**
     * こちらの素直な実装の方が速いようだ。
     */
    char smallOffset;
    CArray<unsigned char,3> mask;
  public:
    LongEffect8():smallOffset(0){
      mask[0]=mask[1]=mask[2]=0;
    }
    Offset getOffset() const{
      return Offset::makeDirect(smallOffset);
    }
    void setOffset(Offset o){
      smallOffset=static_cast<char>(o.intValue());
    }
    unsigned int getMask(int index) const{
      return static_cast<unsigned int>(mask[index]);
    }
    void setMask(int index,unsigned int val) {
      mask[index]=static_cast<unsigned char>(val);
    }
  };
    /**
     * Liberty8を得るために使うテーブル.
     * 短い利きに関しては，ptypeと座標の差でテーブルを引けば得られる．
     * 長い利きはgetLongEffectで得るが，
     * 飛車に関してはそれに加えてgetLongEffect2も使う.
     */
  class Liberty8Table{
    CArray<CArray<unsigned char,Offset32::SIZE>,PTYPE_SIZE> shortMask;
    CArray2d<LongEffect8,PTYPE_SIZE,Offset32::SIZE> longEffect;
    CArray<LongEffect8,Offset32::SIZE> longEffect2;
    LongEffect8 longEffectOf(Ptype ptype,int dx,int dy);
  public:
    Liberty8Table();
    /**
     * P側のptypeのfromにある駒がtoにある Pの反対側の駒の周囲
     * にどういう短い利き(長い利きの隣で利きを伸ばすと8近傍内に
     * 伸ばせる場合を除く)を持つかを返す
     * directでなくても,targetの駒を挟んだ反対側ならOKとする
     * 利きがあるところは0でそうでないところは1とする
     */
     template<Player P>
    NearMask getShortMask(Ptype ptype,Square from, Square to) const{
      assert(isValid(ptype) && from.isOnBoard() && to.isOnBoard());
      Offset32 offset32=Offset32(to,from).blackOffset32<P>();
      return NearMask::makeDirect(shortMask[ptype][offset32.index()]);
    }
    /**
     * P側のptypeのfromにある駒がtoにある Pの反対側の駒の周囲
     * にどういう長い利き(長い利きの隣で利きを伸ばすと8近傍内に
     * 伸ばせる場合を含む)を持つかを返す
     */
    template<Player P>
    LongEffect8 getLongEffect(Ptype ptype,Square from, Square to) const{
      assert(isValid(ptype) && from.isOnBoard() && to.isOnBoard());
      assert(Ptype_Table.hasLongMove(ptype));
      Offset32 offset32=Offset32(to,from).blackOffset32<P>();
      return longEffect[ptype][offset32.index()];
    }
    /**
     * 飛車, 龍が王の斜めの位置にいて, 両方向に長い利きを持つ場合の
     * テーブル
     */
    template<Player P>
    LongEffect8 getLongEffect2(Square from, Square to) const{
      assert(from.isOnBoard() && to.isOnBoard());
      Offset32 offset32=Offset32(to,from).blackOffset32<P>();
      return longEffect2[offset32.index()];
    }
  };

  extern const Liberty8Table Liberty8_Table;
} // namespace effect
} // namespace osl
#endif /* _LIBERTY8TABLE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:

