/* gameState.h
 */
#ifndef OSL_GAMESTATE_H
#define OSL_GAMESTATE_H

#include "osl/state/numEffectState.h"
#include "osl/stl/vector.h"
#include <boost/scoped_ptr.hpp>
#include <boost/shared_ptr.hpp>
namespace osl
{
  class Sennichite;
  class RepetitionCounter;
  namespace state
  {
    class SimpleState;
  }
  namespace container
  {
    class MoveStack;
    class MoveVector;
  }
  namespace hash
  {
    class HashKeyStack;
  }
  namespace game_playing
  {
    /**
     * State と千日手状態などを一元管理
     */
    class GameState
    {
    private:
      struct State;
      boost::scoped_ptr<State> stack;
      explicit GameState(const State& src);
    public:
      explicit GameState(const SimpleState& initial_state);
      ~GameState();

      enum MoveType { VALID, PAWN_DROP_FOUL, UNSAFE_KING, OTHER_INVALID };
      MoveType isIllegal(Move m) const;
      const Sennichite pushMove(Move m, int eval=0);
      const Move popMove();
      bool canPopMove() const;

      const NumEffectState& state() const;
      const RepetitionCounter& counter() const;
      const container::MoveStack& moveHistory() const;
      const hash::HashKeyStack& hashHistory() const;
      int moves() const;
      int chessMoves() const { return moves() / 2 + 1; }
      const SimpleState& getInitialState() const;

      /**
       * GameState のコピーを作る．
       * 現在の局面を初期局面として扱うため，
       * pushMoveしない限りpopMoveはできない
       */
      const boost::shared_ptr<GameState> clone() const;

      const vector<int>& evalStack() const;
      void generateNotLosingMoves(container::MoveVector& normal_or_win_or_draw, 
				  container::MoveVector& loss) const;
      void generateMoves(container::MoveVector& normal_moves, 
			 container::MoveVector& win, 
			 container::MoveVector& draw, 
			 container::MoveVector& loss) const;
    };
  } // namespace game_playing
} // namespace osl

#endif /* OSL_GAMESTATE_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
