/* moveLogProbVector.t.cc
 */
#include "osl/container/moveLogProbVector.h"
#include "osl/move_generator/allMoves.h"
#include "osl/move_action/store.h"
#include "osl/record/csaString.h"
#include "osl/state/numEffectState.h"
#include "osl/container/moveVector.h"
#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>
#include <set>

class MoveLogProbVectorTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(MoveLogProbVectorTest);
  CPPUNIT_TEST(testSortByProbability);
  CPPUNIT_TEST_SUITE_END();
 public:
  void testSortByProbability();
  bool isSorted(const osl::MoveLogProbVector& moves) const;
};

using namespace osl;
CPPUNIT_TEST_SUITE_REGISTRATION(MoveLogProbVectorTest);

bool sameElements(const MoveLogProbVector& l, const MoveLogProbVector& r)
{
  typedef std::set<MoveLogProb> set_t;
  set_t s1(l.begin(), l.end());
  set_t s2(r.begin(), r.end());
  CPPUNIT_ASSERT_EQUAL(s1.size(), l.size());
  CPPUNIT_ASSERT_EQUAL(s2.size(), r.size());
  return s1 == s2;
}

bool MoveLogProbVectorTest::isSorted(const MoveLogProbVector& moves) const
{
  int limit = 8000;
  for (MoveLogProbVector::const_iterator p=moves.begin(); p!=moves.end(); ++p)
  {
    if (limit < p->logProb())
      return false;
    limit = p->logProb();
  }
  return true;
}

void MoveLogProbVectorTest::testSortByProbability()
{
  using namespace move_action;
  using namespace move_generator;
  NumEffectState state((CsaString(
			  "P1+NY+TO *  *  *  * -OU-KE-KY\n"
			  "P2 *  *  *  *  * -GI-KI *  *\n"
			  "P3 * +RY *  * +UM * -KI-FU-FU\n"
			  "P4 *  * +FU-FU *  *  *  *  *\n"
			  "P5 *  * -KE * +FU *  * +FU *\n"
			  "P6-KE *  * +FU+GI-FU *  * +FU\n"
			  "P7 *  * -UM *  *  *  *  *  *\n"
			  "P8 *  *  *  *  *  *  *  *  * \n"
			  "P9 * +OU * -GI *  *  *  * -NG\n"
			  "P+00HI00KI00KE00KY00FU00FU00FU00FU00FU00FU\n"
			  "P-00KI00KY00FU00FU\n"
			  "P-00AL\n"
			  "+\n").getInitialState()));

  MoveVector moves;
  {
    Store store(moves);
    AllMoves<Store>::generate(BLACK, state, store);
  }

  MoveLogProbVector v;
  MoveLogProbVector v2;
  for (MoveVector::const_iterator p=moves.begin(); p!=moves.end(); ++p)
  {
    v.push_back(*p, 100);
    v2.push_back(*p, 100);
  }
  CPPUNIT_ASSERT(v.size() > 100);
  CPPUNIT_ASSERT_EQUAL(v.size(), v2.size());

  // ごちゃごちゃしても指手が消えたりしないことの確認
  CPPUNIT_ASSERT(sameElements(v, v2));
  v.sortByProbability();
  assert(isSorted(v));
  CPPUNIT_ASSERT(sameElements(v, v2));
  v.sortByProbability();
  CPPUNIT_ASSERT(sameElements(v, v2));
  v.sortByProbabilityReverse();
  CPPUNIT_ASSERT(sameElements(v, v2));
  v.sortByProbability();
  assert(isSorted(v));
  CPPUNIT_ASSERT(sameElements(v, v2));
  v.sortByProbabilityReverse();
  CPPUNIT_ASSERT(sameElements(v, v2));
  v2.sortByProbabilityReverse();
  CPPUNIT_ASSERT(sameElements(v, v2));
}

/* ------------------------------------------------------------------------- */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
