#include "osl/game_playing/alphaBetaPlayer.h"
#include "osl/game_playing/gameState.h"
#include "osl/eval/ml/openMidEndingEval.h"
#include "osl/record/csaString.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

using namespace osl;
using namespace osl::game_playing;

class AlphaBetaOpenMidEndingEvalPlayerTest : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(AlphaBetaOpenMidEndingEvalPlayerTest);
  CPPUNIT_TEST(testResign);
  CPPUNIT_TEST(testWin);
  CPPUNIT_TEST_SUITE_END();
public:
  void testResign();
  void testWin();
};

CPPUNIT_TEST_SUITE_REGISTRATION(AlphaBetaOpenMidEndingEvalPlayerTest);

static void load()
{
  static bool loaded = osl::eval::ml::OpenMidEndingEval::setUp();
  CPPUNIT_ASSERT(loaded);
  static bool loaded_progress = osl::progress::ml::NewProgress::setUp();
  CPPUNIT_ASSERT(loaded_progress);
}

const int seconds = 5;
void AlphaBetaOpenMidEndingEvalPlayerTest::testResign()
{
  load();
  const SimpleState state(CsaString(
			 "P1 *  *  *  * -OU *  *  *  * \n"
			 "P2 *  *  *  * +KI *  *  *  * \n"
			 "P3 *  *  *  * +FU *  *  *  * \n"
			 "P4 *  *  *  *  *  *  *  *  * \n"
			 "P5 *  *  *  *  *  *  *  *  * \n"
			 "P6 *  *  *  *  *  *  *  *  * \n"
			 "P7 *  *  *  *  *  *  *  *  * \n"
			 "P8 *  *  *  *  *  *  *  *  * \n"
			 "P9 *  *  *  * +OU *  *  *  * \n"
			 "P-00AL\n"
			 "-\n").getInitialState());
  const GameState gs(state);
  AlphaBeta2OpenMidEndingEvalPlayer player;
  const MoveWithComment best_move = player.selectBestMove(gs, 1500, seconds, 0);
  CPPUNIT_ASSERT_EQUAL(Move::INVALID(), best_move.move);
}

void AlphaBetaOpenMidEndingEvalPlayerTest::testWin()
{
  load();
  const SimpleState state(CsaString(
			 "P1 *  *  *  * -OU *  *  *  * \n"
			 "P2 *  *  *  *  *  *  *  *  * \n"
			 "P3 *  *  *  * +FU *  *  *  * \n"
			 "P4 *  *  *  *  *  *  *  *  * \n"
			 "P5 *  *  *  *  *  *  *  *  * \n"
			 "P6 *  *  *  *  *  *  *  *  * \n"
			 "P7 *  *  *  *  *  *  *  *  * \n"
			 "P8 *  *  *  *  *  *  *  *  * \n"
			 "P9 *  *  *  * +OU *  *  *  * \n"
			 "P+00KI\n"
			 "P-00AL\n"
			 "+\n").getInitialState());
  const GameState gs(state);
  AlphaBeta2OpenMidEndingEvalPlayer player;
  const MoveWithComment best_move = player.selectBestMove(gs, 1500, seconds, 0);
  const Move expected(Square(5,2), GOLD, BLACK);
  CPPUNIT_ASSERT_EQUAL(expected, best_move.move);
}

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
