/*
Copyright (c) 2003-2008 Rudi Cilibrasi, Rulers of the RHouse
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. Neither the name of the University nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE RULERS AND CONTRIBUTORS ``AS IS'' AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.  IN NO EVENT SHALL THE RULERS OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
SUCH DAMAGE.
*/

#include <stdio.h>
#include <string.h>
#include <assert.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <stdlib.h>
#include <getopt.h>
#include <glib.h>
#include <gmodule.h>
#include <libintl.h>
#include "qsearch/qsearch.h"

#define _(O) gettext(O)

static void print_help_and_exit(void)
{
  printf(_("Usage: qsearch-config [options]\n"));
  printf("  --prefix\n");
  printf("  --exec-prefix\n");
  printf("  --libs\n");
  printf("  --cflags\n");
  printf("  --api-version\n");
  printf("  --version\n");
  printf("  --help\n");
  exit(0);
}

static char *fixup(const char *inp)
{
  char *str = strdup(inp);
  if (strncmp(inp, "${prefix}", 9) == 0) {
    str = calloc(strlen(inp) + 100, 1);
    sprintf(str, "%s%s", "/usr/local", inp + 9);
  }
  return str;
}


int main(int argc, char **argv)
{
  static struct option long_options[] = {
    {"prefix", 0, 0, 'p'},
    {"exec-prefix", 0, 0, 'e'},
    {"api-version", 0, 0, 'a'},
    {"libs", 0, 0, 'l'},
    {"cflags", 0, 0, 'c'},
    {"version", 0, 0, 'v'},
    {"help", 0, 0, 'h'},
    {NULL, 0, 0, 0 }
  };
  int c;
  if (argc <= 1)
    print_help_and_exit();
  while (1) {
    int option_index = 0;
    c = getopt_long(argc, argv, "pavhlce", long_options, &option_index);
    if (c == -1)
      break;
    switch (c) {
      default:
        print_help_and_exit();
        break;
      case 'h':
        print_help_and_exit();
        break;
      case 'l':
        printf("-L%s/lib -lqsearch\n", fixup("${prefix}"));
        break;
      case 'c':
        printf("-I%s/include/qsearch-1.0\n", "/usr/local");
        break;
      case 'e':
        printf("%s\n", fixup("${prefix}"));
        break;
      case 'p':
        printf("%s\n", "/usr/local");
        break;
      case 'a':
        printf("1\n");
        break;
      case 'v':
        printf("%s\n", qsearch_package_version);
        break;
    }
  }
  exit(0);
}
