//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qitemeditorfactory_c.h"

QWidgetH QItemEditorCreatorBase_createWidget(QItemEditorCreatorBaseH handle, QWidgetH parent)
{
	return (QWidgetH) ((QItemEditorCreatorBase *)handle)->createWidget((QWidget*)parent);
}

void QItemEditorCreatorBase_valuePropertyName(QItemEditorCreatorBaseH handle, QByteArrayH retval)
{
	*(QByteArray *)retval = ((QItemEditorCreatorBase *)handle)->valuePropertyName();
}

QItemEditorFactoryH QItemEditorFactory_create()
{
	return (QItemEditorFactoryH) new QItemEditorFactory();
}

void QItemEditorFactory_destroy(QItemEditorFactoryH handle)
{
	delete (QItemEditorFactory *)handle;
}

QWidgetH QItemEditorFactory_createEditor(QItemEditorFactoryH handle, QVariant::Type type, QWidgetH parent)
{
	return (QWidgetH) ((QItemEditorFactory *)handle)->createEditor(type, (QWidget*)parent);
}

void QItemEditorFactory_valuePropertyName(QItemEditorFactoryH handle, QByteArrayH retval, QVariant::Type type)
{
	*(QByteArray *)retval = ((QItemEditorFactory *)handle)->valuePropertyName(type);
}

void QItemEditorFactory_registerEditor(QItemEditorFactoryH handle, QVariant::Type type, QItemEditorCreatorBaseH creator)
{
	((QItemEditorFactory *)handle)->registerEditor(type, (QItemEditorCreatorBase*)creator);
}

const QItemEditorFactoryH QItemEditorFactory_defaultFactory()
{
	return (const QItemEditorFactoryH) QItemEditorFactory::defaultFactory();
}

void QItemEditorFactory_setDefaultFactory(QItemEditorFactoryH factory)
{
	QItemEditorFactory::setDefaultFactory((QItemEditorFactory*)factory);
}

