//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QSSLCONFIGURATION_C_H
#define QSSLCONFIGURATION_C_H

#include <QtNetwork>
#include "pascalbind.h"

C_EXPORT QSslConfigurationH QSslConfiguration_create();
C_EXPORT void QSslConfiguration_destroy(QSslConfigurationH handle);
C_EXPORT QSslConfigurationH QSslConfiguration_create2(const QSslConfigurationH other);
C_EXPORT bool QSslConfiguration_isNull(QSslConfigurationH handle);
C_EXPORT QSsl::SslProtocol QSslConfiguration_protocol(QSslConfigurationH handle);
C_EXPORT void QSslConfiguration_setProtocol(QSslConfigurationH handle, QSsl::SslProtocol protocol);
C_EXPORT QSslSocket::PeerVerifyMode QSslConfiguration_peerVerifyMode(QSslConfigurationH handle);
C_EXPORT void QSslConfiguration_setPeerVerifyMode(QSslConfigurationH handle, QSslSocket::PeerVerifyMode mode);
C_EXPORT int QSslConfiguration_peerVerifyDepth(QSslConfigurationH handle);
C_EXPORT void QSslConfiguration_setPeerVerifyDepth(QSslConfigurationH handle, int depth);
C_EXPORT void QSslConfiguration_localCertificate(QSslConfigurationH handle, QSslCertificateH retval);
C_EXPORT void QSslConfiguration_setLocalCertificate(QSslConfigurationH handle, const QSslCertificateH certificate);
C_EXPORT void QSslConfiguration_peerCertificate(QSslConfigurationH handle, QSslCertificateH retval);
C_EXPORT void QSslConfiguration_sessionCipher(QSslConfigurationH handle, QSslCipherH retval);
C_EXPORT void QSslConfiguration_privateKey(QSslConfigurationH handle, QSslKeyH retval);
C_EXPORT void QSslConfiguration_setPrivateKey(QSslConfigurationH handle, const QSslKeyH key);
C_EXPORT void QSslConfiguration_defaultConfiguration(QSslConfigurationH retval);
C_EXPORT void QSslConfiguration_setDefaultConfiguration(const QSslConfigurationH configuration);

#endif
