//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QSTRINGLIST_C_H
#define QSTRINGLIST_C_H

#include <QtCore>
#include "pascalbind.h"

C_EXPORT QStringListH QStringList_create();
C_EXPORT void QStringList_destroy(QStringListH handle);
C_EXPORT QStringListH QStringList_create2(PWideString i);
C_EXPORT QStringListH QStringList_create3(const QStringListH l);
C_EXPORT void QStringList_sort(QStringListH handle);
C_EXPORT int QStringList_removeDuplicates(QStringListH handle);
C_EXPORT void QStringList_join(QStringListH handle, PWideString retval, PWideString sep);
C_EXPORT void QStringList_filter(QStringListH handle, QStringListH retval, PWideString str, Qt::CaseSensitivity cs);
C_EXPORT QBool QStringList_contains(QStringListH handle, PWideString str, Qt::CaseSensitivity cs);
C_EXPORT QStringListH QStringList_replaceInStrings(QStringListH handle, PWideString before, PWideString after, Qt::CaseSensitivity cs);
C_EXPORT void QStringList_filter2(QStringListH handle, QStringListH retval, const QRegExpH rx);
C_EXPORT QStringListH QStringList_replaceInStrings2(QStringListH handle, const QRegExpH rx, PWideString after);
C_EXPORT int QStringList_indexOf(QStringListH handle, const QRegExpH rx, int from);
C_EXPORT int QStringList_lastIndexOf(QStringListH handle, const QRegExpH rx, int from);
C_EXPORT int QStringList_size(QStringListH handle);
C_EXPORT bool QStringList_isEmpty(QStringListH handle);
C_EXPORT void QStringList_clear(QStringListH handle);
C_EXPORT void QStringList_at(QStringListH handle, PWideString retval, int i);
C_EXPORT void QStringList_append(QStringListH handle, PWideString s);
C_EXPORT void QStringList_prepend(QStringListH handle, PWideString s);
C_EXPORT void QStringList_insert(QStringListH handle, int i, PWideString s);
C_EXPORT void QStringList_replace(QStringListH handle, int i, PWideString s);
C_EXPORT void QStringList_removeAt(QStringListH handle, int i);
C_EXPORT int QStringList_removeAll(QStringListH handle, PWideString s);
C_EXPORT void QStringList_takeAt(QStringListH handle, PWideString retval, int i);
C_EXPORT void QStringList_takeFirst(QStringListH handle, PWideString retval);
C_EXPORT void QStringList_takeLast(QStringListH handle, PWideString retval);
C_EXPORT void QStringList_move(QStringListH handle, int from, int to);
C_EXPORT void QStringList_swap(QStringListH handle, int i, int j);

#endif
