/*
 *  Copyright (c) 2008 Cyrille Berger <cberger@cberger.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation;
 * version 2 of the license.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _QTSHIVA_PROXY_P_H_
#define _QTSHIVA_PROXY_P_H_

#include <QObject>
#include <GTLCore/String.h>

#include "ParametersWidgetBase.h"

#include <GTLCore/Metadata/ParameterEntry.h>

namespace OpenShiva {
  class Kernel;
}

class QColor;

namespace QtShiva {
  class Proxy : public QObject {
    Q_OBJECT
    public:
      Proxy( QObject* parent, const GTLCore::String& _name, ParametersWidgetBase::Parametrisation* _kernel, GTLCore::Metadata::ParameterEntry::WidgetType _type );
      ~Proxy();
    public slots:
      void setIntValue( int );
      void setDoubleValue( double );
      void setRgb( const QColor& );
      void setRgba( const QColor& );
    public:
      void setValue( const GTLCore::Value& value);
    signals:
      void intValueChanged( int );
      void doubleValueChanged( double );
      void rgbValueChanged( const QColor& );
      void rgbaValueChanged( const QColor& );
    private:
      GTLCore::String m_name;
      ParametersWidgetBase::Parametrisation* m_kernel;
      GTLCore::Metadata::ParameterEntry::WidgetType m_type;
  };
}

#endif
